/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.types.GoArrayType;
import ghidra.app.util.bin.format.golang.rtti.types.GoBaseType;
import ghidra.app.util.bin.format.golang.rtti.types.GoChanType;
import ghidra.app.util.bin.format.golang.rtti.types.GoFuncType;
import ghidra.app.util.bin.format.golang.rtti.types.GoInterfaceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoKind;
import ghidra.app.util.bin.format.golang.rtti.types.GoMapType;
import ghidra.app.util.bin.format.golang.rtti.types.GoMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoPlainType;
import ghidra.app.util.bin.format.golang.rtti.types.GoPointerType;
import ghidra.app.util.bin.format.golang.rtti.types.GoSliceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructType;
import ghidra.app.util.bin.format.golang.rtti.types.GoTypeDetector;
import ghidra.app.util.bin.format.golang.rtti.types.GoUncommonType;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.FieldOutput;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.PlateComment;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Undefined;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

@PlateComment
public abstract class GoType
implements StructureMarkup<GoType> {
    private static final Map<GoKind, Class<? extends GoType>> specializedTypeClasses = Map.ofEntries(Map.entry(GoKind.Struct, GoStructType.class), Map.entry(GoKind.Pointer, GoPointerType.class), Map.entry(GoKind.Func, GoFuncType.class), Map.entry(GoKind.Slice, GoSliceType.class), Map.entry(GoKind.Array, GoArrayType.class), Map.entry(GoKind.Chan, GoChanType.class), Map.entry(GoKind.Map, GoMapType.class), Map.entry(GoKind.Interface, GoInterfaceType.class));
    @ContextField
    protected GoRttiMapper programContext;
    @ContextField
    protected StructureContext<GoType> context;
    @FieldMapping
    @Markup
    @FieldOutput
    protected GoBaseType typ;

    public static Class<? extends GoType> getSpecializedTypeClass(GoRttiMapper programContext, long offset) throws IOException {
        GoTypeDetector typeDetector = programContext.readStructure(GoTypeDetector.class, offset);
        Class<? extends GoType> result = specializedTypeClasses.get((Object)typeDetector.getKind());
        if (result == null) {
            result = GoPlainType.class;
        }
        return result;
    }

    public GoBaseType getBaseType() {
        return this.typ;
    }

    public String getDebugId() {
        return "%s@%s".formatted(this.context.getMappingInfo().getDescription(), this.context.getStructureAddress());
    }

    protected long getOffsetEndOfFullType() {
        return this.context.getStructureEnd() + (long)(this.typ.hasUncommonType() ? this.programContext.getStructureMappingInfo(GoUncommonType.class).getStructureLength() : 0);
    }

    @Markup
    public GoUncommonType getUncommonType() throws IOException {
        return this.typ.hasUncommonType() ? this.programContext.readStructure(GoUncommonType.class, this.context.getStructureEnd()) : null;
    }

    @Override
    public StructureContext<GoType> getStructureContext() {
        return this.context;
    }

    @Override
    public String getStructureName() throws IOException {
        return this.typ.getNameString();
    }

    @Override
    public void additionalMarkup() throws IOException {
        GoUncommonType uncommonType = this.getUncommonType();
        if (uncommonType != null) {
            GoSlice slice = uncommonType.getMethodsSlice();
            slice.markupArray(this.getStructureName() + "_methods", GoMethod.class, false);
            slice.markupArrayElements(GoMethod.class);
            this.programContext.labelStructure(uncommonType, this.typ.getNameString() + "_" + this.programContext.getStructureDataTypeName(GoUncommonType.class));
        }
    }

    public String getMethodListString() throws IOException {
        GoUncommonType uncommonType = this.getUncommonType();
        if (uncommonType == null || uncommonType.mcount == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (GoMethod method : uncommonType.getMethods()) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            String methodStr = method.getNameString();
            GoType type = method.getType();
            if (type instanceof GoFuncType) {
                GoFuncType funcType = (GoFuncType)type;
                methodStr = funcType.getFuncPrototypeString(methodStr);
            } else {
                methodStr = "func %s()".formatted(methodStr);
            }
            sb.append(methodStr);
        }
        return sb.toString();
    }

    protected String getTypeDeclString() throws IOException {
        String s = "type " + this.typ.getNameString() + " " + this.typ.getKind();
        String methodListString = this.getMethodListString();
        if (!methodListString.isEmpty()) {
            s = s + "\n// Methods\n" + methodListString;
        }
        return s;
    }

    public String toString() {
        try {
            return this.getTypeDeclString();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public DataType recoverDataType() throws IOException {
        DataType dt = Undefined.getUndefinedDataType((int)((int)this.typ.getSize()));
        return new TypedefDataType(this.programContext.getRecoveredTypesCp(), this.typ.getNameString(), dt, this.programContext.getDTM());
    }

    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!discoveredTypes.add(this.context.getStructureStart())) {
            return false;
        }
        GoUncommonType uncommonType = this.getUncommonType();
        if (uncommonType != null) {
            for (GoMethod method : uncommonType.getMethods()) {
                GoType methodType = method.getType();
                if (methodType == null) continue;
                methodType.discoverGoTypes(discoveredTypes);
            }
        }
        return true;
    }
}

