/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.address.Address;
import java.io.IOException;

@StructureMapping(structureName="string")
public class GoString {
    @ContextField
    private StructureContext<GoString> context;
    @FieldMapping
    @MarkupReference(value="stringAddr")
    @EOLComment(value="stringValue")
    private long str;
    @FieldMapping
    private long len;

    public Address getStringAddr() {
        return this.context.getDataTypeMapper().getDataAddress(this.str);
    }

    public long getLength() {
        return this.len;
    }

    public String getStringValue() throws IOException {
        BinaryReader reader = this.context.getDataTypeMapper().getReader(this.str);
        return reader.readNextUtf8String((int)this.len);
    }
}

