/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.DWARFRange;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf4.funcfixup.DWARFFunctionFixup;
import ghidra.app.util.bin.format.dwarf4.next.DIEAMonitoredIterator;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataInstanceHelper;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataTypeManager;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunction;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportOptions;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf4.next.DWARFNameInfo;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.DWARFSourceInfo;
import ghidra.app.util.bin.format.dwarf4.next.DWARFVariable;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DWARFFunctionImporter {
    private static final int INLINE_FUNC_SHORT_LEN = 8;
    private final DWARFProgram prog;
    private final Program currentProgram;
    private final DWARFDataTypeManager dwarfDTM;
    private final DWARFImportOptions importOptions;
    private final DWARFImportSummary importSummary;
    private ProgramModule rootModule;
    private Set<Long> processedOffsets = new HashSet<Long>();
    private Set<Address> functionsProcessed = new HashSet<Address>();
    private Set<Address> variablesProcesesed = new HashSet<Address>();
    private List<DWARFFunctionFixup> functionFixups = DWARFFunctionFixup.findFixups();
    private TaskMonitor monitor;

    public static boolean hasDWARFProgModule(Program prog, String progModuleName) {
        ProgramModule dwarfModule = prog.getListing().getRootModule(progModuleName);
        return dwarfModule != null;
    }

    public DWARFFunctionImporter(DWARFProgram prog, TaskMonitor monitor) {
        this.prog = prog;
        this.monitor = monitor;
        this.currentProgram = prog.getGhidraProgram();
        this.dwarfDTM = prog.getDwarfDTM();
        this.importOptions = prog.getImportOptions();
        this.importSummary = prog.getImportSummary();
    }

    private boolean shouldProcess(DIEAggregate diea) {
        if (this.processedOffsets.contains(diea.getOffset())) {
            return false;
        }
        this.processedOffsets.add(diea.getOffset());
        return true;
    }

    public void importFunctions() throws CancelledException {
        this.rootModule = this.currentProgram.getListing().getRootModule("DWARF");
        if (this.rootModule == null) {
            try {
                this.rootModule = this.currentProgram.getListing().createRootModule("DWARF");
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
        }
        for (DIEAggregate diea : DIEAMonitoredIterator.iterable(this.prog, "DWARF - Create Funcs & Symbols", this.monitor)) {
            this.monitor.checkCancelled();
            try {
                switch (diea.getTag()) {
                    case 72: 
                    case 16649: {
                        diea = DIEAggregate.createSkipHead(diea);
                    }
                    case 46: {
                        try {
                            this.processSubprogram(diea);
                        }
                        catch (InvalidInputException e) {
                            Msg.error((Object)this, (Object)("Failed to process subprog " + diea.getHexOffset()), (Throwable)e);
                        }
                        break;
                    }
                    case 52: {
                        if (diea.getDepth() != 1) break;
                        this.outputGlobal(DWARFVariable.readGlobalVariable(diea));
                        break;
                    }
                    case 10: {
                        this.processLabel(diea);
                    }
                }
            }
            catch (OutOfMemoryError oom) {
                throw oom;
            }
            catch (Throwable th) {
                Msg.error((Object)this, (Object)("Error when processing DWARF information for DIE " + diea.getHexOffset()), (Throwable)th);
                Msg.info((Object)this, (Object)("DIE info:\n" + diea.toString()));
            }
        }
        this.logImportErrorSummary();
    }

    private void logImportErrorSummary() {
        if (!this.importSummary.unknownRegistersEncountered.isEmpty()) {
            Msg.error((Object)this, (Object)("Found " + this.importSummary.unknownRegistersEncountered.size() + " unknown registers referenced in DWARF expression operands:"));
            ArrayList<Integer> sortedUnknownRegs = new ArrayList<Integer>(this.importSummary.unknownRegistersEncountered);
            Collections.sort(sortedUnknownRegs);
            Msg.error((Object)this, (Object)("  unknown registers: " + sortedUnknownRegs.stream().map(i -> Integer.toString(i)).collect(Collectors.joining(", "))));
        }
    }

    private void markAllChildrenAsProcessed(DebugInfoEntry die) {
        for (DebugInfoEntry child : die.getChildren()) {
            this.processedOffsets.add(child.getOffset());
            this.markAllChildrenAsProcessed(child);
        }
    }

    private void processSubprogram(DIEAggregate diea) throws IOException, InvalidInputException, DWARFExpressionException {
        if (diea == null || !this.shouldProcess(diea)) {
            return;
        }
        DWARFFunction dfunc = DWARFFunction.read(diea);
        if (dfunc == null) {
            this.markAllChildrenAsProcessed(diea.getHeadFragment());
            return;
        }
        FunctionDefinition origFuncDef = dfunc.asFuncDef();
        if (this.functionsProcessed.contains(dfunc.address)) {
            this.markAllChildrenAsProcessed(dfunc.diea.getHeadFragment());
            Function currentFunction = this.currentProgram.getListing().getFunctionAt(dfunc.address);
            if (currentFunction != null) {
                this.decorateFunctionWithAlternateInfo(dfunc, currentFunction, origFuncDef);
            }
            return;
        }
        this.functionsProcessed.add(dfunc.address);
        this.processFuncChildren(diea, dfunc, 0L);
        Function gfunc = this.createFunction(dfunc, diea);
        if (gfunc == null) {
            return;
        }
        if (gfunc.hasNoReturn() && !dfunc.noReturn) {
            dfunc.noReturn = true;
        }
        for (DWARFFunctionFixup fixup : this.functionFixups) {
            try {
                fixup.fixupDWARFFunction(dfunc, gfunc);
            }
            catch (DWARFException e) {
                dfunc.signatureCommitMode = DWARFFunction.CommitMode.SKIP;
                break;
            }
        }
        this.decorateFunctionWithDWARFInfo(dfunc, gfunc, origFuncDef);
        if (dfunc.signatureCommitMode != DWARFFunction.CommitMode.SKIP) {
            this.updateFunctionSignature(gfunc, dfunc);
        } else {
            Msg.error((Object)this, (Object)String.format("Failed to get DWARF function signature information, leaving undefined: %s@%s", gfunc.getName(), gfunc.getEntryPoint()));
            Msg.debug((Object)this, (Object)("DIE info: " + diea.toString()));
        }
        for (DWARFVariable localVar : dfunc.localVars) {
            if (localVar.isRamStorage()) {
                this.outputGlobal(localVar);
                continue;
            }
            dfunc.commitLocalVariable(localVar, gfunc);
        }
    }

    private void decorateFunctionWithAlternateInfo(DWARFFunction dfunc, Function gfunc, FunctionDefinition funcDef) {
        String newAlternatePrototype = funcDef.getPrototypeString(false);
        String currentPrototype = gfunc.getSignature(true).getPrototypeString(false);
        if (!currentPrototype.equals(newAlternatePrototype)) {
            this.appendPlateComment(dfunc.address, "DWARF alternate signature: ", newAlternatePrototype);
        }
    }

    private void decorateFunctionWithDWARFInfo(DWARFFunction dfunc, Function gfunc, FunctionDefinition origFuncDef) {
        if (dfunc.sourceInfo != null) {
            this.moveIntoFragment(gfunc.getName(), dfunc.address, dfunc.highAddress != null ? dfunc.highAddress : dfunc.address.add(1L), dfunc.sourceInfo.getFilename());
            if (this.importOptions.isOutputSourceLocationInfo()) {
                this.appendPlateComment(dfunc.address, "", dfunc.sourceInfo.getDescriptionStr());
            }
        }
        if (this.importOptions.isOutputDIEInfo()) {
            this.appendPlateComment(dfunc.address, "DWARF DIE: ", dfunc.diea.getHexOffset());
            this.appendPlateComment(dfunc.address, "DWARF signature update mode: ", dfunc.signatureCommitMode.toString());
        }
        if (dfunc.name.isNameModified()) {
            this.appendPlateComment(dfunc.address, "DWARF original name: ", dfunc.name.getOriginalName());
        }
        FunctionDefinition newFuncDef = dfunc.asFuncDef();
        String origFuncDefStr = origFuncDef.getPrototypeString(true);
        if (!newFuncDef.getPrototypeString(true).equals(origFuncDefStr)) {
            this.appendPlateComment(dfunc.address, "DWARF original prototype: ", origFuncDefStr);
        }
    }

    private void updateFunctionSignature(Function gfunc, DWARFFunction dfunc) {
        try {
            boolean includeStorageDetail = dfunc.signatureCommitMode == DWARFFunction.CommitMode.STORAGE;
            Function.FunctionUpdateType functionUpdateType = includeStorageDetail ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS;
            Parameter returnVar = dfunc.retval.asReturnParameter(includeStorageDetail);
            List<Parameter> parameters = dfunc.getParameters(includeStorageDetail);
            if (includeStorageDetail && !dfunc.retval.isZeroByte() && dfunc.retval.isMissingStorage()) {
                gfunc.updateFunction(dfunc.getCallingConventionName(), (Variable)returnVar, List.of(), Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.IMPORTED);
                returnVar = null;
            }
            gfunc.updateFunction(dfunc.getCallingConventionName(), (Variable)returnVar, parameters, functionUpdateType, true, SourceType.IMPORTED);
            gfunc.setVarArgs(dfunc.varArg);
            gfunc.setNoReturn(dfunc.noReturn);
        }
        catch (DuplicateNameException | InvalidInputException e) {
            Msg.error((Object)this, (Object)String.format("Error updating function %s@%s with params: %s", gfunc.getName(), gfunc.getEntryPoint().toString(), e.getMessage()));
            Msg.error((Object)this, (Object)("DIE info: " + dfunc.diea.toString()));
        }
    }

    private void processFuncChildren(DIEAggregate diea, DWARFFunction dfunc, long offsetFromFuncStart) throws InvalidInputException, IOException, DWARFExpressionException {
        block7: for (DebugInfoEntry childEntry : diea.getHeadFragment().getChildren()) {
            DIEAggregate childDIEA = this.prog.getAggregate(childEntry);
            switch (childDIEA.getTag()) {
                case 52: {
                    if (offsetFromFuncStart < 0L) break;
                    DWARFVariable localVar = DWARFVariable.readLocalVariable(childDIEA, dfunc, offsetFromFuncStart);
                    if (localVar == null) continue block7;
                    dfunc.localVars.add(localVar);
                    break;
                }
                case 11: {
                    this.processLexicalBlock(childDIEA, dfunc);
                    break;
                }
                case 10: {
                    this.processLabel(childDIEA);
                    break;
                }
                case 29: {
                    this.processInlinedSubroutine(childDIEA, dfunc);
                    break;
                }
                case 72: 
                case 16649: {
                    DIEAggregate partDIEA = DIEAggregate.createSkipHead(diea);
                    this.processSubprogram(partDIEA);
                }
            }
        }
    }

    private void outputGlobal(DWARFVariable globalVar) {
        if (globalVar == null) {
            return;
        }
        Namespace namespace = globalVar.name.getParentNamespace(this.currentProgram);
        String name = globalVar.name.getName();
        Address address = globalVar.getRamAddress();
        DataType dataType = globalVar.type;
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        Symbol labelSym = null;
        if (globalVar.isZeroByte() || !this.variablesProcesesed.contains(address)) {
            try {
                labelSym = symbolTable.createLabel(address, name, namespace, SourceType.IMPORTED);
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)String.format("Error creating label for global variable %s/%s at %s", namespace, name, address));
                return;
            }
        }
        if (globalVar.isZeroByte()) {
            this.appendComment(address, 1, String.format("Zero length variable: %s: %s", name, dataType.getDisplayName()), "\n");
            return;
        }
        if (this.variablesProcesesed.contains(address)) {
            return;
        }
        labelSym.setPrimary();
        if (globalVar.isExternal) {
            this.setExternalEntryPoint(true, address);
        }
        try {
            DWARFDataInstanceHelper dih;
            if (dataType instanceof Dynamic || dataType instanceof FactoryDataType) {
                this.appendComment(address, 0, "Unsupported dynamic data type: " + dataType, "\n");
                dataType = Undefined.getUndefinedDataType((int)1);
            }
            if (!(dih = new DWARFDataInstanceHelper(this.currentProgram)).isDataTypeCompatibleWithAddress(dataType, address)) {
                this.appendComment(address, 0, String.format("Could not place DWARF static variable %s: %s @%s because existing data type conflicts.", globalVar.name.getName(), dataType.getName(), address), "\n");
            } else {
                Data varData = DataUtilities.createData((Program)this.currentProgram, (Address)address, (DataType)dataType, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
                if (varData != null && globalVar.sourceInfo != null) {
                    this.moveIntoFragment(name, varData.getMinAddress(), varData.getMaxAddress(), globalVar.sourceInfo.getFilename());
                }
                this.variablesProcesesed.add(address);
            }
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)("Error creating data object at " + address), (Throwable)e);
        }
        ++this.importSummary.globalVarsAdded;
        if (globalVar.sourceInfo != null) {
            this.appendComment(address, 0, globalVar.sourceInfo.getDescriptionStr(), "\n");
        }
    }

    private void processLexicalBlock(DIEAggregate diea, DWARFFunction dfunc) throws IOException, InvalidInputException, DWARFExpressionException {
        Address blockStart;
        if (!this.shouldProcess(diea)) {
            return;
        }
        Long lowPC = null;
        boolean disjoint = false;
        if (diea.hasAttribute(17) && diea.hasAttribute(18)) {
            lowPC = diea.getLowPC(0L);
        } else if (diea.hasAttribute(85)) {
            List<DWARFRange> ranges = diea.parseDebugRange(85);
            if (ranges.isEmpty()) {
                return;
            }
            lowPC = ranges.get(0).getFrom();
            disjoint = ranges.size() > 1;
        }
        Address address = blockStart = lowPC != null ? this.prog.getCodeAddress(lowPC) : null;
        if (blockStart != null && this.importOptions.isOutputLexicalBlockComments()) {
            DWARFNameInfo dni = this.prog.getName(diea);
            this.appendComment(blockStart, 1, "Begin: " + dni.getName() + (disjoint ? " - Disjoint" : ""), "\n");
        }
        this.processFuncChildren(diea, dfunc, blockStart != null ? blockStart.subtract(dfunc.address) : -1L);
    }

    private void processInlinedSubroutine(DIEAggregate diea, DWARFFunction dfunc) throws IOException, InvalidInputException, DWARFExpressionException {
        if (!this.shouldProcess(diea)) {
            return;
        }
        Long lowPC = null;
        Long highPC = null;
        if (diea.hasAttribute(17) && diea.hasAttribute(18)) {
            lowPC = diea.getLowPC(0L);
            highPC = diea.getHighPC();
        } else if (diea.hasAttribute(85)) {
            List<DWARFRange> ranges = diea.parseDebugRange(85);
            if (ranges.isEmpty()) {
                return;
            }
            lowPC = ranges.get(0).getFrom();
            highPC = ranges.get(ranges.size() - 1).getTo();
        } else {
            return;
        }
        Address startAddr = this.prog.getCodeAddress(lowPC);
        Address endAddr = this.prog.getCodeAddress(highPC);
        if (this.importOptions.isOutputInlineFuncComments()) {
            this.addCommentsForInlineFunc(diea, startAddr, endAddr);
        }
        this.processFuncChildren(diea, dfunc, startAddr.subtract(dfunc.address));
    }

    private void addCommentsForInlineFunc(DIEAggregate diea, Address blockStart, Address blockEnd) {
        FunctionDefinition funcDef = this.dwarfDTM.getFunctionSignature(diea);
        if (funcDef != null) {
            boolean isShort;
            long inlineFuncLen = blockEnd.subtract(blockStart);
            boolean bl = isShort = inlineFuncLen < 8L;
            if (isShort) {
                this.appendComment(blockStart, 0, "inline " + funcDef.getPrototypeString(), "; ");
            } else {
                this.appendComment(blockStart, 1, "Begin: inline " + funcDef.getPrototypeString(), "\n");
            }
        }
    }

    private void appendComment(Address address, int commentType, String comment, String sep) {
        DWARFUtil.appendComment(this.currentProgram, address, commentType, "", comment, sep);
    }

    private void appendPlateComment(Address address, String prefix, String comment) {
        DWARFUtil.appendComment(this.currentProgram, address, 3, prefix, comment, "\n");
    }

    private void setExternalEntryPoint(boolean external, Address address) {
        if (external) {
            this.currentProgram.getSymbolTable().addExternalEntryPoint(address);
        } else {
            this.currentProgram.getSymbolTable().removeExternalEntryPoint(address);
        }
    }

    private void moveIntoFragment(String name, Address start, Address end, String fileName) {
        if (fileName != null) {
            ProgramModule module = null;
            int index = this.rootModule.getIndex(fileName);
            if (index == -1) {
                try {
                    module = this.rootModule.createModule(fileName);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Error while moving fragment " + name + " from " + start + " to " + end), (Throwable)e);
                    return;
                }
            } else {
                Group[] children = this.rootModule.getChildren();
                module = (ProgramModule)children[index];
            }
            if (module != null) {
                try {
                    ProgramFragment frag = null;
                    index = module.getIndex(name);
                    if (index == -1) {
                        frag = module.createFragment(name);
                    } else {
                        Group[] children = module.getChildren();
                        frag = (ProgramFragment)children[index];
                    }
                    frag.move(start, end);
                }
                catch (NotFoundException e) {
                    Msg.error((Object)this, (Object)("Error moving fragment from " + start + " to " + end), (Throwable)e);
                    return;
                }
                catch (DuplicateNameException duplicateNameException) {
                    // empty catch block
                }
            }
        }
    }

    private Function createFunction(DWARFFunction dfunc, DIEAggregate diea) {
        try {
            SymbolTable symbolTable = this.currentProgram.getSymbolTable();
            symbolTable.createLabel(dfunc.address, dfunc.name.getName(), dfunc.namespace, SourceType.IMPORTED);
            SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(dfunc.address, dfunc.name.getName(), dfunc.namespace);
            cmd.applyTo((DomainObject)this.currentProgram);
            this.setExternalEntryPoint(dfunc.isExternal, dfunc.address);
            Function function = this.currentProgram.getListing().getFunctionAt(dfunc.address);
            if (function == null) {
                if (!this.currentProgram.getMemory().getLoadedAndInitializedAddressSet().contains(dfunc.address)) {
                    Msg.warn((Object)this, (Object)String.format("DWARF: unable to create function not contained within loaded memory: %s@%s", dfunc.name, dfunc.address));
                    return null;
                }
                function = this.currentProgram.getFunctionManager().createFunction(null, dfunc.address, (AddressSetView)new AddressSet(dfunc.address), SourceType.IMPORTED);
            }
            return function;
        }
        catch (OverlappingFunctionException e) {
            throw new AssertException((Throwable)e);
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Failed to create function " + dfunc.namespace + "/" + dfunc.name.getName() + ": " + e.getMessage()));
            return null;
        }
    }

    private void processLabel(DIEAggregate diea) {
        Address address;
        if (!this.shouldProcess(diea)) {
            return;
        }
        String name = this.prog.getEntryName(diea);
        if (name != null && diea.hasAttribute(17) && (address = this.prog.getCodeAddress(diea.getLowPC(0L))).getOffset() != 0L) {
            try {
                SymbolTable symbolTable = this.currentProgram.getSymbolTable();
                symbolTable.createLabel(address, name, this.currentProgram.getGlobalNamespace(), SourceType.IMPORTED);
                String locationInfo = DWARFSourceInfo.getDescriptionStr(diea);
                if (locationInfo != null) {
                    this.appendComment(address, 0, locationInfo, "; ");
                }
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Problem creating label at " + address + " with name " + name), (Throwable)e);
            }
        }
    }
}

