/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import ghidra.app.plugin.core.memory.ExpandBlockModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;

class ExpandBlockUpModel
extends ExpandBlockModel {
    ExpandBlockUpModel(PluginTool tool, Program program) {
        super(tool, program);
    }

    @Override
    void setStartAddress(Address addr) {
        this.message = "";
        this.startAddr = addr;
        if (this.startAddr == null) {
            this.message = "Invalid Address";
        } else if (this.startAddr.compareTo((Object)this.block.getStart()) >= 0) {
            this.message = "Start must be less than " + this.block.getStart();
        } else {
            this.length = this.block.getEnd().subtract(this.startAddr) + 1L;
        }
        this.listener.stateChanged(null);
    }

    @Override
    void setEndAddress(Address addr) {
    }

    @Override
    void setLength(long length) {
        this.message = "";
        this.length = length;
        if (this.isValidLength()) {
            try {
                this.startAddr = this.block.getEnd().subtractNoWrap(length - 1L);
            }
            catch (Exception e) {
                this.message = "Expanded block is too large";
            }
        }
        this.listener.stateChanged(null);
    }

    @Override
    boolean execute() {
        block4: {
            this.message = "";
            try {
                this.length = this.block.getStart().subtract(this.startAddr);
                if (this.length == 0L) {
                    return true;
                }
                if (this.length != this.block.getSize() || this.startAddr.compareTo((Object)this.block.getStart()) != 0) {
                    return this.expandBlock();
                }
            }
            catch (Exception e) {
                this.message = e.getMessage();
                if (this.message != null) break block4;
                this.message = e.toString();
            }
        }
        return false;
    }
}

