/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import docking.widgets.button.GRadioButton;
import ghidra.app.plugin.core.instructionsearch.ui.ControlPanelWidget;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SearchDirectionWidget
extends ControlPanelWidget {
    private JRadioButton forwardRB;
    private JRadioButton backwardRB;
    private Direction searchDirection = Direction.FORWARD;
    private InstructionSearchDialog dialog;

    public SearchDirectionWidget(String title, InstructionSearchDialog dialog) {
        super(title);
        this.dialog = dialog;
    }

    public Direction getSearchDirection() {
        return this.searchDirection;
    }

    @Override
    protected JPanel createContent() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 0));
        contentPanel.setAlignmentX(0.0f);
        this.forwardRB = this.createSearchRB(new ForwardSearchAction(), "Forward", "When active, searches will be performed in the forward direction.");
        this.forwardRB.setSelected(true);
        contentPanel.add(this.forwardRB);
        this.backwardRB = this.createSearchRB(new BackwardSearchAction(), "Backward", "When active, searches will be performed in the backward direction.");
        contentPanel.add(this.backwardRB);
        ButtonGroup group = new ButtonGroup();
        group.add(this.forwardRB);
        group.add(this.backwardRB);
        return contentPanel;
    }

    private JRadioButton createSearchRB(AbstractAction action, String name, String tooltip) {
        GRadioButton button = new GRadioButton((Action)action);
        button.setText(name);
        button.setToolTipText(tooltip);
        button.setAlignmentX(0.0f);
        return button;
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }

    private class ForwardSearchAction
    extends AbstractAction {
        private ForwardSearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SearchDirectionWidget.this.searchDirection = Direction.FORWARD;
            if (SearchDirectionWidget.this.dialog.getMessagePanel() != null) {
                SearchDirectionWidget.this.dialog.getMessagePanel().clear();
            }
        }
    }

    private class BackwardSearchAction
    extends AbstractAction {
        private BackwardSearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SearchDirectionWidget.this.searchDirection = Direction.BACKWARD;
            if (SearchDirectionWidget.this.dialog.getMessagePanel() != null) {
                SearchDirectionWidget.this.dialog.getMessagePanel().clear();
            }
        }
    }
}

