/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions.associate;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSyncDialog;
import ghidra.app.plugin.core.datamgr.DataTypeSyncInfo;
import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskBuilder;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class SyncAction
extends DockingAction
implements Comparable<SyncAction> {
    private final SourceArchive sourceArchive;
    private final DataTypeManager dtm;
    private final DataTypeManagerHandler handler;
    private final DataTypeManagerPlugin plugin;
    private final ArchiveNode archiveNode;

    SyncAction(String name, DataTypeManagerPlugin plugin, DataTypeManagerHandler handler, DataTypeManager dtm, ArchiveNode archiveNode, SourceArchive sourceArchive, boolean isEnabled) {
        super(name, plugin.getName());
        this.plugin = plugin;
        this.handler = handler;
        this.dtm = dtm;
        this.archiveNode = archiveNode;
        this.sourceArchive = sourceArchive;
        this.setEnabled(isEnabled);
    }

    protected abstract int getMenuOrder();

    protected abstract boolean isAppropriateForAction(DataTypeSyncInfo var1);

    protected abstract boolean isPreselectedForAction(DataTypeSyncInfo var1);

    protected abstract String getOperationName();

    protected abstract void applyOperation(DataTypeSyncInfo var1);

    protected abstract String getConfirmationMessage(List<DataTypeSyncInfo> var1);

    protected abstract boolean requiresArchiveOpenForEditing();

    protected abstract String getTitle(String var1, String var2);

    protected abstract String getHelpTopic();

    public boolean isEnabledForContext(ActionContext context) {
        return context instanceof DataTypesActionContext;
    }

    public void actionPerformed(ActionContext context) {
        if (!this.dtm.isUpdatable()) {
            this.showRequiresArchiveOpenMessage(this.dtm.getName());
            return;
        }
        DataTypeManager sourceDTM = this.handler.getDataTypeManager(this.sourceArchive);
        if (sourceDTM == null) {
            Msg.showInfo(this.getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"Cannot Access Source Archive", (Object)("Can't access the data types for the " + this.sourceArchive.getName() + " archive."));
            return;
        }
        if (this.requiresArchiveOpenForEditing() && !sourceDTM.isUpdatable()) {
            this.showRequiresArchiveOpenMessage(this.sourceArchive.getName());
            return;
        }
        DataTypeSynchronizer synchronizer = new DataTypeSynchronizer(this.handler, this.dtm, this.sourceArchive);
        TaskBuilder.withTask((Task)new SyncTask(synchronizer)).setStatusTextAlignment(10).launchModal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSync(DataTypeSynchronizer synchronizer, TaskMonitor monitor) {
        DataTypesProvider provider = this.plugin.getProvider();
        DataTypeArchiveGTree tree = provider.getGTree();
        GTreeState treeState = tree.getTreeState();
        try {
            tree.collapseAll((GTreeNode)this.archiveNode);
            monitor.setMessage("Finding out-of-sync types");
            HashSet<DataTypeSyncInfo> outOfSynchDataTypes = new HashSet<DataTypeSyncInfo>(synchronizer.findOutOfSynchDataTypes());
            this.removeAndUpdateOutOfSyncInTimeOnlyDataTypes(synchronizer, outOfSynchDataTypes);
            if (outOfSynchDataTypes.isEmpty()) {
                this.showNoDataTypesToSyncMessage();
                return;
            }
            List<DataTypeSyncInfo> filteredList = this.filterList(outOfSynchDataTypes);
            if (filteredList.isEmpty()) {
                this.showNoDataTypesForThisOperationMessage(this.sourceArchive.getName(), outOfSynchDataTypes);
                return;
            }
            Set<DataTypeSyncInfo> preselectedInfos = this.getPreselectedInfos(filteredList);
            List<DataTypeSyncInfo> selectedList = this.getSelectedDataTypes(synchronizer, filteredList, preselectedInfos);
            if (selectedList.isEmpty()) {
                return;
            }
            if (!this.confirmOperation(selectedList)) {
                return;
            }
            monitor.initialize((long)selectedList.size());
            this.processSelectedDataTypes(synchronizer, selectedList, outOfSynchDataTypes, monitor);
            HashSet<DataTypeSyncInfo> outOfSynchDataTypesAfterProcessed = new HashSet<DataTypeSyncInfo>(synchronizer.findOutOfSynchDataTypes());
            this.reportAnyLeftOverOutOfSyncDataTypes(this.sourceArchive.getName(), outOfSynchDataTypesAfterProcessed);
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            tree.restoreTreeState(treeState);
        }
    }

    private Set<DataTypeSyncInfo> getPreselectedInfos(List<DataTypeSyncInfo> list) {
        HashSet<DataTypeSyncInfo> set = new HashSet<DataTypeSyncInfo>();
        for (DataTypeSyncInfo dataTypeSyncInfo : list) {
            if (!this.isPreselectedForAction(dataTypeSyncInfo)) continue;
            set.add(dataTypeSyncInfo);
        }
        return set;
    }

    private void reportAnyLeftOverOutOfSyncDataTypes(String archiveName, Set<DataTypeSyncInfo> outOfSynchDataTypes) {
        if (outOfSynchDataTypes.isEmpty()) {
            return;
        }
        String status = this.getStatusMessage(outOfSynchDataTypes);
        Msg.showInfo(this.getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)("Archive \"" + archiveName + "\" Not Synchronized"), (Object)("There are still datatypes that are out of sync!\n\n" + status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSelectedDataTypes(DataTypeSynchronizer synchronizer, List<DataTypeSyncInfo> selectedList, Set<DataTypeSyncInfo> outOfSynchDataTypes, TaskMonitor monitor) throws CancelledException {
        synchronizer.openTransactions();
        try {
            for (DataTypeSyncInfo info : selectedList) {
                monitor.checkCancelled();
                monitor.setMessage("Syncing " + info.getName());
                this.applyOperation(info);
                outOfSynchDataTypes.remove(info);
                monitor.incrementProgress(1L);
            }
            HashSet<DataTypeSyncInfo> outOfSynchDataTypesAfterProcessed = new HashSet<DataTypeSyncInfo>(synchronizer.findOutOfSynchDataTypes());
            this.removeAndUpdateOutOfSyncInTimeOnlyDataTypes(synchronizer, outOfSynchDataTypesAfterProcessed);
            if (outOfSynchDataTypesAfterProcessed.isEmpty()) {
                synchronizer.markSynchronized();
            }
        }
        finally {
            synchronizer.closeTransactions();
        }
    }

    private boolean confirmOperation(List<DataTypeSyncInfo> selectedList) {
        int result = OptionDialog.showYesNoDialog((Component)this.plugin.getTool().getToolFrame(), (String)("Confirm " + this.getOperationName()), (String)this.getConfirmationMessage(selectedList));
        return result == 1;
    }

    private List<DataTypeSyncInfo> getSelectedDataTypes(DataTypeSynchronizer synchronizer, List<DataTypeSyncInfo> filteredList, Set<DataTypeSyncInfo> preselectedInfos) {
        String clientName = synchronizer.getClientName();
        String sourceName = synchronizer.getSourceName();
        DataTypeSyncDialog dialog = new DataTypeSyncDialog(this.plugin, clientName, sourceName, filteredList, preselectedInfos, this.getOperationName(), this.getTitle(sourceName, clientName));
        dialog.setHelpLocation(new HelpLocation(this.plugin.getName(), this.getHelpTopic()));
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog);
        return dialog.getSelectedInfos();
    }

    private void showNoDataTypesForThisOperationMessage(String archiveName, Set<DataTypeSyncInfo> outOfSyncInfos) {
        String status = this.getStatusMessage(outOfSyncInfos);
        Msg.showInfo(this.getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"No Data Type Changes", (Object)("No data types found to " + this.getOperationName() + " for archive \"" + archiveName + "\".\n\n" + status));
    }

    private void showRequiresArchiveOpenMessage(String archiveName) {
        Msg.showError(this.getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)(this.getOperationName() + " Failed"), (Object)("Archive \"" + archiveName + "\" must be open for editing."));
    }

    private String getStatusMessage(Set<DataTypeSyncInfo> outOfSyncInfos) {
        int orphanCount = 0;
        int conflictCount = 0;
        int updateCount = 0;
        int commitCount = 0;
        for (DataTypeSyncInfo info : outOfSyncInfos) {
            switch (info.getSyncState()) {
                case COMMIT: {
                    ++commitCount;
                    break;
                }
                case CONFLICT: {
                    ++conflictCount;
                    break;
                }
                case ORPHAN: {
                    ++orphanCount;
                    break;
                }
                case UPDATE: {
                    ++updateCount;
                }
            }
        }
        StringBuilder buf = new StringBuilder();
        if (updateCount > 0) {
            buf.append("\nNumber of UPDATES remaining:   " + updateCount);
        }
        if (commitCount > 0) {
            buf.append("\nNumber of COMMITS remaining:   " + commitCount);
        }
        if (conflictCount > 0) {
            buf.append("\nNumber of CONFLICTS remaining: " + conflictCount);
        }
        if (orphanCount > 0) {
            buf.append("\nNumber of ORPHANS remaining:   " + orphanCount);
        }
        return buf.toString();
    }

    private void showNoDataTypesToSyncMessage() {
        Msg.showInfo(this.getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"No Data Type Changes", (Object)"No out of sync data types found. Updating sync time.");
    }

    @Override
    public int compareTo(SyncAction o) {
        return this.getMenuOrder() - o.getMenuOrder();
    }

    protected List<DataTypeSyncInfo> filterList(Set<DataTypeSyncInfo> allOutOfSyncDataTypes) {
        ArrayList<DataTypeSyncInfo> filteredList = new ArrayList<DataTypeSyncInfo>();
        for (DataTypeSyncInfo dataTypeSyncInfo : allOutOfSyncDataTypes) {
            if (!this.isAppropriateForAction(dataTypeSyncInfo)) continue;
            filteredList.add(dataTypeSyncInfo);
        }
        return filteredList;
    }

    private void removeAndUpdateOutOfSyncInTimeOnlyDataTypes(DataTypeSynchronizer synchronizer, Set<DataTypeSyncInfo> outOfSynchDataTypes) {
        ArrayList<DataTypeSyncInfo> list = new ArrayList<DataTypeSyncInfo>();
        Iterator<DataTypeSyncInfo> iterator = outOfSynchDataTypes.iterator();
        while (iterator.hasNext()) {
            DataTypeSyncInfo dataTypeSyncInfo = iterator.next();
            if (dataTypeSyncInfo.hasChange()) continue;
            list.add(dataTypeSyncInfo);
            iterator.remove();
        }
        this.autoUpdateDataTypesThatHaveNoRealChanges(synchronizer, list, outOfSynchDataTypes.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoUpdateDataTypesThatHaveNoRealChanges(DataTypeSynchronizer synchronizer, List<DataTypeSyncInfo> outOfSynchInTimeOnlyList, boolean markArchiveSynchronized) {
        int transactionID = this.dtm.startTransaction("Auto-sync data types");
        try {
            for (DataTypeSyncInfo dataTypeSyncInfo : outOfSynchInTimeOnlyList) {
                dataTypeSyncInfo.syncTimes();
            }
            if (markArchiveSynchronized) {
                synchronizer.markSynchronized();
            }
        }
        finally {
            this.dtm.endTransaction(transactionID, true);
        }
    }

    protected boolean containsConflicts(List<DataTypeSyncInfo> infos) {
        for (DataTypeSyncInfo dataTypeSyncInfo : infos) {
            if (dataTypeSyncInfo.getSyncState() != DataTypeSyncState.CONFLICT) continue;
            return true;
        }
        return false;
    }

    private class SyncTask
    extends Task {
        private DataTypeSynchronizer synchronizer;

        public SyncTask(DataTypeSynchronizer synchronizer) {
            super("Data Type Sync - " + SyncAction.this.getOperationName(), true, true, true);
            this.synchronizer = synchronizer;
        }

        public void run(TaskMonitor monitor) {
            SyncAction.this.doSync(this.synchronizer, monitor);
        }
    }
}

