/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.KeyBindingPrecedence;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeNodeTransferable;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.BuiltInArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeDragNDropHandler;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeTreeCopyMoveTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.task.Task;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class PasteAction
extends DockingAction {
    private PluginTool tool;
    private Clipboard clipboard;
    private final DataTypeManagerPlugin plugin;

    public PasteAction(DataTypeManagerPlugin plugin) {
        super("Paste", plugin.getName());
        this.plugin = plugin;
        this.clipboard = plugin.getClipboard();
        this.tool = plugin.getTool();
        this.setPopupMenuData(new MenuData(new String[]{"Paste"}, "Edit"));
        this.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(86, 128), KeyBindingPrecedence.ActionMapLevel));
    }

    public boolean isAddToPopup(ActionContext context) {
        DataTypeTreeNode node = this.getSelectedDataTypeTreeNode(context);
        if (node instanceof BuiltInArchiveNode) {
            return false;
        }
        return node != null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        DataTypeTreeNode node = this.getSelectedDataTypeTreeNode(context);
        if (node == null) {
            return false;
        }
        List<GTreeNode> transferNodeList = this.getNodesFromClipboard();
        return this.canPaste(node, transferNodeList);
    }

    private DataTypeTreeNode getSelectedDataTypeTreeNode(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return null;
        }
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return null;
        }
        if (selectionPaths.length > 1) {
            return null;
        }
        DataTypeTreeNode node = (DataTypeTreeNode)((Object)selectionPaths[0].getLastPathComponent());
        return node;
    }

    private boolean canPaste(DataTypeTreeNode destinationNode, List<GTreeNode> transferNodeList) {
        if (transferNodeList.isEmpty()) {
            return false;
        }
        if (this.hasInvalidCutNodes(destinationNode, transferNodeList)) {
            return false;
        }
        DataTypesProvider provider = this.plugin.getProvider();
        DataTypeArchiveGTree tree = provider.getGTree();
        DataTypeDragNDropHandler handler = (DataTypeDragNDropHandler)tree.getDragNDropHandler();
        if (!destinationNode.canPaste(transferNodeList)) {
            return false;
        }
        DataFlavor[] flavors = handler.getSupportedDataFlavors(transferNodeList);
        return handler.isValidDataTypeDestination((GTreeNode)destinationNode, flavors, 1);
    }

    private boolean hasInvalidCutNodes(DataTypeTreeNode destinationNode, List<GTreeNode> nodeList) {
        DataTypeTreeNode node = (DataTypeTreeNode)nodeList.get(0);
        if (!node.isCut()) {
            return false;
        }
        ArchiveNode destinationArchiveNode = destinationNode.getArchiveNode();
        for (GTreeNode cutNode : nodeList) {
            DataTypeTreeNode dataTypeTreeNode = (DataTypeTreeNode)cutNode;
            ArchiveNode archiveNode = dataTypeTreeNode.getArchiveNode();
            if (archiveNode == destinationArchiveNode) continue;
            return true;
        }
        return false;
    }

    private List<GTreeNode> getNodesFromClipboard() {
        Transferable transferable = this.clipboard.getContents((Object)this);
        if (transferable instanceof GTreeNodeTransferable) {
            GTreeNodeTransferable gtTransferable = (GTreeNodeTransferable)transferable;
            return gtTransferable.getAllData();
        }
        return Collections.emptyList();
    }

    public void actionPerformed(ActionContext context) {
        List<GTreeNode> nodeList = this.getNodesFromClipboard();
        if (nodeList.isEmpty()) {
            return;
        }
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        CategoryNode destinationNode = this.getDropTargetNode(selectionPaths);
        DataTypeTreeNode dataTypeTreeNode = (DataTypeTreeNode)nodeList.get(0);
        if (dataTypeTreeNode.isCut()) {
            this.clipboard.setContents(null, null);
        }
        DataTypeTreeCopyMoveTask.ActionType actionType = this.getActionType(dataTypeTreeNode);
        DataTypeTreeCopyMoveTask task = new DataTypeTreeCopyMoveTask(destinationNode, nodeList, actionType, (DataTypeArchiveGTree)gTree, this.plugin.getConflictHandler());
        this.tool.execute((Task)task, 250);
    }

    private CategoryNode getDropTargetNode(TreePath[] selectionPaths) {
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (node instanceof CategoryNode) {
            return (CategoryNode)node;
        }
        return (CategoryNode)node.getParent();
    }

    private DataTypeTreeCopyMoveTask.ActionType getActionType(DataTypeTreeNode pasteNode) {
        if (pasteNode.isCut()) {
            return DataTypeTreeCopyMoveTask.ActionType.MOVE;
        }
        return DataTypeTreeCopyMoveTask.ActionType.COPY;
    }
}

