/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.plugin.core.decompile.actions.PCodeDfgDisplayListener;
import ghidra.app.plugin.core.decompile.actions.PCodeDfgDisplayOptions;
import ghidra.app.plugin.core.decompile.actions.PCodeDfgGraphType;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphType;
import ghidra.service.graph.VertexShape;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.GraphException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PCodeDfgGraphTask
extends Task {
    private GraphDisplayBroker graphService;
    protected HighFunction hfunction;
    private AttributedGraph graph;
    private PluginTool tool;

    public PCodeDfgGraphTask(PluginTool tool, GraphDisplayBroker graphService, HighFunction hfunction) {
        super("Graph AST", true, false, true);
        this.graphService = graphService;
        this.hfunction = hfunction;
        this.tool = tool;
    }

    public void run(TaskMonitor monitor) {
        try {
            this.buildAndDisplayGraph(monitor);
        }
        catch (GraphException e) {
            Msg.showError((Object)((Object)this), null, (String)"Graph Error", (Object)("Can't create graph display: " + e.getMessage()), (Throwable)e);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private void buildAndDisplayGraph(TaskMonitor monitor) throws GraphException, CancelledException {
        PCodeDfgGraphType graphType = new PCodeDfgGraphType();
        Function func = this.hfunction.getFunction();
        this.graph = new AttributedGraph("Data Flow Graph", (GraphType)graphType);
        this.buildGraph();
        GraphDisplay graphDisplay = this.graphService.getDefaultGraphDisplay(false, monitor);
        PCodeDfgDisplayOptions displayOptions = new PCodeDfgDisplayOptions(this.tool);
        String description = "AST Data Flow Graph For " + func.getName();
        graphDisplay.setGraph(this.graph, (GraphDisplayOptions)displayOptions, description, false, monitor);
        graphDisplay.setGraphDisplayListener((GraphDisplayListener)new PCodeDfgDisplayListener(this.tool, graphDisplay, this.hfunction, func.getProgram()));
    }

    protected void buildGraph() {
        HashMap<Integer, AttributedVertex> vertices = new HashMap<Integer, AttributedVertex>();
        Iterator<PcodeOpAST> opiter = this.getPcodeOpIterator();
        while (opiter.hasNext()) {
            AttributedVertex outv;
            PcodeOpAST op = opiter.next();
            AttributedVertex o = this.createOpVertex(op);
            for (int i = 0; i < op.getNumInputs(); ++i) {
                VarnodeAST vn;
                int opcode = op.getOpcode();
                if (i == 0 && (opcode == 2 || opcode == 3) || i == 1 && opcode == 61 || (vn = (VarnodeAST)op.getInput(i)) == null) continue;
                AttributedVertex v = this.getVarnodeVertex(vertices, vn);
                this.createEdge(v, o);
            }
            VarnodeAST outvn = (VarnodeAST)op.getOutput();
            if (outvn == null || (outv = this.getVarnodeVertex(vertices, outvn)) == null) continue;
            this.createEdge(o, outv);
        }
    }

    private String getVarnodeKey(VarnodeAST vn) {
        PcodeOp op = vn.getDef();
        String id = op != null ? op.getSeqnum().getTarget().toString(true) + " v " + Integer.toString(vn.getUniqueId()) : "i v " + Integer.toString(vn.getUniqueId());
        return id;
    }

    protected AttributedVertex createVarnodeVertex(VarnodeAST vn) {
        String name = vn.getAddress().toString(true);
        String id = this.getVarnodeKey(vn);
        String vertexType = PCodeDfgGraphType.DEFAULT_VERTEX;
        if (vn.isConstant()) {
            vertexType = PCodeDfgGraphType.CONSTANT;
        } else if (vn.isRegister()) {
            vertexType = PCodeDfgGraphType.REGISTER;
            Register reg = this.hfunction.getFunction().getProgram().getRegister(vn.getAddress(), vn.getSize());
            if (reg != null) {
                name = reg.getName();
            }
        } else if (vn.isUnique()) {
            vertexType = PCodeDfgGraphType.UNIQUE;
        } else if (vn.isPersistent()) {
            vertexType = PCodeDfgGraphType.PERSISTENT;
        } else if (vn.isAddrTied()) {
            vertexType = PCodeDfgGraphType.ADDRESS_TIED;
        }
        AttributedVertex vert = this.graph.addVertex(id, name);
        vert.setVertexType(vertexType);
        if (vn.isInput()) {
            vert.setAttribute("Shape", VertexShape.TRIANGLE_DOWN.getName());
        }
        return vert;
    }

    protected AttributedVertex getVarnodeVertex(Map<Integer, AttributedVertex> vertices, VarnodeAST vn) {
        AttributedVertex res = vertices.get(vn.getUniqueId());
        if (res == null) {
            res = this.createVarnodeVertex(vn);
            vertices.put(vn.getUniqueId(), res);
        }
        return res;
    }

    protected AttributedEdge createEdge(AttributedVertex in, AttributedVertex out) {
        AttributedEdge newEdge = this.graph.addEdge(in, out);
        newEdge.setEdgeType(PCodeDfgGraphType.DEFAULT_EDGE);
        return newEdge;
    }

    protected AttributedVertex createOpVertex(PcodeOpAST op) {
        PcodeOp indOp;
        Varnode vn;
        Object name = op.getMnemonic();
        String id = this.getOpKey(op);
        int opcode = op.getOpcode();
        if (opcode == 2 || opcode == 3) {
            vn = op.getInput(0);
            AddressSpace addrspace = this.hfunction.getFunction().getProgram().getAddressFactory().getAddressSpace((int)vn.getOffset());
            name = (String)name + " " + addrspace.getName();
        } else if (opcode == 61 && (vn = op.getInput(1)) != null && (indOp = this.hfunction.getOpRef((int)vn.getOffset())) != null) {
            name = (String)name + " (" + indOp.getMnemonic() + ")";
        }
        AttributedVertex vert = this.graph.addVertex(id, (String)name);
        vert.setVertexType(PCodeDfgGraphType.OP);
        return vert;
    }

    protected Iterator<PcodeOpAST> getPcodeOpIterator() {
        Iterator opiter = this.hfunction.getPcodeOps();
        return opiter;
    }

    private String getOpKey(PcodeOpAST op) {
        SequenceNumber sq = op.getSeqnum();
        String id = sq.getTarget().toString(true) + " o " + Integer.toString(op.getSeqnum().getTime());
        return id;
    }
}

