/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.AbstractOptions;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsEditor;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;

public class SubOptions
implements Options {
    private AbstractOptions options;
    private String prefix;
    private String name;

    public SubOptions(AbstractOptions options, String name, String prefix) {
        this.options = options;
        this.name = name;
        this.prefix = prefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public PropertyEditor getPropertyEditor(String optionName) {
        return this.options.getPropertyEditor(this.prefix + optionName);
    }

    @Override
    public PropertyEditor getRegisteredPropertyEditor(String optionName) {
        return this.options.getRegisteredPropertyEditor(this.prefix + optionName);
    }

    @Override
    public List<Options> getChildOptions() {
        List<String> optionPaths = this.getOptionNames();
        Set<String> childCategories = AbstractOptions.getChildCategories(optionPaths);
        ArrayList<Options> childOptions = new ArrayList<Options>(childCategories.size());
        for (String categoryName : childCategories) {
            childOptions.add(new SubOptions(this.options, categoryName, this.prefix + categoryName + "."));
        }
        return childOptions;
    }

    @Override
    public HelpLocation getHelpLocation(String optionName) {
        return this.options.getHelpLocation(this.prefix + optionName);
    }

    @Override
    public void registerOption(String optionName, Object defaultValue, HelpLocation help, String description) {
        this.options.registerOption(this.prefix + optionName, defaultValue, help, description);
    }

    @Override
    public void registerOption(String optionName, OptionType type, Object defaultValue, HelpLocation help, String description) {
        this.options.registerOption(this.prefix + optionName, type, defaultValue, help, description);
    }

    @Override
    public void registerOption(String optionName, OptionType type, Object defaultValue, HelpLocation help, String description, PropertyEditor editor) {
        this.options.registerOption(this.prefix + optionName, type, defaultValue, help, description, editor);
    }

    @Override
    public void registerThemeColorBinding(String optionName, String colorId, HelpLocation help, String description) {
        this.options.registerThemeColorBinding(this.prefix + optionName, colorId, help, description);
    }

    @Override
    public void registerThemeFontBinding(String optionName, String fontId, HelpLocation help, String description) {
        this.options.registerThemeFontBinding(this.prefix + optionName, fontId, help, description);
    }

    @Override
    public void putObject(String optionName, Object obj) {
        this.options.putObject(this.prefix + optionName, obj);
    }

    @Override
    public Object getObject(String optionName, Object defaultValue) {
        return this.options.getObject(this.prefix + optionName, defaultValue);
    }

    @Override
    public boolean getBoolean(String optionName, boolean defaultValue) {
        return this.options.getBoolean(this.prefix + optionName, defaultValue);
    }

    @Override
    public byte[] getByteArray(String optionName, byte[] defaultValue) {
        return this.options.getByteArray(this.prefix + optionName, defaultValue);
    }

    @Override
    public int getInt(String optionName, int defaultValue) {
        return this.options.getInt(this.prefix + optionName, defaultValue);
    }

    @Override
    public double getDouble(String optionName, double defaultValue) {
        return this.options.getDouble(this.prefix + optionName, defaultValue);
    }

    @Override
    public float getFloat(String optionName, float defaultValue) {
        return this.options.getFloat(this.prefix + optionName, defaultValue);
    }

    @Override
    public long getLong(String optionName, long defaultValue) {
        return this.options.getLong(this.prefix + optionName, defaultValue);
    }

    @Override
    public CustomOption getCustomOption(String optionName, CustomOption defaultValue) {
        return this.options.getCustomOption(this.prefix + optionName, defaultValue);
    }

    @Override
    public Color getColor(String optionName, Color defaultValue) {
        return this.options.getColor(this.prefix + optionName, defaultValue);
    }

    @Override
    public File getFile(String optionName, File defaultValue) {
        return this.options.getFile(this.prefix + optionName, defaultValue);
    }

    @Override
    public Font getFont(String optionName, Font defaultValue) {
        return this.options.getFont(this.prefix + optionName, defaultValue);
    }

    @Override
    public KeyStroke getKeyStroke(String optionName, KeyStroke defaultValue) {
        return this.options.getKeyStroke(this.prefix + optionName, defaultValue);
    }

    @Override
    public String getString(String optionName, String defaultValue) {
        return this.options.getString(this.prefix + optionName, defaultValue);
    }

    @Override
    public <T extends Enum<T>> T getEnum(String optionName, T defaultValue) {
        return this.options.getEnum(this.prefix + optionName, defaultValue);
    }

    @Override
    public void setLong(String optionName, long value) {
        this.options.setLong(this.prefix + optionName, value);
    }

    @Override
    public void setBoolean(String optionName, boolean value) {
        this.options.setBoolean(this.prefix + optionName, value);
    }

    @Override
    public void setInt(String optionName, int value) {
        this.options.setInt(this.prefix + optionName, value);
    }

    @Override
    public void setDouble(String optionName, double value) {
        this.options.setDouble(this.prefix + optionName, value);
    }

    @Override
    public void setFloat(String optionName, float value) {
        this.options.setFloat(this.prefix + optionName, value);
    }

    @Override
    public void setCustomOption(String optionName, CustomOption value) {
        this.options.setCustomOption(this.prefix + optionName, value);
    }

    @Override
    public void setByteArray(String optionName, byte[] value) {
        this.options.setByteArray(this.prefix + optionName, value);
    }

    @Override
    public void setFile(String optionName, File value) {
        this.options.setFile(this.prefix + optionName, value);
    }

    @Override
    public void setColor(String optionName, Color value) {
        this.options.setColor(this.prefix + optionName, value);
    }

    @Override
    public void setFont(String optionName, Font value) {
        this.options.setFont(this.prefix + optionName, value);
    }

    @Override
    public void setKeyStroke(String optionName, KeyStroke value) {
        this.options.setKeyStroke(this.prefix + optionName, value);
    }

    @Override
    public void setString(String optionName, String value) {
        this.options.setString(this.prefix + optionName, value);
    }

    @Override
    public <T extends Enum<T>> void setEnum(String optionName, T value) {
        this.options.setEnum(this.prefix + optionName, value);
    }

    @Override
    public void removeOption(String optionName) {
        this.options.removeOption(this.prefix + optionName);
    }

    @Override
    public List<String> getOptionNames() {
        List<String> allOptionPaths = this.options.getOptionNames();
        ArrayList<String> names = new ArrayList<String>();
        for (String path : allOptionPaths) {
            if (!path.startsWith(this.prefix)) continue;
            names.add(path.substring(this.prefix.length()));
        }
        return names;
    }

    @Override
    public boolean contains(String optionName) {
        return this.options.contains(this.prefix + optionName);
    }

    @Override
    public String getDescription(String optionName) {
        return this.options.getDescription(this.prefix + optionName);
    }

    @Override
    public boolean isRegistered(String optionName) {
        return this.options.isRegistered(this.prefix + optionName);
    }

    @Override
    public boolean isDefaultValue(String optionName) {
        return this.options.isDefaultValue(this.prefix + optionName);
    }

    @Override
    public void restoreDefaultValues() {
        List<String> optionNames = this.getOptionNames();
        for (String optionName : optionNames) {
            this.restoreDefaultValue(optionName);
        }
    }

    @Override
    public void restoreDefaultValue(String optionName) {
        this.options.restoreDefaultValue(this.prefix + optionName);
    }

    @Override
    public OptionType getType(String optionName) {
        return this.options.getType(this.prefix + optionName);
    }

    @Override
    public Options getOptions(String path) {
        int lastIndexOf = path.lastIndexOf(46);
        String subOptionName = lastIndexOf > 0 ? path.substring(lastIndexOf + 1) : path;
        return new SubOptions(this.options, subOptionName, this.prefix + path + ".");
    }

    @Override
    public void setOptionsHelpLocation(HelpLocation helpLocation) {
        this.options.setCategoryHelpLocation(this.prefix, helpLocation);
    }

    @Override
    public HelpLocation getOptionsHelpLocation() {
        return this.options.getCategoryHelpLocation(this.prefix);
    }

    @Override
    public void registerOptionsEditor(OptionsEditor editor) {
        this.options.registerOptionsEditor(this.prefix, editor);
    }

    @Override
    public OptionsEditor getOptionsEditor() {
        return this.options.getOptionsEditor(this.prefix);
    }

    @Override
    public void createAlias(String aliasName, Options otherOptions, String optionsName) {
        this.options.createAlias(this.prefix + aliasName, otherOptions, optionsName);
    }

    @Override
    public boolean isAlias(String aliasName) {
        return this.options.isAlias(this.prefix + aliasName);
    }

    @Override
    public Date getDate(String optionName, Date defaultValue) {
        return this.options.getDate(this.prefix + optionName, defaultValue);
    }

    @Override
    public void setDate(String propertyName, Date value) {
        this.options.setDate(this.prefix + propertyName, value);
    }

    @Override
    public Object getDefaultValue(String optionName) {
        return this.options.getDefaultValue(this.prefix + optionName);
    }

    @Override
    public String getValueAsString(String optionName) {
        return this.options.getValueAsString(this.prefix + optionName);
    }

    @Override
    public String getDefaultValueAsString(String optionName) {
        return this.options.getDefaultValueAsString(this.prefix + optionName);
    }

    AbstractOptions getOptions() {
        return this.options;
    }

    String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getID(String optionName) {
        return this.options.getID(this.prefix + optionName);
    }

    @Override
    public List<String> getLeafOptionNames() {
        List<String> optionPaths = this.getOptionNames();
        Set<String> leaves = AbstractOptions.getLeaves(optionPaths);
        return new ArrayList<String>(leaves);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SubOptions other = (SubOptions)obj;
        if (!this.options.equals(other.options)) {
            return false;
        }
        return this.prefix.equals(other.prefix);
    }

    public int hashCode() {
        return this.prefix.hashCode();
    }
}

