/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.manager.breakpoint;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.WatchpointRequest;
import ghidra.dbg.jdi.manager.breakpoint.JdiBreakpointType;
import java.util.Objects;

public class JdiBreakpointInfo {
    private final EventRequest request;
    private final JdiBreakpointType type;
    private ObjectReference objectFilter;
    private ThreadReference threadFilter;
    private ReferenceType classFilter;
    private String filterPattern;
    private boolean excludePattern;

    public JdiBreakpointInfo(BreakpointRequest request) {
        this.request = request;
        this.type = JdiBreakpointType.BREAKPOINT;
    }

    public JdiBreakpointInfo(AccessWatchpointRequest request) {
        this.request = request;
        this.type = JdiBreakpointType.ACCESS_WATCHPOINT;
    }

    public JdiBreakpointInfo(ModificationWatchpointRequest request) {
        this.request = request;
        this.type = JdiBreakpointType.MODIFICATION_WATCHPOINT;
    }

    public int hashCode() {
        return Objects.hash(this.request);
    }

    public String toString() {
        return this.request.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JdiBreakpointInfo)) {
            return false;
        }
        JdiBreakpointInfo that = (JdiBreakpointInfo)obj;
        return this.request == that.request;
    }

    public JdiBreakpointType getType() {
        return this.type;
    }

    public EventRequest getRequest() {
        return this.request;
    }

    public ObjectReference getObjectFilter() {
        return this.objectFilter;
    }

    public void setObjectFilter(ObjectReference objectFilter) {
        this.objectFilter = objectFilter;
    }

    public ThreadReference getThreadFilter() {
        return this.threadFilter;
    }

    public void setThreadFilter(ThreadReference threadFilter) {
        this.threadFilter = threadFilter;
    }

    public ReferenceType getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(ReferenceType classFilter) {
        this.classFilter = classFilter;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public boolean isEnabled() {
        if (this.request instanceof BreakpointRequest) {
            return ((BreakpointRequest)this.request).isEnabled();
        }
        if (this.request instanceof WatchpointRequest) {
            return ((WatchpointRequest)this.request).isEnabled();
        }
        return false;
    }

    public void setEnabled(boolean b) {
        if (this.request instanceof BreakpointRequest) {
            BreakpointRequest breakpoint = (BreakpointRequest)this.request;
            if (b) {
                breakpoint.enable();
            } else {
                breakpoint.disable();
            }
        }
        if (this.request instanceof WatchpointRequest) {
            WatchpointRequest watchpoint = (WatchpointRequest)this.request;
            if (b) {
                watchpoint.enable();
            } else {
                watchpoint.disable();
            }
        }
    }
}

