/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.AbstractStmt;
import ghidra.pcode.struct.LValInternal;
import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.DataType;

class AssignStmt
extends AbstractStmt
implements RValInternal,
StructuredSleigh.StmtWithVal {
    final LValInternal lhs;
    private final RValInternal rhs;
    private final DataType type;

    private AssignStmt(StructuredSleigh ctx, StructuredSleigh.LVal lhs, StructuredSleigh.RVal rhs, DataType type) {
        super(ctx);
        this.lhs = (LValInternal)lhs;
        this.rhs = (RValInternal)rhs;
        this.type = type;
    }

    public AssignStmt(StructuredSleigh ctx, StructuredSleigh.LVal lhs, StructuredSleigh.RVal rhs) {
        this(ctx, lhs, rhs, lhs.getType());
    }

    @Override
    public StructuredSleigh.RVal cast(DataType type) {
        return new AssignStmt(this.ctx, this.lhs, this.rhs, type);
    }

    public String toString() {
        return "<Assign " + this.lhs + " = " + this.rhs + ">";
    }

    @Override
    protected StringTree generate(StructuredSleigh.Label next, StructuredSleigh.Label fall) {
        StringTree st = new StringTree();
        st.append(this.lhs.generate(this));
        st.append(" = ");
        st.append(this.rhs.generate(this));
        st.append(";\n");
        st.append(next.genGoto(fall));
        return st;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public StringTree generate(RValInternal parent) {
        return this.lhs.generate(this);
    }
}

