/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@DebuggerTargetObjectIface(value="RegisterBank")
public interface TargetRegisterBank
extends TargetObject {
    public static final String DESCRIPTIONS_ATTRIBUTE_NAME = "_descriptions";
    public static final String REGISTERVALS_ATTRIBUTE_NAME = "_register_values";

    @TargetAttributeType(name="_descriptions")
    default public TargetRegisterContainer getDescriptions() {
        return this.getTypedAttributeNowByName(DESCRIPTIONS_ATTRIBUTE_NAME, TargetRegisterContainer.class, null);
    }

    default public CompletableFuture<? extends Map<String, byte[]>> readRegisters(Collection<TargetRegister> registers) {
        return this.readRegistersNamed(registers.stream().map(TargetRegister::getIndex).collect(Collectors.toSet()));
    }

    default public CompletableFuture<Void> writeRegisters(Map<TargetRegister, byte[]> values) {
        LinkedHashMap<String, byte[]> named = new LinkedHashMap<String, byte[]>();
        for (Map.Entry<TargetRegister, byte[]> ent : values.entrySet()) {
            named.put(ent.getKey().getIndex(), ent.getValue());
        }
        return this.writeRegistersNamed(named);
    }

    public CompletableFuture<? extends Map<String, byte[]>> readRegistersNamed(Collection<String> var1);

    public CompletableFuture<Void> writeRegistersNamed(Map<String, byte[]> var1);

    default public CompletableFuture<? extends Map<String, byte[]>> readRegistersNamed(String ... names) {
        return this.readRegistersNamed(List.of(names));
    }

    default public CompletableFuture<byte[]> readRegister(TargetRegister register) {
        return this.readRegister(register.getIndex());
    }

    default public CompletableFuture<Void> writeRegister(TargetRegister register, byte[] value) {
        return this.writeRegistersNamed(Map.of(register.getIndex(), value));
    }

    default public CompletableFuture<byte[]> readRegister(String name) {
        return this.readRegistersNamed(List.of(name)).thenApply(m -> (byte[])m.get(name));
    }

    default public CompletableFuture<Void> writeRegister(String name, byte[] value) {
        return this.writeRegistersNamed(Map.of(name, value));
    }

    default public Map<String, byte[]> getCachedRegisters() {
        return Map.of();
    }

    @Deprecated
    default public void clearRegisterCache() {
        this.invalidateCaches().exceptionally(e -> {
            Msg.error((Object)this, (Object)"Error clearing register caches");
            return null;
        });
    }
}

