/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class TargetObjectPath
implements Comparable<TargetObjectPath> {
    protected final DebuggerObjectModel model;
    protected final List<String> keyList;
    protected final int hash;

    public TargetObjectPath(DebuggerObjectModel model, List<String> keyList) {
        this.model = model;
        this.keyList = keyList;
        this.hash = Objects.hash(model, keyList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TargetObjectPath)) {
            return false;
        }
        TargetObjectPath that = (TargetObjectPath)obj;
        return this.getModel() == that.getModel() && Objects.equals(this.getKeyList(), that.getKeyList());
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(TargetObjectPath that) {
        DebuggerObjectModel thatModel;
        if (this == that) {
            return 0;
        }
        DebuggerObjectModel thisModel = this.getModel();
        if (thisModel != (thatModel = that.getModel())) {
            if (thisModel == null) {
                return -1;
            }
            if (thatModel == null) {
                return 1;
            }
            int result = thisModel.toString().compareTo(thatModel.toString());
            if (result == 0) {
                return Integer.compare(System.identityHashCode(thisModel), System.identityHashCode(thatModel));
            }
            return result;
        }
        return PathUtils.PathComparator.KEYED.compare(this.getKeyList(), that.getKeyList());
    }

    public String toString() {
        return String.format("<%s in %s>", this.toPathString(), this.model);
    }

    public DebuggerObjectModel getModel() {
        return this.model;
    }

    public List<String> getKeyList() {
        return this.keyList;
    }

    public String name() {
        return PathUtils.getKey(this.keyList);
    }

    public String index() {
        return PathUtils.getIndex(this.keyList);
    }

    public boolean isRoot() {
        return this.keyList.isEmpty();
    }

    public CompletableFuture<TargetObject> fetch() {
        return this.model.fetchModelObject(this.getKeyList()).thenApply(obj -> obj);
    }

    public String toPathString() {
        return PathUtils.toString(this.keyList);
    }

    public TargetObjectPath parent() {
        List<String> pkl = PathUtils.parent(this.keyList);
        return pkl == null ? null : new TargetObjectPath(this.model, pkl);
    }

    public TargetObjectPath successor(List<String> subKeyList) {
        return new TargetObjectPath(this.model, PathUtils.extend(this.keyList, subKeyList));
    }

    public TargetObjectPath successor(String ... subKeyList) {
        return this.successor(Arrays.asList(subKeyList));
    }
}

