/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.debug.service.breakpoint.DebuggerLogicalBreakpointServicePlugin;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.app.services.LogicalBreakpointsChangeListener;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.program.TraceProgramView;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Supplier;

@ServiceInfo(defaultProvider={DebuggerLogicalBreakpointServicePlugin.class}, description="Aggregate breakpoints for programs and traces")
public interface DebuggerLogicalBreakpointService {
    public Set<LogicalBreakpoint> getAllBreakpoints();

    public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Program var1);

    public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Trace var1);

    public Set<LogicalBreakpoint> getBreakpointsAt(Program var1, Address var2);

    public Set<LogicalBreakpoint> getBreakpointsAt(Trace var1, Address var2);

    public LogicalBreakpoint getBreakpoint(TraceBreakpoint var1);

    public Set<LogicalBreakpoint> getBreakpointsAt(ProgramLocation var1);

    public void addChangeListener(LogicalBreakpointsChangeListener var1);

    public void removeChangeListener(LogicalBreakpointsChangeListener var1);

    public CompletableFuture<Void> changesSettled();

    public static Address addressFromLocation(ProgramLocation loc) {
        if (loc instanceof CodeUnitLocation) {
            return loc.getAddress();
        }
        return loc.getByteAddress();
    }

    public static <T> T programOrTrace(ProgramLocation loc, BiFunction<? super Program, ? super Address, ? extends T> progFunc, BiFunction<? super Trace, ? super Address, ? extends T> traceFunc) {
        Program progOrView = loc.getProgram();
        if (progOrView instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)progOrView;
            return traceFunc.apply((Trace)view.getTrace(), (Address)DebuggerLogicalBreakpointService.addressFromLocation(loc));
        }
        return progFunc.apply((Program)progOrView, (Address)DebuggerLogicalBreakpointService.addressFromLocation(loc));
    }

    default public LogicalBreakpoint.State computeState(Collection<LogicalBreakpoint> col) {
        LogicalBreakpoint.State state = LogicalBreakpoint.State.NONE;
        for (LogicalBreakpoint lb : col) {
            state = state.sameAdddress(lb.computeState());
        }
        return state;
    }

    default public LogicalBreakpoint.State computeState(Collection<LogicalBreakpoint> col, Program program) {
        LogicalBreakpoint.State state = LogicalBreakpoint.State.NONE;
        for (LogicalBreakpoint lb : col) {
            state = state.sameAdddress(lb.computeStateForProgram(program));
        }
        return state;
    }

    default public LogicalBreakpoint.State computeState(Collection<LogicalBreakpoint> col, Trace trace) {
        LogicalBreakpoint.State state = LogicalBreakpoint.State.NONE;
        for (LogicalBreakpoint lb : col) {
            state = state.sameAdddress(lb.computeStateForTrace(trace));
        }
        return state;
    }

    default public LogicalBreakpoint.State computeState(Collection<LogicalBreakpoint> col, ProgramLocation loc) {
        return DebuggerLogicalBreakpointService.programOrTrace(loc, (p, a) -> this.computeState(col, (Program)p), (t, a) -> this.computeState(col, (Trace)t));
    }

    default public LogicalBreakpoint.State computeState(ProgramLocation loc) {
        Set<LogicalBreakpoint> col = this.getBreakpointsAt(loc);
        return this.computeState(col, loc);
    }

    default public boolean anyMapped(Collection<LogicalBreakpoint> col, Trace trace) {
        if (trace == null) {
            return this.anyMapped(col);
        }
        for (LogicalBreakpoint lb : col) {
            if (!lb.getMappedTraces().contains(trace)) continue;
            return true;
        }
        return false;
    }

    default public boolean anyMapped(Collection<LogicalBreakpoint> col) {
        for (LogicalBreakpoint lb : col) {
            if (lb.getMappedTraces().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CompletableFuture<Void> placeBreakpointAt(Program var1, Address var2, long var3, Collection<TraceBreakpointKind> var5, String var6);

    public CompletableFuture<Void> placeBreakpointAt(Trace var1, Address var2, long var3, Collection<TraceBreakpointKind> var5, String var6);

    public CompletableFuture<Void> placeBreakpointAt(ProgramLocation var1, long var2, Collection<TraceBreakpointKind> var4, String var5);

    public String generateStatusEnable(Collection<LogicalBreakpoint> var1, Trace var2);

    public CompletableFuture<Void> enableAll(Collection<LogicalBreakpoint> var1, Trace var2);

    public CompletableFuture<Void> disableAll(Collection<LogicalBreakpoint> var1, Trace var2);

    public CompletableFuture<Void> deleteAll(Collection<LogicalBreakpoint> var1, Trace var2);

    public CompletableFuture<Void> enableLocs(Collection<TraceBreakpoint> var1);

    public CompletableFuture<Void> disableLocs(Collection<TraceBreakpoint> var1);

    public CompletableFuture<Void> deleteLocs(Collection<TraceBreakpoint> var1);

    public String generateStatusToggleAt(Set<LogicalBreakpoint> var1, ProgramLocation var2);

    default public String generateStatusToggleAt(ProgramLocation loc) {
        return this.generateStatusToggleAt(this.getBreakpointsAt(loc), loc);
    }

    public CompletableFuture<Set<LogicalBreakpoint>> toggleBreakpointsAt(Set<LogicalBreakpoint> var1, ProgramLocation var2, Supplier<CompletableFuture<Set<LogicalBreakpoint>>> var3);

    default public CompletableFuture<Set<LogicalBreakpoint>> toggleBreakpointsAt(ProgramLocation location, Supplier<CompletableFuture<Set<LogicalBreakpoint>>> placer) {
        return this.toggleBreakpointsAt(this.getBreakpointsAt(location), location, placer);
    }
}

