/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.GoToInput;
import ghidra.app.plugin.core.debug.gui.action.LocationTracker;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.PCByRegisterLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.PCByStackLocationTrackingSpec;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.util.TraceAddressSpace;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public enum PCLocationTrackingSpec implements LocationTrackingSpec,
LocationTracker
{
    INSTANCE;

    public static final String CONFIG_NAME = "TRACK_PC";
    private static final PCByRegisterLocationTrackingSpec BY_REG;
    private static final PCByStackLocationTrackingSpec BY_STACK;

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Track Program Counter";
    }

    @Override
    public Icon getMenuIcon() {
        return DebuggerResources.TrackLocationAction.ICON_PC;
    }

    @Override
    public String computeTitle(DebuggerCoordinates coordinates) {
        return "Auto PC";
    }

    @Override
    public String getLocationLabel() {
        return "pc";
    }

    @Override
    public LocationTracker getTracker() {
        return this;
    }

    @Override
    public CompletableFuture<Address> computeTraceAddress(PluginTool tool, DebuggerCoordinates coordinates) {
        return CompletableFuture.supplyAsync(() -> {
            Address pc;
            if (coordinates.getTime().isSnapOnly() && (pc = BY_STACK.doComputeTraceAddress(tool, coordinates)) != null) {
                return pc;
            }
            return BY_REG.doComputeTraceAddress(tool, coordinates);
        });
    }

    @Override
    public GoToInput getDefaultGoToInput(PluginTool tool, DebuggerCoordinates coordinates, ProgramLocation location) {
        return BY_REG.getDefaultGoToInput(tool, coordinates, location);
    }

    @Override
    public boolean affectedByStackChange(TraceStack stack, DebuggerCoordinates coordinates) {
        return BY_STACK.affectedByStackChange(stack, coordinates);
    }

    @Override
    public boolean affectedByBytesChange(TraceAddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates coordinates) {
        return BY_REG.affectedByBytesChange(space, range, coordinates);
    }

    static {
        BY_REG = PCByRegisterLocationTrackingSpec.INSTANCE;
        BY_STACK = PCByStackLocationTrackingSpec.INSTANCE;
    }
}

