/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentNode;
import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.PlaceholderInstaller;
import docking.PlaceholderSet;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PlaceholderManager {
    private Map<String, PlaceholderSet> ownerToPlaceholderMap = new HashMap<String, PlaceholderSet>();
    private PlaceholderInstaller installer;

    PlaceholderManager(PlaceholderInstaller installer) {
        this.installer = installer;
    }

    PlaceholderManager(PlaceholderInstaller installer, List<ComponentPlaceholder> restoredPlaceholders) {
        this(installer);
        for (ComponentPlaceholder placeholder : restoredPlaceholders) {
            PlaceholderSet placeholderSet = this.getOrCreatePlaceholderSet(placeholder.getOwner());
            placeholderSet.addRestoredPlaceholder(placeholder);
        }
    }

    ComponentPlaceholder replacePlaceholder(ComponentProvider provider, ComponentPlaceholder defaultPlaceholder) {
        ComponentPlaceholder restoredPlaceholder = this.createOrRecyclePlaceholder(provider, defaultPlaceholder);
        this.moveActions(defaultPlaceholder, restoredPlaceholder);
        if (!defaultPlaceholder.isHeaderShowing()) {
            restoredPlaceholder.showHeader(false);
        }
        if (defaultPlaceholder.isShowing() != restoredPlaceholder.isShowing()) {
            if (restoredPlaceholder.isShowing()) {
                provider.componentShown();
            } else {
                provider.componentHidden();
            }
        }
        if (restoredPlaceholder != defaultPlaceholder) {
            defaultPlaceholder.dispose();
            this.removePlaceholder(defaultPlaceholder);
        }
        return restoredPlaceholder;
    }

    private void moveActions(ComponentPlaceholder oldPlaceholder, ComponentPlaceholder newPlaceholder) {
        if (newPlaceholder == oldPlaceholder) {
            return;
        }
        Iterator<DockingActionIf> it = oldPlaceholder.getActions();
        while (it.hasNext()) {
            DockingActionIf action = it.next();
            newPlaceholder.addAction(action);
        }
    }

    private void registerPlaceholder(ComponentPlaceholder placeholder) {
        ComponentProvider provider = placeholder.getProvider();
        String owner = provider.getOwner();
        PlaceholderSet placeholderSet = this.ownerToPlaceholderMap.get(owner);
        if (placeholderSet == null) {
            placeholderSet = new PlaceholderSet(this);
            this.ownerToPlaceholderMap.put(owner, placeholderSet);
        }
        placeholderSet.placeholderUsed(provider, placeholder);
    }

    private void removePlaceholder(ComponentPlaceholder placeholder) {
        ComponentProvider provider = placeholder.getProvider();
        String owner = provider.getOwner();
        PlaceholderSet placeholderSet = this.ownerToPlaceholderMap.get(owner);
        if (placeholderSet == null) {
            return;
        }
        placeholderSet.remove(placeholder);
    }

    ComponentPlaceholder createOrRecyclePlaceholder(ComponentProvider provider) {
        return this.createOrRecyclePlaceholder(provider, null);
    }

    ComponentPlaceholder createOrRecyclePlaceholder(ComponentProvider provider, ComponentPlaceholder defaultPlaceholder) {
        String owner = provider.getOwner();
        Set<ComponentPlaceholder> unusedPlaceholders = this.getUnusedPlaceholdersByOwner(owner);
        ComponentPlaceholder reusablePlaceholder = this.findBestUnusedPlaceholder(unusedPlaceholders, provider);
        if (reusablePlaceholder != null) {
            reusablePlaceholder.setProvider(provider);
            this.registerPlaceholder(reusablePlaceholder);
            return reusablePlaceholder;
        }
        ComponentPlaceholder newPlaceholder = defaultPlaceholder;
        if (newPlaceholder == null) {
            newPlaceholder = new ComponentPlaceholder(provider);
        }
        this.installPlaceholder(newPlaceholder);
        return newPlaceholder;
    }

    private void installPlaceholder(ComponentPlaceholder placeholder) {
        Set<ComponentPlaceholder> activePlaceholders = this.getActivePlaceholdersByOwner(placeholder.getOwner());
        this.registerPlaceholder(placeholder);
        this.positionNewPlaceholder(activePlaceholders, placeholder);
    }

    private void positionNewPlaceholder(Set<ComponentPlaceholder> activePlaceholders, ComponentPlaceholder newPlaceholder) {
        String existingGroup;
        ComponentPlaceholder relativePlaceholder;
        ComponentPlaceholder stackUponPlaceholder = this.findBestPlaceholderToStackUpon(activePlaceholders, newPlaceholder);
        if (stackUponPlaceholder != null) {
            stackUponPlaceholder.getNode().add(newPlaceholder);
            return;
        }
        WindowPosition windowPosition = newPlaceholder.getProvider().getDefaultWindowPosition();
        if (windowPosition == null) {
            windowPosition = WindowPosition.WINDOW;
        }
        if ((relativePlaceholder = this.findBestPlaceholderAnchor(activePlaceholders, newPlaceholder)) == null) {
            this.installer.installPlaceholder(newPlaceholder, windowPosition);
            return;
        }
        String newGroup = newPlaceholder.getGroup();
        if (newGroup.equals(existingGroup = relativePlaceholder.getGroup())) {
            this.positionInSameGroup(newPlaceholder, relativePlaceholder);
        } else {
            this.positionInRelativeGroup(newPlaceholder, relativePlaceholder);
        }
    }

    private void positionInSameGroup(ComponentPlaceholder newPlaceholder, ComponentPlaceholder relativePlaceholder) {
        ComponentNode node = relativePlaceholder.getNode();
        WindowPosition intraGroupPosition = newPlaceholder.getProvider().getIntraGroupPosition();
        if (intraGroupPosition == WindowPosition.STACK) {
            node.add(newPlaceholder);
        } else {
            node.split(newPlaceholder, intraGroupPosition);
        }
    }

    private void positionInRelativeGroup(ComponentPlaceholder newPlaceholder, ComponentPlaceholder relativePlaceholder) {
        ComponentNode node = relativePlaceholder.getNode();
        ComponentProvider provider = newPlaceholder.getProvider();
        WindowPosition windowPosition = provider.getDefaultWindowPosition();
        WindowPosition intraGroupPosition = provider.getIntraGroupPosition();
        if (windowPosition == WindowPosition.WINDOW) {
            node.split(newPlaceholder, intraGroupPosition);
            return;
        }
        if (intraGroupPosition == WindowPosition.STACK) {
            node.add(newPlaceholder);
        } else {
            node.split(newPlaceholder, intraGroupPosition);
        }
    }

    private ComponentPlaceholder findBestPlaceholderAnchor(Set<ComponentPlaceholder> activePlaceholders, ComponentPlaceholder newPlaceholder) {
        String group = newPlaceholder.getGroup();
        if ("Default".equals(group)) {
            return null;
        }
        ComponentPlaceholder bestMatchPlaceholder = null;
        Set<ComponentPlaceholder> buddies = activePlaceholders;
        if (buddies.isEmpty()) {
            buddies = this.getAllActivePlaceholders();
        }
        for (ComponentPlaceholder placeholder : buddies) {
            String testGroup;
            if (placeholder == newPlaceholder || !group.startsWith(testGroup = placeholder.getGroup()) || bestMatchPlaceholder != null && testGroup.length() <= bestMatchPlaceholder.getGroup().length()) continue;
            bestMatchPlaceholder = placeholder;
        }
        return bestMatchPlaceholder;
    }

    private ComponentPlaceholder findBestPlaceholderToStackUpon(Set<ComponentPlaceholder> activePlaceholders, ComponentPlaceholder newInfo) {
        String name = newInfo.getName();
        String group = newInfo.getGroup();
        for (ComponentPlaceholder placeholder : activePlaceholders) {
            if (!name.equals(placeholder.getName()) || !group.equals(placeholder.getGroup())) continue;
            return placeholder;
        }
        return null;
    }

    private ComponentPlaceholder findBestUnusedPlaceholder(Set<ComponentPlaceholder> unusedPlaceholders, ComponentProvider provider) {
        String name = provider.getName();
        String windowGroup = provider.getWindowGroup();
        boolean isInvalid = windowGroup == null || windowGroup.trim().isEmpty();
        String group = isInvalid ? "Default" : windowGroup;
        String title = provider.getTitle();
        for (ComponentPlaceholder placeholder : unusedPlaceholders) {
            if (!placeholder.wantsToBeShowing() || !name.equals(placeholder.getName()) || !title.equals(placeholder.getTitle())) continue;
            return placeholder;
        }
        for (ComponentPlaceholder placeholder : unusedPlaceholders) {
            if (!name.equals(placeholder.getName()) || !title.equals(placeholder.getTitle())) continue;
            return placeholder;
        }
        for (ComponentPlaceholder placeholder : unusedPlaceholders) {
            if (!name.equals(placeholder.getName()) || !group.equals(placeholder.getGroup())) continue;
            return placeholder;
        }
        return null;
    }

    private Set<ComponentPlaceholder> getUnusedPlaceholdersByOwner(String owner) {
        PlaceholderSet placeholderSet = this.getOrCreatePlaceholderSet(owner);
        return placeholderSet.getUnusedPlaceholders();
    }

    private Set<ComponentPlaceholder> getActivePlaceholdersByOwner(String owner) {
        PlaceholderSet placeholderSet = this.getOrCreatePlaceholderSet(owner);
        return placeholderSet.getUsedPlaceholders();
    }

    void disposePlaceholder(ComponentPlaceholder placeholder, boolean keepAround) {
        this.installer.uninstallPlaceholder(placeholder, keepAround);
    }

    boolean containsProvider(ComponentProvider provider) {
        String owner = provider.getOwner();
        PlaceholderSet placeholderSet = this.getOrCreatePlaceholderSet(owner);
        return placeholderSet.containsPlaceholder(provider);
    }

    private PlaceholderSet getOrCreatePlaceholderSet(String owner) {
        PlaceholderSet placeholderSet = this.ownerToPlaceholderMap.get(owner);
        if (placeholderSet != null) {
            return placeholderSet;
        }
        placeholderSet = new PlaceholderSet(this);
        this.ownerToPlaceholderMap.put(owner, placeholderSet);
        return placeholderSet;
    }

    ComponentPlaceholder getActivePlaceholder(ComponentProvider provider) {
        if (provider == null) {
            return null;
        }
        PlaceholderSet placeholderSet = this.getOrCreatePlaceholderSet(provider.getOwner());
        return placeholderSet.getPlaceholder(provider);
    }

    Map<ComponentProvider, ComponentPlaceholder> getActiveProvidersToPlaceholders() {
        HashMap<ComponentProvider, ComponentPlaceholder> map = new HashMap<ComponentProvider, ComponentPlaceholder>();
        for (PlaceholderSet placeholders : this.ownerToPlaceholderMap.values()) {
            map.putAll(placeholders.getProviderMap());
        }
        return map;
    }

    private Set<ComponentPlaceholder> getAllActivePlaceholders() {
        HashSet<ComponentPlaceholder> set = new HashSet<ComponentPlaceholder>();
        for (PlaceholderSet placeholders : this.ownerToPlaceholderMap.values()) {
            set.addAll(placeholders.getUsedPlaceholders());
        }
        return set;
    }

    Set<ComponentProvider> getActiveProviders() {
        return this.getActiveProvidersToPlaceholders().keySet();
    }

    ComponentPlaceholder getPlaceholder(ComponentProvider provider) {
        Map<ComponentProvider, ComponentPlaceholder> map = this.getActiveProvidersToPlaceholders();
        return map.get(provider);
    }

    void removeComponent(ComponentProvider provider) {
        PlaceholderSet placeholderSet = this.getOrCreatePlaceholderSet(provider.getOwner());
        placeholderSet.placeholderFreed(provider);
    }

    void removeAll(String owner) {
        PlaceholderSet placeholderSet = this.getOrCreatePlaceholderSet(owner);
        placeholderSet.removeAll();
    }

    void clearActivePlaceholders() {
        this.ownerToPlaceholderMap.clear();
    }

    void disposePlaceholders() {
        Collection<PlaceholderSet> values = this.ownerToPlaceholderMap.values();
        for (PlaceholderSet placeholderSet : values) {
            placeholderSet.clear();
        }
        this.ownerToPlaceholderMap.clear();
    }

    void resetPlaceholdersWithoutProviders() {
        Collection<PlaceholderSet> placeholderSets = this.ownerToPlaceholderMap.values();
        for (PlaceholderSet placeholderSet : placeholderSets) {
            placeholderSet.resetPlaceholdersWithoutProviders();
        }
    }
}

