/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaValue;
import agent.frida.model.iface2.FridaModelTargetStackFrameRegister;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetRegisterContainerImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.ConversionUtils;
import ghidra.dbg.util.PathUtils;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="RegisterValue", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)})
public class FridaModelTargetRegisterImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetStackFrameRegister {
    String value = this.getValue();

    protected static String indexRegister(FridaValue register) {
        return register.getKey();
    }

    protected static String keyRegister(FridaValue register) {
        return PathUtils.makeKey((String)FridaModelTargetRegisterImpl.indexRegister(register));
    }

    public FridaModelTargetRegisterImpl(FridaModelTargetRegisterContainerImpl registers, FridaValue register) {
        super(registers.getModel(), (TargetObject)registers, FridaModelTargetRegisterImpl.keyRegister(register), register, "Register");
        this.changeAttributes(List.of(), Map.of("_container", registers, "_length", this.getBitLength(), "_display", this.getDescription(0), "_value", this.value == null ? "0" : this.value, "_modified", false), "Initialized");
    }

    @Override
    public String getDescription(int level) {
        return this.getName() + " : " + this.getValue();
    }

    @Override
    public int getBitLength() {
        return this.getRegister().getByteSize() * 8;
    }

    public String getValue() {
        String val = this.getRegister().getValue();
        if (val == null) {
            return null;
        }
        if (!val.startsWith("0x")) {
            return val;
        }
        return val.substring(2);
    }

    @Override
    public FridaValue getRegister() {
        return (FridaValue)this.getModelObject();
    }

    @Override
    public byte[] getBytes() {
        String newval;
        String oldValue = this.value;
        this.value = this.getValue();
        if (this.value == null) {
            return new byte[0];
        }
        if (this.value.startsWith("{")) {
            String trim = this.value.substring(1, this.value.length() - 1);
            String[] split = trim.split(" ");
            this.value = split[0].substring(2) + split[1].substring(2);
        }
        BigInteger val = new BigInteger(this.value, 16);
        byte[] bytes = ConversionUtils.bigIntegerToBytes((int)this.getRegister().getByteSize(), (BigInteger)val);
        this.changeAttributes(List.of(), Map.of("_value", this.value), "Refreshed");
        if (val.longValue() != 0L && (newval = this.getDescription(0)) != null) {
            this.changeAttributes(List.of(), Map.of("_display", newval), "Refreshed");
            this.setModified(!this.value.equals(oldValue));
        }
        return bytes;
    }

    public String getDisplay() {
        return this.getValue() == null ? this.getName() : this.getName() + " : " + this.getValue();
    }
}

