/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.pty.linux;

import agent.gdb.pty.linux.PosixC;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.io.InputStream;

public class FdInputStream
extends InputStream {
    private static final PosixC LIB_POSIX = PosixC.INSTANCE;
    private final int fd;
    private boolean closed = false;

    FdInputStream(int fd) {
        this.fd = fd;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        byte[] buf = new byte[1];
        if (0 == this.read(buf)) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        Memory buf = new Memory((long)len);
        int ret = LIB_POSIX.read(this.fd, (Pointer)buf, len);
        buf.read(0L, b, off, ret);
        return ret;
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
    }
}

