/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.label.AddLabelCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.plugin.core.disassembler.AddressTable;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.data.Undefined2DataType;
import ghidra.program.model.data.Undefined4DataType;
import ghidra.program.model.data.Undefined8DataType;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;

public class ArmAnalyzer
extends ConstantPropagationAnalyzer {
    private static final String SWITCH_OPTION_NAME = "Switch Table Recovery";
    private static final String SWITCH_OPTION_DESCRIPTION = "Turn on to recover switch tables";
    private static final boolean SWITCH_OPTION_DEFAULT_VALUE = false;
    private boolean recoverSwitchTables = false;
    private static final long MAX_DISTANCE = 4096L;
    private Register tbRegister;
    private Register tmodeRegister;
    private Register lrRegister;
    private static final String PROCESSOR_NAME = "ARM";

    public ArmAnalyzer() {
        super(PROCESSOR_NAME);
    }

    public boolean canAnalyze(Program program) {
        boolean canAnalyze = program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
        if (!canAnalyze) {
            return false;
        }
        this.tmodeRegister = program.getProgramContext().getRegister("TMode");
        this.tbRegister = program.getProgramContext().getRegister("ISAModeSwitch");
        this.lrRegister = program.getProgramContext().getRegister("lr");
        return true;
    }

    public AddressSet flowConstants(final Program program, Address flowStart, AddressSetView flowSet, final SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(monitor, this.trustWriteMemOption){

            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                FlowType ftype = instr.getFlowType();
                if (ftype.isComputed() && ftype.isJump()) {
                    Address addr;
                    long target;
                    Varnode lrVal;
                    Varnode pcVal = context.getRegisterVarnodeValue(program.getLanguage().getProgramCounter());
                    if (pcVal != null && this.isLinkRegister(context, pcVal) && !instr.getFlowType().isTerminal()) {
                        instr.setFlowOverride(FlowOverride.RETURN);
                        ReferenceManager refMgr = program.getReferenceManager();
                        refMgr.removeAllReferencesFrom(instr.getAddress());
                    }
                    if ((lrVal = context.getRegisterVarnodeValue(ArmAnalyzer.this.lrRegister)) != null && context.isConstant(lrVal) && (target = lrVal.getAddress().getOffset()) == (addr = instr.getMaxAddress().add(1L)).getOffset() && !instr.getFlowType().isCall()) {
                        if (this.hasDataReferenceTo(program, addr)) {
                            return false;
                        }
                        if (instr.getFlowOverride() != FlowOverride.NONE) {
                            return false;
                        }
                        instr.setFlowOverride(FlowOverride.CALL);
                        ArmAnalyzer.this.doArmThumbDisassembly(program, instr, context, addr, instr.getFlowType(), false, this.monitor);
                        Function f = program.getFunctionManager().getFunctionContaining(instr.getMinAddress());
                        if (f != null) {
                            try {
                                CreateFunctionCmd.fixupFunctionBody((Program)program, (Function)f, (TaskMonitor)this.monitor);
                            }
                            catch (CancelledException e) {
                                return true;
                            }
                        }
                    }
                }
                return false;
            }

            private boolean hasDataReferenceTo(Program program2, Address addr) {
                ReferenceManager refMgr = program2.getReferenceManager();
                if (!refMgr.hasReferencesTo(addr)) {
                    return false;
                }
                ReferenceIterator referencesTo = refMgr.getReferencesTo(addr);
                while (referencesTo.hasNext()) {
                    Reference reference = referencesTo.next();
                    if (!reference.getReferenceType().isData()) continue;
                    return true;
                }
                return false;
            }

            private boolean isLinkRegister(VarnodeContext context, Varnode pcVal) {
                return pcVal.isRegister() && pcVal.getAddress().equals((Object)ArmAnalyzer.this.lrRegister.getAddress()) || context.isSymbol(pcVal) && pcVal.getAddress().getAddressSpace().getName().equals(ArmAnalyzer.this.lrRegister.getName()) && pcVal.getOffset() == 0L;
            }

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, DataType dataType, RefType refType) {
                if (refType.isJump() && refType.isComputed() && program.getMemory().contains(address) && address.getOffset() != 0L) {
                    if (instr.getMnemonicString().startsWith("tb")) {
                        return false;
                    }
                    ArmAnalyzer.this.doArmThumbDisassembly(program, instr, context, address, instr.getFlowType(), true, this.monitor);
                    super.evaluateReference(context, instr, pcodeop, address, size, dataType, refType);
                    return !symEval.encounteredBranch();
                }
                if (refType.isData() && program.getMemory().contains(address)) {
                    if (refType.isRead() || refType.isWrite()) {
                        int numOperands = instr.getNumOperands();
                        ArmAnalyzer.this.createData(program, address, size);
                        if (numOperands <= 2) {
                            instr.addOperandReference(instr.getNumOperands() - 1, address, refType, SourceType.ANALYSIS);
                            return false;
                        }
                        return true;
                    }
                } else if (refType.isCall() && refType.isComputed() && !address.isExternalAddress()) {
                    ArmAnalyzer.this.doArmThumbDisassembly(program, instr, context, address, instr.getFlowType(), true, this.monitor);
                }
                return super.evaluateReference(context, instr, pcodeop, address, size, dataType, refType);
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                FlowType flowType = instruction.getFlowType();
                if (!flowType.isJump()) {
                    return false;
                }
                Reference[] refs = instruction.getReferencesFrom();
                if (refs.length <= 0 || refs.length == 1 && refs[0].getReferenceType().isData() || symEval.encounteredBranch()) {
                    this.destSet.addRange(instruction.getMinAddress(), instruction.getMinAddress());
                }
                return false;
            }

            public boolean evaluateReturn(Varnode retVN, VarnodeContext context, Instruction instruction) {
                long offset;
                if (retVN != null && context.isConstant(retVN) && (offset = retVN.getOffset()) > 3L && offset != -1L) {
                    instruction.setFlowOverride(FlowOverride.BRANCH);
                }
                return false;
            }
        };
        eval.setTrustWritableMemory(this.trustWriteMemOption).setMinpeculativeOffset(this.minSpeculativeRefAddress).setMaxSpeculativeOffset(this.maxSpeculativeRefAddress).setMinStoreLoadOffset(this.minStoreLoadRefAddress).setCreateComplexDataFromPointers(this.createComplexDataFromPointers);
        AddressSet resultSet = symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
        if (this.recoverSwitchTables) {
            this.recoverSwitches(program, eval.getDestinationSet(), symEval, monitor);
        }
        return resultSet;
    }

    private void recoverSwitches(final Program program, AddressSet destSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        class SwitchEvaluator
        implements ContextEvaluator {
            int tableSizeMax = 64;
            Long assumeValue = 0L;
            Address targetSwitchAddr = null;
            int addrByteSize = 1;
            boolean hitTheGuard = false;
            ArrayList<Address> targetList = new ArrayList();
            ArrayList<Address> accessList = new ArrayList();

            SwitchEvaluator() {
            }

            public void init(Address loc, int maxSize) {
                this.addrByteSize = 1;
                this.assumeValue = 0L;
                this.tableSizeMax = maxSize;
                this.targetSwitchAddr = loc;
                this.hitTheGuard = false;
                this.targetList.clear();
                this.accessList.clear();
            }

            public void initForCase(Long assume) {
                this.assumeValue = (long)assume;
                this.hitTheGuard = false;
            }

            public int getTableSizeMax() {
                return this.tableSizeMax;
            }

            public int getAddrByteSize() {
                return this.addrByteSize;
            }

            public ArrayList<Address> getTargetList() {
                return this.targetList;
            }

            public boolean evaluateContextBefore(VarnodeContext context, Instruction instr) {
                return false;
            }

            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                Register reg;
                int numOps;
                if (context.readExecutableCode()) {
                    return true;
                }
                String mnemonic = instr.getMnemonicString();
                if (mnemonic.compareToIgnoreCase("cmp") == 0) {
                    numOps = instr.getNumOperands();
                    if (numOps > 1 && (reg = instr.getRegister(numOps - 2)) != null) {
                        int newTableSizeMax;
                        context.clearRegister(reg);
                        Scalar scalar = instr.getScalar(numOps - 1);
                        if (scalar != null && (newTableSizeMax = (int)scalar.getSignedValue() + 2) > 0 && newTableSizeMax < 128) {
                            this.tableSizeMax = newTableSizeMax;
                        }
                    }
                    this.hitTheGuard = true;
                }
                if (mnemonic.compareToIgnoreCase("sub") == 0 && (numOps = instr.getNumOperands()) > 1 && (reg = instr.getRegister(numOps - 2)) != null) {
                    BigInteger val = context.getValue(reg, true);
                    if (val == null) {
                        return false;
                    }
                    context.clearRegister(reg);
                    Scalar scalar = instr.getScalar(numOps - 1);
                    if (scalar == null) {
                        return false;
                    }
                    context.setValue(reg, val.add(BigInteger.valueOf(scalar.getSignedValue())));
                    val = context.getValue(reg, true);
                }
                return false;
            }

            public Address evaluateConstant(VarnodeContext context, Instruction instr, int pcodeop, Address constant, int size, DataType dataType, RefType refType) {
                return null;
            }

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, DataType dataType, RefType refType) {
                if (address == null) {
                    return this.terminatePropogation(context);
                }
                long offset = address.getOffset();
                if (offset >= 0L && offset < 256L || context.readExecutableCode()) {
                    return this.terminatePropogation(context);
                }
                if (!refType.isComputed() && refType.isConditional() != !ArmAnalyzer.this.followConditional || !program.getMemory().contains(address)) {
                    if (refType.isRead()) {
                        if (this.targetList.contains(address)) {
                            return this.terminatePropogation(context);
                        }
                        size = ArmAnalyzer.this.createDataType(instr, address);
                        if (size != 0) {
                            this.addrByteSize = size;
                        }
                    }
                    return false;
                }
                if (refType.isJump() || refType.isCall()) {
                    if (this.accessList.contains(address)) {
                        return this.terminatePropogation(context);
                    }
                    long diff = Math.abs(address.subtract(this.targetSwitchAddr));
                    if ((refType.isCall() || diff < 32768L) && (address = ArmAnalyzer.this.flowArmThumb(program, instr, context, address, instr.getFlowType(), false)) != null) {
                        this.targetList.add(address);
                    }
                    return false;
                }
                return false;
            }

            private boolean terminatePropogation(VarnodeContext context) {
                this.hitTheGuard = false;
                context.setReadExecutableCode();
                return false;
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                return instruction.getMinAddress().equals((Object)this.targetSwitchAddr);
            }

            public boolean evaluateReturn(Varnode retVN, VarnodeContext context, Instruction instruction) {
                return false;
            }

            public Long unknownValue(VarnodeContext context, Instruction instruction, Varnode node) {
                if (node.isRegister()) {
                    Register reg = program.getRegister(node.getAddress());
                    if (reg != null) {
                        String regName = reg.getName();
                        if (regName.equals("sp")) {
                            return null;
                        }
                        if (!regName.startsWith("r")) {
                            return 0L;
                        }
                    }
                    if (this.hitTheGuard) {
                        return this.assumeValue;
                    }
                }
                if (this.hitTheGuard && context.isSymbol(node)) {
                    return this.assumeValue;
                }
                return null;
            }

            public boolean followFalseConditionalBranches() {
                return false;
            }

            public boolean evaluateSymbolicReference(VarnodeContext context, Instruction instr, Address address) {
                return false;
            }

            public boolean allowAccess(VarnodeContext context, Address addr) {
                this.accessList.add(addr);
                return false;
            }
        }
        SwitchEvaluator switchEvaluator = new SwitchEvaluator();
        AddressIterator iter = destSet.getAddresses(true);
        SimpleBlockModel model = new SimpleBlockModel(program);
        while (iter.hasNext() && !monitor.isCancelled()) {
            Address loc = iter.next();
            CodeBlock bl = null;
            try {
                bl = model.getFirstCodeBlockContaining(loc, monitor);
            }
            catch (CancelledException e) {
                break;
            }
            AddressSet branchSet = new AddressSet((AddressSetView)bl);
            try {
                CodeBlockReferenceIterator bliter = bl.getSources(monitor);
                while (bliter.hasNext() && !this.hasCallsTo(program, bl)) {
                    CodeBlockReference sbl = bliter.next();
                    bl = sbl.getSourceBlock();
                    if (bl == null) continue;
                    if (!sbl.getFlowType().isCall()) {
                        branchSet.add((AddressSetView)bl);
                    }
                    if (!sbl.getFlowType().isJump() || bl.getNumSources(monitor) != 1) continue;
                    if (sbl.getFlowType().isConditional()) {
                        this.followConditional = true;
                        break;
                    }
                    bliter = bl.getSources(monitor);
                }
            }
            catch (CancelledException e) {
                break;
            }
            switchEvaluator.init(loc, 64);
            Instruction targetInstr = program.getListing().getInstructionAt(loc);
            SymbolicPropogator targetEval = symEval;
            if (targetInstr != null && targetInstr.getMnemonicString().startsWith("tb")) {
                targetEval = new SymbolicPropogator(program);
            }
            Address zeroAddr = targetInstr.getMinAddress().getNewAddress(0L);
            for (long assume = 0L; assume < (long)switchEvaluator.getTableSizeMax(); ++assume) {
                switchEvaluator.initForCase(assume);
                targetEval.flowConstants(branchSet.getMinAddress(), (AddressSetView)branchSet, (ContextEvaluator)switchEvaluator, false, monitor);
                if (assume > 0L && targetEval.readExecutable() || assume > 1L && switchEvaluator.getTargetList().size() < 1) break;
                if (!switchEvaluator.getTargetList().contains(zeroAddr)) continue;
                switchEvaluator.getTargetList().clear();
                break;
            }
            if (switchEvaluator.getTargetList().size() > 1) {
                Iterator<Address> liter = switchEvaluator.getTargetList().iterator();
                Address firstAddress = switchEvaluator.getTargetList().get(0);
                while (liter.hasNext()) {
                    if (firstAddress.equals((Object)liter.next())) continue;
                    AddressTable table = new AddressTable(loc, switchEvaluator.getTargetList().toArray(new Address[0]), switchEvaluator.getAddrByteSize(), 0, false);
                    Instruction jmpInstr = program.getListing().getInstructionAt(loc);
                    if (jmpInstr.getReferencesFrom().length <= 1) {
                        for (Address address : switchEvaluator.getTargetList()) {
                            jmpInstr.addMnemonicReference(address, (RefType)jmpInstr.getFlowType(), SourceType.ANALYSIS);
                        }
                    }
                    table.disassemble(program, jmpInstr, monitor);
                    table.fixupFunctionBody(program, jmpInstr, monitor);
                    this.labelTable(program, loc, switchEvaluator.getTargetList());
                    switchEvaluator.getTargetList().clear();
                    break;
                }
            }
            if (switchEvaluator.getTargetList().size() <= 0) continue;
            AddressTable table = new AddressTable(loc, switchEvaluator.getTargetList().toArray(new Address[0]), switchEvaluator.getAddrByteSize(), 0, false);
            table.disassemble(program, targetInstr, monitor);
        }
    }

    private boolean hasCallsTo(Program program, CodeBlock bl) {
        Address startAddr = bl.getFirstStartAddress();
        ReferenceIterator referencesTo = program.getReferenceManager().getReferencesTo(startAddr);
        while (referencesTo.hasNext()) {
            Reference reference = referencesTo.next();
            if (!reference.getReferenceType().isCall()) continue;
            return true;
        }
        return false;
    }

    private int createDataType(Instruction instr, Address address) {
        Object dValue;
        Program program = instr.getProgram();
        if (!program.getListing().isUndefined(address, address)) {
            return 0;
        }
        String mnemonic = instr.getMnemonicString();
        int charOff = 0;
        if (mnemonic.startsWith("ldrex") || mnemonic.startsWith("strex")) {
            charOff = 5;
        } else if (mnemonic.startsWith("ldrs") || mnemonic.startsWith("strs")) {
            charOff = 4;
        } else if (mnemonic.startsWith("ldr") || mnemonic.startsWith("str")) {
            charOff = 3;
        } else if (mnemonic.startsWith("ld") || mnemonic.startsWith("st")) {
            charOff = 2;
        } else if (mnemonic.startsWith("tbh")) {
            charOff = 2;
        } else if (mnemonic.startsWith("tbb")) {
            charOff = 2;
        } else if (mnemonic.startsWith("vldr") || mnemonic.startsWith("vstr")) {
            charOff = mnemonic.length() - 2;
        }
        if (charOff <= 0) {
            return 0;
        }
        Undefined4DataType dt = Undefined4DataType.dataType;
        if (mnemonic.length() > charOff) {
            char endCh = mnemonic.charAt(charOff);
            switch (endCh) {
                case '6': {
                    dt = Undefined8DataType.dataType;
                    break;
                }
                case '3': {
                    dt = Undefined4DataType.dataType;
                    break;
                }
                case 'l': {
                    dt = Undefined4DataType.dataType;
                    break;
                }
                case 'h': 
                case 'w': {
                    dt = Undefined2DataType.dataType;
                    break;
                }
                case 'b': {
                    dt = Undefined1DataType.dataType;
                }
            }
        }
        Data data = null;
        try {
            data = program.getListing().createData(address, (DataType)dt);
        }
        catch (CodeUnitInsertionException e) {
            data = program.getListing().getDefinedDataAt(address);
        }
        int addrByteSize = dt.getLength();
        if (data != null && (dValue = data.getValue()) != null && dValue instanceof Scalar) {
            Scalar sValue = (Scalar)dValue;
            long value = sValue.getUnsignedValue();
            if (value < 4096L || value == 65535L || value == 65280L || value == 0xFFFFFFL || value == 0xFF0000L || value == 0xFF00FFL || value == -1L || value == -256L || value == -65536L || value == -16777216L) {
                return 0;
            }
            long distance = address.getOffset() - instr.getAddress().getOffset();
            if (distance > 0L && distance < 4096L) {
                this.markDataAsConstant(data);
            }
        }
        return addrByteSize;
    }

    private void labelTable(Program program, Address loc, ArrayList<Address> targets) {
        Namespace space = null;
        Instruction start_inst = program.getListing().getInstructionAt(loc);
        String spaceName = "switch_" + start_inst.getMinAddress();
        try {
            space = program.getSymbolTable().createNameSpace(space, spaceName, SourceType.ANALYSIS);
        }
        catch (DuplicateNameException e) {
            space = program.getSymbolTable().getNamespace(spaceName, program.getGlobalNamespace());
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        int tableNumber = 0;
        for (Address addr : targets) {
            AddLabelCmd lcmd = new AddLabelCmd(addr, "case_" + Long.toHexString(tableNumber), space, SourceType.ANALYSIS);
            ++tableNumber;
            lcmd.setNamespace(space);
            lcmd.applyTo((DomainObject)program);
        }
    }

    Address flowArmThumb(Program program, Instruction instruction, VarnodeContext context, Address target, FlowType flowType, boolean addReference) {
        if (target == null) {
            return null;
        }
        long bxOffset = target.getOffset();
        long thumbMode = bxOffset & 1L;
        Address addr = instruction.getMinAddress().getNewAddress(bxOffset & 0xFFFFFFFFFFFFFFFEL);
        Listing listing = program.getListing();
        if (flowType != null) {
            int opIndex = -1;
            for (int i = 0; i < instruction.getNumOperands(); ++i) {
                int opType = instruction.getOperandType(i);
                if ((opType & 0x200) == 0 && (opType & 0x400000) == 0) continue;
                opIndex = i;
                break;
            }
            if (addReference) {
                Reference[] refsFrom = instruction.getReferencesFrom();
                boolean foundRef = false;
                for (Reference element : refsFrom) {
                    if (!element.getToAddress().equals((Object)addr)) continue;
                    foundRef = true;
                    break;
                }
                if (!foundRef) {
                    if (opIndex == -1) {
                        instruction.addMnemonicReference(addr, (RefType)flowType, SourceType.ANALYSIS);
                    } else {
                        instruction.addOperandReference(opIndex, addr, (RefType)flowType, SourceType.ANALYSIS);
                    }
                }
            }
        }
        if (this.tmodeRegister != null && listing.getUndefinedDataAt(addr) != null) {
            RegisterValue tbvalue;
            boolean inThumbMode = false;
            RegisterValue curvalue = context.getRegisterValue(this.tmodeRegister, instruction.getMinAddress());
            if (curvalue != null && curvalue.hasValue()) {
                boolean bl = inThumbMode = curvalue.getUnsignedValue().intValue() == 1;
            }
            if ((tbvalue = context.getRegisterValue(this.tbRegister)) != null && tbvalue.hasValue()) {
                inThumbMode = tbvalue.getUnsignedValue().intValue() == 1;
            } else if (instruction.getMnemonicString().equals("blx") || thumbMode != 0L) {
                inThumbMode = true;
            }
            BigInteger thumbModeValue = BigInteger.valueOf(inThumbMode ? 1L : 0L);
            try {
                program.getProgramContext().setValue(this.tmodeRegister, addr, addr, thumbModeValue);
            }
            catch (ContextChangeException e) {
                Msg.error((Object)((Object)this), (Object)"Unexpected Exception", (Throwable)e);
            }
            return addr;
        }
        return null;
    }

    void doArmThumbDisassembly(Program program, Instruction instruction, VarnodeContext context, Address target, FlowType flowType, boolean addRef, TaskMonitor monitor) {
        if (target == null) {
            return;
        }
        if ((target = this.flowArmThumb(program, instruction, context, target, flowType, addRef)) == null) {
            return;
        }
        MemoryBlock block = program.getMemory().getBlock(target);
        if (block == null || !block.isExecute() || !block.isInitialized() || block.isExternalBlock()) {
            return;
        }
        Disassembler dis = Disassembler.getDisassembler((Program)program, (TaskMonitor)monitor, null);
        AddressSet disassembleAddrs = dis.disassemble(target, null);
        AutoAnalysisManager.getAnalysisManager((Program)program).codeDefined((AddressSetView)disassembleAddrs);
    }

    public void optionsChanged(Options options, Program program) {
        super.optionsChanged(options, program);
        options.registerOption(SWITCH_OPTION_NAME, (Object)this.recoverSwitchTables, null, SWITCH_OPTION_DESCRIPTION);
        this.recoverSwitchTables = options.getBoolean(SWITCH_OPTION_NAME, this.recoverSwitchTables);
    }
}

