/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.options.editor.BooleanEditor;
import ghidra.app.plugin.core.analysis.AbstractDemanglerAnalyzer;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.gnu.GnuDemangler;
import ghidra.app.util.demangler.gnu.GnuDemanglerFormat;
import ghidra.app.util.demangler.gnu.GnuDemanglerOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.EnumEditor;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.PropertySelector;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Arrays;

public class GnuDemanglerAnalyzer
extends AbstractDemanglerAnalyzer {
    private static final String NAME = "Demangler GNU";
    private static final String DESCRIPTION = "After a function is created, this analyzer will attempt to demangle the name and apply datatypes to parameters.";
    private static final String OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS = "Demangle Only Known Mangled Symbols";
    private static final String OPTION_DESCRIPTION_USE_KNOWN_PATTERNS = "Only demangle symbols that follow known compiler mangling patterns. Leaving this option off may cause non-mangled symbols to get demangled.";
    private static final String OPTION_NAME_APPLY_SIGNATURE = "Apply Function Signatures";
    private static final String OPTION_DESCRIPTION_APPLY_SIGNATURE = "Apply any recovered function signature, in addition to the function name";
    private static final String OPTION_NAME_APPLY_CALLING_CONVENTION = "Apply Function Calling Conventions";
    private static final String OPTION_DESCRIPTION_APPLY_CALLING_CONVENTION = "Apply any recovered function signature calling convention";
    static final String OPTION_NAME_USE_DEPRECATED_DEMANGLER = "Use Deprecated Demangler";
    private static final String OPTION_DESCRIPTION_DEPRECATED_DEMANGLER = "Signals to use the deprecated demangler when the modern demangler cannot demangle a given string";
    static final String OPTION_NAME_DEMANGLER_FORMAT = "Demangler Format";
    private static final String OPTION_DESCRIPTION_DEMANGLER_FORMAT = "The demangling format to use";
    private boolean applyFunctionSignature = true;
    private boolean applyCallingConvention = true;
    private boolean demangleOnlyKnownPatterns = false;
    private GnuDemanglerFormat demanglerFormat = GnuDemanglerFormat.AUTO;
    private boolean useDeprecatedDemangler = false;
    private GnuDemangler demangler = new GnuDemangler();

    public GnuDemanglerAnalyzer() {
        super(NAME, DESCRIPTION);
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        return this.demangler.canDemangle(program);
    }

    public void registerOptions(Options options, Program program) {
        HelpLocation help = new HelpLocation("AutoAnalysisPlugin", "Demangler_Analyzer");
        options.registerOption(OPTION_NAME_APPLY_SIGNATURE, (Object)this.applyFunctionSignature, help, OPTION_DESCRIPTION_APPLY_SIGNATURE);
        options.registerOption(OPTION_NAME_APPLY_CALLING_CONVENTION, (Object)this.applyCallingConvention, help, OPTION_DESCRIPTION_APPLY_CALLING_CONVENTION);
        options.registerOption(OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS, (Object)this.demangleOnlyKnownPatterns, help, OPTION_DESCRIPTION_USE_KNOWN_PATTERNS);
        BooleanEditor deprecatedEditor = null;
        FormatEditor formatEditor = null;
        if (!SystemUtilities.isInHeadlessMode()) {
            deprecatedEditor = new BooleanEditor();
            deprecatedEditor.setValue((Object)this.useDeprecatedDemangler);
            formatEditor = new FormatEditor(this.demanglerFormat, deprecatedEditor);
            deprecatedEditor.addPropertyChangeListener((PropertyChangeListener)formatEditor);
        }
        options.registerOption(OPTION_NAME_USE_DEPRECATED_DEMANGLER, OptionType.BOOLEAN_TYPE, (Object)this.useDeprecatedDemangler, help, OPTION_DESCRIPTION_DEPRECATED_DEMANGLER, (PropertyEditor)deprecatedEditor);
        options.registerOption(OPTION_NAME_DEMANGLER_FORMAT, OptionType.ENUM_TYPE, (Object)this.demanglerFormat, help, OPTION_DESCRIPTION_DEMANGLER_FORMAT, (PropertyEditor)((Object)formatEditor));
    }

    public void optionsChanged(Options options, Program program) {
        this.applyFunctionSignature = options.getBoolean(OPTION_NAME_APPLY_SIGNATURE, this.applyFunctionSignature);
        this.applyCallingConvention = options.getBoolean(OPTION_NAME_APPLY_CALLING_CONVENTION, this.applyCallingConvention);
        this.demangleOnlyKnownPatterns = options.getBoolean(OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS, this.demangleOnlyKnownPatterns);
        this.demanglerFormat = (GnuDemanglerFormat)options.getEnum(OPTION_NAME_DEMANGLER_FORMAT, (Enum)GnuDemanglerFormat.AUTO);
        this.useDeprecatedDemangler = options.getBoolean(OPTION_NAME_USE_DEPRECATED_DEMANGLER, this.useDeprecatedDemangler);
    }

    protected DemanglerOptions getOptions() {
        GnuDemanglerOptions options = new GnuDemanglerOptions(this.demanglerFormat, this.useDeprecatedDemangler);
        options.setDoDisassembly(true);
        options.setApplySignature(this.applyFunctionSignature);
        options.setApplyCallingConvention(this.applyCallingConvention);
        options.setDemangleOnlyKnownPatterns(this.demangleOnlyKnownPatterns);
        return options;
    }

    protected DemangledObject doDemangle(String mangled, DemanglerOptions demanglerOtions, MessageLog log) throws DemangledException {
        return this.demangler.demangle(mangled, demanglerOtions);
    }

    private static class FormatEditor
    extends EnumEditor
    implements PropertyChangeListener {
        private final FormatSelector selector;
        private final BooleanEditor isDeprecated;

        FormatEditor(GnuDemanglerFormat value, BooleanEditor isDeprecated) {
            this.setValue((Object)value);
            this.isDeprecated = isDeprecated;
            this.selector = new FormatSelector(this);
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public FormatSelector getCustomEditor() {
            return this.selector;
        }

        public GnuDemanglerFormat[] getEnums() {
            return (GnuDemanglerFormat[])Arrays.stream(GnuDemanglerFormat.values()).filter(this::filter).toArray(GnuDemanglerFormat[]::new);
        }

        public String[] getTags() {
            return (String[])Arrays.stream(GnuDemanglerFormat.values()).filter(this::filter).map(Enum::name).toArray(String[]::new);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GnuDemanglerFormat format = this.selector.getFormat();
            this.selector.reset(this.getTags());
            if (format.isAvailable(this.isDeprecatedDemangler())) {
                this.setValue((Object)format);
                this.selector.setFormat(format);
            } else {
                this.setValue((Object)GnuDemanglerFormat.AUTO);
            }
        }

        private boolean isDeprecatedDemangler() {
            return (Boolean)this.isDeprecated.getValue();
        }

        private boolean filter(GnuDemanglerFormat f) {
            return f.isAvailable(this.isDeprecatedDemangler());
        }
    }

    private static class FormatSelector
    extends PropertySelector {
        public FormatSelector(FormatEditor fe) {
            super((PropertyEditor)((Object)fe));
        }

        void reset(String[] tags) {
            this.removeAllItems();
            for (String tag : tags) {
                this.addItem(tag);
            }
        }

        GnuDemanglerFormat getFormat() {
            return GnuDemanglerFormat.valueOf((String)this.getSelectedItem());
        }

        void setFormat(GnuDemanglerFormat format) {
            this.setSelectedItem(format.name());
        }
    }
}

