/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.database.UndoableTransaction;

public abstract class Expr
implements RValInternal {
    protected final StructuredSleigh ctx;
    protected final DataType type;

    protected Expr(StructuredSleigh ctx, DataType type) {
        this.ctx = ctx;
        try (UndoableTransaction tid = UndoableTransaction.start((DataTypeManager)ctx.dtm, "Resolve type");){
            this.type = ctx.dtm.resolve(type, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
    }

    @Override
    public StructuredSleigh getContext() {
        return this.ctx;
    }

    @Override
    public DataType getType() {
        return this.type;
    }
}

