/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.BinExpr;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.DataType;

class CmpExpr
extends BinExpr {
    protected Op op;

    private CmpExpr(StructuredSleigh ctx, StructuredSleigh.RVal lhs, Op op, StructuredSleigh.RVal rhs, DataType type) {
        super(ctx, lhs, op.str, rhs, type);
        this.op = op;
    }

    protected CmpExpr(StructuredSleigh ctx, StructuredSleigh.RVal lhs, Op op, StructuredSleigh.RVal rhs) {
        this(ctx, lhs, op, rhs, (DataType)BooleanDataType.dataType);
    }

    @Override
    public StructuredSleigh.RVal notb() {
        return new CmpExpr(this.ctx, (StructuredSleigh.RVal)this.lhs, this.op.not(), (StructuredSleigh.RVal)this.rhs, this.type);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Op {
        EQ("=="){

            @Override
            Op not() {
                return NEQ;
            }
        }
        ,
        NEQ("!="){

            @Override
            Op not() {
                return EQ;
            }
        }
        ,
        EQF("f=="){

            @Override
            Op not() {
                return NEQF;
            }
        }
        ,
        NEQF("f!="){

            @Override
            Op not() {
                return EQF;
            }
        }
        ,
        LTIU("<"){

            @Override
            Op not() {
                return GTEIU;
            }
        }
        ,
        LTIS("s<"){

            @Override
            Op not() {
                return GTEIS;
            }
        }
        ,
        LTF("f<"){

            @Override
            Op not() {
                return GTEF;
            }
        }
        ,
        LTEIU("<="){

            @Override
            Op not() {
                return GTIU;
            }
        }
        ,
        LTEIS("s<="){

            @Override
            Op not() {
                return GTIS;
            }
        }
        ,
        LTEF("f<="){

            @Override
            Op not() {
                return GTF;
            }
        }
        ,
        GTIU(">"){

            @Override
            Op not() {
                return LTEIU;
            }
        }
        ,
        GTIS("s>"){

            @Override
            Op not() {
                return LTEIS;
            }
        }
        ,
        GTF("f>"){

            @Override
            Op not() {
                return LTEF;
            }
        }
        ,
        GTEIU(">="){

            @Override
            Op not() {
                return LTIU;
            }
        }
        ,
        GTEIS("s>="){

            @Override
            Op not() {
                return LTIS;
            }
        }
        ,
        GTEF("f>="){

            @Override
            Op not() {
                return LTF;
            }
        };

        private final String str;

        private Op(String str) {
            this.str = str;
        }

        abstract Op not();
    }
}

