/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.x86;

import ghidra.pcode.emu.PcodeStateInitializer;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.util.Msg;
import java.util.List;

public class X86PcodeStateInitializer
implements PcodeStateInitializer {
    private static final List<LanguageID> LANG_IDS = List.of(new LanguageID("x86:LE:32:default"), new LanguageID("x86:LE:64:default"));
    private static final String SOURCE = "FS_OFFSET = 0;\nGS_OFFSET = 0;\n";

    @Override
    public boolean isApplicable(Language language) {
        return false;
    }

    @Override
    public <T> void initializeThread(PcodeThread<T> thread) {
        Msg.warn((Object)this, (Object)"Segmentation is not emulated. Initializing FS_OFFSET and FS_OFFSET to 0.");
        PcodeProgram init = thread.getMachine().compileSleigh("initializer", SOURCE);
        thread.getExecutor().execute(init, thread.getUseropLibrary());
    }
}

