/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.manager;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgCommand;
import agent.dbgeng.manager.DbgManager;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.gadp.impl.DbgModelClientThreadExecutor;
import agent.dbgmodel.gadp.impl.WrappedDbgModel;
import agent.dbgmodel.jna.cmd.DbgApplyMethodsCommand;
import agent.dbgmodel.jna.cmd.DbgGetRegisterMapCommand;
import agent.dbgmodel.jna.cmd.DbgListAttributesCommand;
import agent.dbgmodel.jna.cmd.DbgListElementsCommand;
import agent.dbgmodel.model.impl.DbgModel2TargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.dbg.target.TargetObject;
import ghidra.util.Msg;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public class DbgManager2Impl
extends DbgManagerImpl {
    private DebugClient client;
    private WrappedDbgModel dbgmodel;

    public WrappedDbgModel getAccess() {
        return this.dbgmodel;
    }

    public DebugClient getClient() {
        return this.client;
    }

    public CompletableFuture<Void> start(String[] args) {
        this.state.set((Object)DbgState.STARTING, (Object)DbgCause.Causes.UNCLAIMED);
        boolean create = true;
        if (args.length == 0) {
            this.engThread = new DbgModelClientThreadExecutor(() -> DbgModel.debugCreate());
        } else {
            String remoteOptions = String.join((CharSequence)" ", args);
            this.engThread = new DbgModelClientThreadExecutor(() -> DbgModel.debugConnect(remoteOptions));
            create = false;
        }
        this.engThread.setManager((DbgManager)this);
        AtomicReference<Boolean> creat = new AtomicReference<Boolean>(create);
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then((Executor)this.engThread, seq -> {
            this.doExecute((Boolean)creat.get());
            seq.exit();
        }).finish().exceptionally(exc -> {
            Msg.error((Object)((Object)this), (Object)"start failed");
            return null;
        });
    }

    protected void doExecute(Boolean create) {
        this.dbgmodel = ((DbgModelClientThreadExecutor)this.engThread).getAccess();
        this.reentrantClient = this.dbgmodel.getClient();
        this.client = super.getClient();
        super.doExecute(create);
    }

    public CompletableFuture<List<TargetObject>> listElements(List<String> path, DbgModel2TargetObjectImpl targetObject) {
        return this.execute((DbgCommand)new DbgListElementsCommand(this, path, targetObject));
    }

    public CompletableFuture<? extends Map<String, ?>> listAttributes(List<String> path, DbgModel2TargetObjectImpl targetObject) {
        return this.execute((DbgCommand)new DbgListAttributesCommand(this, path, targetObject));
    }

    public CompletableFuture<? extends TargetObject> applyMethods(List<String> path, DbgModel2TargetObjectImpl targetObject) {
        return this.execute((DbgCommand)new DbgApplyMethodsCommand(this, path, targetObject));
    }

    public CompletableFuture<? extends Map<String, ?>> getRegisterMap(List<String> path) {
        return this.execute((DbgCommand)new DbgGetRegisterMapCommand(this, path));
    }
}

