/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.mz.DOSHeader;
import ghidra.app.util.bin.format.mz.OldStyleExecutable;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.framework.store.LockException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Conv;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class MzLoader
extends AbstractLibrarySupportLoader {
    public static final String MZ_NAME = "Old-style DOS Executable (MZ)";
    private static final String ENTRY_NAME = "entry";
    private static final int INITIAL_SEGMENT_VAL = 4096;
    private static final int FAR_RETURN_OPCODE = 203;
    private static final byte MOVW_DS_OPCODE = -70;
    private static final long MIN_BYTE_LENGTH = 4L;
    private DataConverter converter = LittleEndianDataConverter.INSTANCE;

    @Override
    public int getTierPriority() {
        return 60;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 4L) {
            return loadSpecs;
        }
        OldStyleExecutable ose = new OldStyleExecutable(provider);
        DOSHeader dos = ose.getDOSHeader();
        if (dos.isDosSignature() && !dos.hasNewExeHeader() && !dos.hasPeHeader()) {
            List<QueryResult> results = QueryOpinionService.query(this.getName(), "" + dos.e_magic(), null);
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
            }
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program prog, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        FileBytes fileBytes = MemoryBlockUtils.createFileBytes(prog, provider, monitor);
        AddressFactory af = prog.getAddressFactory();
        if (!(af.getDefaultAddressSpace() instanceof SegmentedAddressSpace)) {
            throw new IOException("Selected Language must have a segmented address space.");
        }
        SegmentedAddressSpace space = (SegmentedAddressSpace)af.getDefaultAddressSpace();
        SymbolTable symbolTable = prog.getSymbolTable();
        ProgramContext context = prog.getProgramContext();
        Memory memory = prog.getMemory();
        OldStyleExecutable ose = new OldStyleExecutable(provider);
        DOSHeader dos = ose.getDOSHeader();
        BinaryReader reader = ose.getBinaryReader();
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing segments...");
        this.processSegments(prog, fileBytes, space, reader, dos, log, monitor);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Adjusting segments...");
        this.adjustSegmentStarts(prog);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing relocations...");
        this.doRelocations(prog, reader, dos);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing symbols...");
        this.createSymbols(space, symbolTable, dos);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Setting registers...");
        Symbol entrySymbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)prog, (String)ENTRY_NAME, err -> log.appendMsg("MZ", err));
        this.setRegisters(context, entrySymbol, memory.getBlocks(), dos);
    }

    private void setRegisters(ProgramContext context, Symbol entry, MemoryBlock[] blocks, DOSHeader dos) {
        if (entry == null) {
            return;
        }
        boolean shouldSetDS = false;
        long dsValue = 0L;
        try {
            for (MemoryBlock block : blocks) {
                if (!block.contains(entry.getAddress())) continue;
                byte instByte = block.getByte(entry.getAddress());
                if (instByte == -70) {
                    byte[] dsBytes = new byte[2];
                    block.getBytes(entry.getAddress().addWrap(1L), dsBytes);
                    dsValue = this.converter.getShort(dsBytes);
                    shouldSetDS = true;
                }
                break;
            }
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        Register ss = context.getRegister("ss");
        Register sp = context.getRegister("sp");
        Register ds = context.getRegister("ds");
        Register cs = context.getRegister("cs");
        try {
            context.setValue(sp, entry.getAddress(), entry.getAddress(), BigInteger.valueOf(Conv.shortToLong((short)dos.e_sp())));
            context.setValue(ss, entry.getAddress(), entry.getAddress(), BigInteger.valueOf(Conv.shortToLong((short)dos.e_ss())));
            BigInteger csValue = BigInteger.valueOf(Conv.intToLong((int)((SegmentedAddress)entry.getAddress()).getSegment()));
            for (MemoryBlock block : blocks) {
                Address start = block.getStart();
                Address end = block.getEnd();
                context.setValue(cs, start, end, csValue);
                if (!shouldSetDS) continue;
                context.setValue(ds, start, end, BigInteger.valueOf(dsValue));
            }
        }
        catch (ContextChangeException contextChangeException) {
            // empty catch block
        }
    }

    private void adjustSegmentStarts(Program prog) {
        Memory mem = prog.getMemory();
        if (!prog.hasExclusiveAccess()) {
            return;
        }
        MemoryBlock[] blocks = mem.getBlocks();
        block6: for (int i = 1; i < blocks.length; ++i) {
            MemoryBlock block = blocks[i];
            if (!block.isInitialized()) continue;
            int mIndex = 15;
            if (block.getSize() <= 16L) {
                mIndex = (int)block.getSize() - 2;
            }
            while (mIndex >= 0) {
                try {
                    Address offAddr = block.getStart().add((long)mIndex);
                    int val = block.getByte(offAddr);
                    if ((val &= 0xFF) == 203) {
                        Address splitAddr = offAddr.add(1L);
                        String oldName = block.getName();
                        mem.split(block, splitAddr);
                        mem.join(blocks[i - 1], blocks[i]);
                        blocks = mem.getBlocks();
                        blocks[i].setName(oldName);
                        continue block6;
                    }
                }
                catch (LockException lockException) {
                }
                catch (MemoryBlockException memoryBlockException) {
                }
                catch (AddressOutOfBoundsException addressOutOfBoundsException) {
                }
                catch (MemoryAccessException memoryAccessException) {
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                --mIndex;
            }
        }
    }

    private void processSegments(Program program, FileBytes fileBytes, SegmentedAddressSpace space, BinaryReader reader, DOSHeader dos, MessageLog log, TaskMonitor monitor) {
        try {
            int relocationTableOffset = Conv.shortToInt((short)dos.e_lfarlc());
            int csStart = 4096;
            int dataStart = dos.e_cparhdr() << 4;
            HashMap<SegmentedAddress, SegmentedAddress> segMap = new HashMap<SegmentedAddress, SegmentedAddress>();
            SegmentedAddress codeAddress = space.getAddress(Conv.shortToInt((short)dos.e_cs()) + csStart, 0);
            segMap.put(codeAddress, codeAddress);
            codeAddress = space.getAddress(csStart, 0);
            segMap.put(codeAddress, codeAddress);
            int numRelocationEntries = dos.e_crlc();
            reader.setPointerIndex(relocationTableOffset);
            for (int i = 0; i < numRelocationEntries; ++i) {
                int off = Conv.shortToInt((short)reader.readNextShort());
                int seg = Conv.shortToInt((short)reader.readNextShort());
                SegmentedAddress segStartAddr = space.getAddress(seg + csStart, 0);
                segMap.put(segStartAddr, segStartAddr);
                int location = (seg << 4) + off;
                int locOffset = location + dataStart;
                int value = Conv.shortToInt((short)reader.readShort(locOffset));
                int fixupAddrSeg = value + csStart & 0xFFFF;
                SegmentedAddress fixupAddr = space.getAddress(fixupAddrSeg, 0);
                segMap.put(fixupAddr, fixupAddr);
            }
            short exeBlockCount = dos.e_cp();
            int exeEndOffset = exeBlockCount * 512;
            short bytesUsedInLastBlock = dos.e_cblp();
            if (bytesUsedInLastBlock != 0) {
                exeEndOffset -= 512 - bytesUsedInLastBlock;
            }
            ArrayList segStartList = new ArrayList(segMap.values());
            int csStartEffective = csStart << 4;
            Collections.sort(segStartList);
            for (int i = 0; i < segStartList.size(); ++i) {
                SegmentedAddress start = (SegmentedAddress)segStartList.get(i);
                int readLoc = (start.getSegment() << 4) - csStartEffective + dataStart;
                if (readLoc < 0) {
                    Msg.error((Object)this, (Object)("Invalid read location " + readLoc));
                    continue;
                }
                int numBytes = 0;
                if (i + 1 < segStartList.size()) {
                    SegmentedAddress end = (SegmentedAddress)segStartList.get(i + 1);
                    int nextLoc = (end.getSegment() << 4) - csStartEffective + dataStart;
                    numBytes = nextLoc - readLoc;
                } else {
                    numBytes = exeEndOffset - readLoc;
                }
                if (numBytes <= 0) {
                    log.appendMsg("No EXE file data available for defined segment at: " + start);
                    continue;
                }
                int numUninitBytes = 0;
                if (readLoc + numBytes > exeEndOffset) {
                    int calcNumBytes = numBytes;
                    numBytes = exeEndOffset - readLoc;
                    numUninitBytes = calcNumBytes - numBytes;
                }
                if (numBytes > 0) {
                    MemoryBlockUtils.createInitializedBlock(program, false, "Seg_" + i, (Address)start, fileBytes, (long)readLoc, numBytes, "", "mz", true, true, true, log);
                }
                if (numUninitBytes <= 0) continue;
                MemoryBlockUtils.createUninitializedBlock(program, false, "Seg_" + i + "u", start.add((long)numBytes), numUninitBytes, "", "mz", true, true, false, log);
            }
            if ((long)exeEndOffset < reader.length()) {
                int extraByteCount = (int)reader.length() - exeEndOffset;
                log.appendMsg("File contains 0x" + Integer.toHexString(extraByteCount) + " extra bytes starting at file offset 0x" + Integer.toHexString(exeEndOffset));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (AddressOverflowException e) {
            throw new RuntimeException(e);
        }
    }

    private void doRelocations(Program prog, BinaryReader reader, DOSHeader dos) {
        try {
            Memory mem = prog.getMemory();
            SegmentedAddressSpace space = (SegmentedAddressSpace)prog.getAddressFactory().getDefaultAddressSpace();
            int relocationTableOffset = Conv.shortToInt((short)dos.e_lfarlc());
            int csStart = 4096;
            int dataStart = dos.e_cparhdr() << 4;
            int numRelocationEntries = dos.e_crlc();
            reader.setPointerIndex(relocationTableOffset);
            for (int i = 0; i < numRelocationEntries; ++i) {
                int off = Conv.shortToInt((short)reader.readNextShort());
                int seg = Conv.shortToInt((short)reader.readNextShort());
                int location = (seg << 4) + off;
                int locOffset = location + dataStart;
                SegmentedAddress fixupAddr = space.getAddress(seg + csStart, off);
                int value = Conv.shortToInt((short)reader.readShort(locOffset));
                int fixupAddrSeg = value + csStart & 0xFFFF;
                mem.setShort((Address)fixupAddr, (short)fixupAddrSeg);
                prog.getRelocationTable().add((Address)fixupAddr, 0, new long[]{off, seg}, null, null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (MemoryAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void createSymbols(SegmentedAddressSpace space, SymbolTable symbolTable, DOSHeader dos) {
        int ipValue = Conv.shortToInt((short)dos.e_ip());
        int codeSegment = Conv.shortToInt((short)dos.e_cs()) + 4096;
        if (codeSegment > 65535) {
            System.out.println("Invalid entry point location: " + Integer.toHexString(codeSegment) + ":" + Integer.toHexString(ipValue));
            return;
        }
        SegmentedAddress addr = space.getAddress(codeSegment, ipValue);
        try {
            symbolTable.createLabel((Address)addr, ENTRY_NAME, SourceType.IMPORTED);
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        symbolTable.addExternalEntryPoint((Address)addr);
    }

    @Override
    public String getName() {
        return MZ_NAME;
    }
}

