/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.rich;

import ghidra.app.util.bin.format.pe.RichTable;
import ghidra.app.util.bin.format.pe.rich.RichHeaderRecord;
import ghidra.app.util.bin.format.pe.rich.RichTableRecordDataType;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.StringUtilities;
import java.util.ArrayList;
import java.util.List;

public class PERichTableDataType
extends DynamicDataType {
    public PERichTableDataType() {
        this(null);
    }

    public PERichTableDataType(DataTypeManager dtm) {
        super(CategoryPath.ROOT, "IMAGE_RICH_HEADER", dtm);
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new PERichTableDataType(dtm);
    }

    public String getMnemonic(Settings settings) {
        return "IMAGE_RICH_HEADER";
    }

    public String getDescription() {
        return "IMAGE_RICH_HEADER";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return new RichTable(buf);
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    protected final synchronized int addComp(DataType dataType, int length, String fieldName, List<DataTypeComponent> comps, int offset, String comment) {
        comps.add((DataTypeComponent)new ReadOnlyDataTypeComponent(dataType, (DynamicDataType)this, length, comps.size(), offset, fieldName, comment));
        return offset + length;
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        RichTable table = new RichTable(buf);
        ArrayList<DataTypeComponent> comps = new ArrayList<DataTypeComponent>();
        PERichXorDataType xor = new PERichXorDataType(table.getMask());
        int offset = 0;
        offset = this.addComp((DataType)new PERichDanSDataType(table.getMask()), 4, "", comps, offset, null);
        offset = this.addComp((DataType)xor, 4, "__pad0", comps, offset, null);
        offset = this.addComp((DataType)xor, 4, "__pad1", comps, offset, null);
        offset = this.addComp((DataType)xor, 4, "__pad2", comps, offset, null);
        RichHeaderRecord[] records = table.getRecords();
        int productFieldNameWidth = 1;
        for (int numRecs = records.length; numRecs > 10; numRecs /= 10) {
            ++productFieldNameWidth;
        }
        for (int i = 0; i < records.length; ++i) {
            RichHeaderRecord record = records[i];
            RichTableRecordDataType recType = new RichTableRecordDataType(record);
            String fieldName = String.format("product_%0" + productFieldNameWidth + "d", i);
            String comment = String.format("%s; %d %s", record.getCompId().toString(), record.getObjectCount(), record.getObjectCount() == 1 ? "Object" : "Objects");
            offset = this.addComp((DataType)recType, 8, fieldName, comps, offset, comment);
        }
        offset = this.addComp((DataType)new PERichSignatureDataType(), 4, "signature", comps, offset, null);
        offset = this.addComp((DataType)DWordDataType.dataType, 4, "mask", comps, offset, null);
        return comps.toArray(new DataTypeComponent[comps.size()]);
    }

    private class PERichXorDataType
    extends BuiltIn {
        private final int mask;

        public PERichXorDataType(int mask) {
            this(null, mask);
        }

        public PERichXorDataType(DataTypeManager dtm, int mask) {
            super(new CategoryPath("/PE"), "XOR Field", dtm);
            this.mask = mask;
        }

        public boolean hasLanguageDependantLength() {
            return false;
        }

        public DataType clone(DataTypeManager dtm) {
            if (dtm == this.getDataTypeManager()) {
                return this;
            }
            return new PERichXorDataType(dtm, this.mask);
        }

        public String getMnemonic(Settings settings) {
            return "xorddw";
        }

        public int getLength() {
            return 4;
        }

        public String getDescription() {
            return "";
        }

        public Object getValue(MemBuffer buf, Settings settings, int length) {
            try {
                return buf.getInt(0) ^ this.mask;
            }
            catch (MemoryAccessException mae) {
                return 0;
            }
        }

        public String getRepresentation(MemBuffer buf, Settings settings, int length) {
            try {
                return new Integer(buf.getInt(0) ^ this.mask).toString();
            }
            catch (MemoryAccessException mae) {
                return "0";
            }
        }
    }

    private class PERichDanSDataType
    extends BuiltIn {
        private final int mask;

        public PERichDanSDataType(int mask) {
            this(null, mask);
        }

        public PERichDanSDataType(DataTypeManager dtm, int mask) {
            super(new CategoryPath("/PE"), "DanS Field", dtm);
            this.mask = mask;
        }

        public boolean hasLanguageDependantLength() {
            return false;
        }

        public DataType clone(DataTypeManager dtm) {
            if (dtm == this.getDataTypeManager()) {
                return this;
            }
            return new PERichDanSDataType(dtm, this.mask);
        }

        public String getMnemonic(Settings settings) {
            return "";
        }

        public int getLength() {
            return 4;
        }

        public String getDescription() {
            return "";
        }

        public Object getValue(MemBuffer buf, Settings settings, int length) {
            try {
                return buf.getInt(0) ^ this.mask;
            }
            catch (MemoryAccessException mae) {
                return 0;
            }
        }

        public String getRepresentation(MemBuffer buf, Settings settings, int length) {
            Integer value = (Integer)this.getValue(buf, settings, length);
            byte[] bytes = new byte[4];
            bytes[3] = (byte)(value >> 24 & 0xFF);
            bytes[2] = (byte)(value >> 16 & 0xFF);
            bytes[1] = (byte)(value >> 8 & 0xFF);
            bytes[0] = (byte)(value & 0xFF);
            return StringUtilities.toQuotedString((byte[])bytes, (int)1);
        }
    }

    private class PERichSignatureDataType
    extends BuiltIn {
        public PERichSignatureDataType() {
            this(null);
        }

        public PERichSignatureDataType(DataTypeManager dtm) {
            super(new CategoryPath("/PE"), "Signature Field", dtm);
        }

        public boolean hasLanguageDependantLength() {
            return false;
        }

        public DataType clone(DataTypeManager dtm) {
            if (dtm == this.getDataTypeManager()) {
                return this;
            }
            return new PERichSignatureDataType(dtm);
        }

        public String getMnemonic(Settings settings) {
            return "";
        }

        public int getLength() {
            return 4;
        }

        public String getDescription() {
            return "";
        }

        public Object getValue(MemBuffer buf, Settings settings, int length) {
            try {
                return buf.getInt(0);
            }
            catch (MemoryAccessException mae) {
                return 0;
            }
        }

        public String getRepresentation(MemBuffer buf, Settings settings, int length) {
            Integer value = (Integer)this.getValue(buf, settings, length);
            byte[] bytes = new byte[4];
            bytes[3] = (byte)(value >> 24 & 0xFF);
            bytes[2] = (byte)(value >> 16 & 0xFF);
            bytes[1] = (byte)(value >> 8 & 0xFF);
            bytes[0] = (byte)(value & 0xFF);
            return StringUtilities.toQuotedString((byte[])bytes, (int)1);
        }
    }
}

