/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.resource.ResourceDataEntry;
import ghidra.app.util.bin.format.pe.resource.ResourceDirectory;
import ghidra.app.util.bin.format.pe.resource.ResourceDirectoryEntry;
import ghidra.app.util.bin.format.pe.resource.ResourceDirectoryStringU;
import ghidra.app.util.bin.format.pe.resource.ResourceInfo;
import ghidra.app.util.bin.format.pe.resource.VS_VERSION_CHILD;
import ghidra.app.util.bin.format.pe.resource.VS_VERSION_INFO;
import ghidra.app.util.datatype.microsoft.GroupIconResourceDataType;
import ghidra.app.util.datatype.microsoft.HTMLResourceDataType;
import ghidra.app.util.datatype.microsoft.MUIResourceDataType;
import ghidra.app.util.datatype.microsoft.WEVTResourceDataType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BitmapResourceDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DialogResourceDataType;
import ghidra.program.model.data.GifDataType;
import ghidra.program.model.data.IconResourceDataType;
import ghidra.program.model.data.MenuResourceDataType;
import ghidra.program.model.data.PascalUnicodeDataType;
import ghidra.program.model.data.PngDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.data.WAVEDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class ResourceDataDirectory
extends DataDirectory {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_RESOURCE";
    public static final int IMAGE_SIZEOF_RESOURCE_DIRECTORY_ENTRY = 8;
    public static final int IMAGE_SIZEOF_RESOURCE_DIRECTORY = 16;
    public static final int IMAGE_RESOURCE_NAME_IS_STRING = Integer.MIN_VALUE;
    public static final int IMAGE_RESOURCE_DATA_IS_DIRECTORY = Integer.MIN_VALUE;
    public static final String[] PREDEFINED_RESOURCE_NAMES = new String[]{"0", "Cursor", "Bitmap", "Icon", "Menu", "Dialog", "StringTable", "FontDir", "Font", "Accelerator", "RC_Data", "MessageTable", "GroupCursor", "13", "GroupIcon", "15", "Version", "DialogInclude", "18", "PlugAndPlay", "VXD", "ANI_Cursor", "ANI_Icon", "HTML", "Manifest"};
    public static final String PE_PROPERTY_PROGINFO_PREFIX = "PE Property[";
    public static final String PE_PROPERTY_PROGINFO_SUFFIX = "]";
    public static final byte RT_NOTDEFINED = 0;
    public static final byte RT_CURSOR = 1;
    public static final byte RT_BITMAP = 2;
    public static final byte RT_ICON = 3;
    public static final byte RT_MENU = 4;
    public static final byte RT_DIALOG = 5;
    public static final byte RT_STRING = 6;
    public static final byte RT_FONTDIR = 7;
    public static final byte RT_FONT = 8;
    public static final byte RT_ACCELERATOR = 9;
    public static final byte RT_RCDATA = 10;
    public static final byte RT_MESSAGETABLE = 11;
    public static final byte RT_GROUP_CURSOR = 12;
    public static final byte RT_GROUP_ICON = 14;
    public static final byte RT_VERSION = 16;
    public static final byte RT_DLGINCLUDE = 17;
    public static final byte RT_PLUGPLAY = 19;
    public static final byte RT_VXD = 20;
    public static final byte RT_ANICURSOR = 21;
    public static final byte RT_ANIICON = 22;
    public static final byte RT_HTML = 23;
    public static final byte RT_MANIFEST = 24;
    private ResourceDirectory rootDirectory;
    public static Set<Integer> directoryMap;

    ResourceDataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        directoryMap = new HashSet<Integer>();
        this.processDataDirectory(ntHeader, reader);
    }

    public ResourceDirectory getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        if (this.rootDirectory == null) {
            return;
        }
        monitor.setMessage("[" + program.getName() + "]: resources...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        HashMap<Integer, Integer> countMap = new HashMap<Integer, Integer>();
        List<ResourceInfo> resources = this.getResources();
        if (resources == null) {
            return;
        }
        try {
            for (ResourceInfo info : resources) {
                if (monitor.isCancelled()) {
                    return;
                }
                Integer cnt = (Integer)countMap.get(info.getTypeID());
                if (cnt == null) {
                    countMap.put(info.getTypeID(), 1);
                } else {
                    countMap.put(info.getTypeID(), cnt + 1);
                }
                addr = space.getAddress(this.va(info.getAddress(), isBinary));
                try {
                    program.getSymbolTable().createLabel(addr, info.getName(), SourceType.IMPORTED);
                }
                catch (InvalidInputException e) {
                    Msg.error((Object)this, (Object)("Invalid Input Exception: " + e.getMessage()), (Throwable)e);
                }
                String cmt = "Size of resource: 0x" + Integer.toHexString(info.getSize()) + " bytes";
                StringBuilder extraComment = new StringBuilder();
                if (info.getTypeID() == 0) {
                    if (info.getName().startsWith("Rsrc_IMAGE") || info.getName().startsWith("Rsrc_PNG")) {
                        PngDataType dataType = null;
                        try {
                            if (program.getMemory().getInt(addr) == 1196314761) {
                                dataType = new PngDataType();
                            } else if (program.getMemory().getInt(addr) == 1195984440) {
                                dataType = new GifDataType();
                            }
                        }
                        catch (MemoryAccessException memoryAccessException) {
                            // empty catch block
                        }
                        PeUtils.createData(program, addr, dataType, log);
                    } else if (info.getName().startsWith("Rsrc_WAV")) {
                        WAVEDataType dataType = null;
                        try {
                            if (program.getMemory().getInt(addr) == 1179011410) {
                                dataType = new WAVEDataType();
                            }
                        }
                        catch (MemoryAccessException memoryAccessException) {
                            // empty catch block
                        }
                        PeUtils.createData(program, addr, dataType, log);
                    } else if (info.getName().startsWith("Rsrc_WEVT")) {
                        WEVTResourceDataType dataType = null;
                        try {
                            if (program.getMemory().getInt(addr) == 1296650819) {
                                dataType = new WEVTResourceDataType();
                            }
                        }
                        catch (MemoryAccessException memoryAccessException) {
                            // empty catch block
                        }
                        PeUtils.createData(program, addr, dataType, log);
                    } else if (info.getName().startsWith("Rsrc_MUI")) {
                        MUIResourceDataType dataType = null;
                        try {
                            if (program.getMemory().getInt(addr) == -20054323) {
                                dataType = new MUIResourceDataType();
                            }
                        }
                        catch (MemoryAccessException memoryAccessException) {
                            // empty catch block
                        }
                        PeUtils.createData(program, addr, dataType, log);
                    } else {
                        ArrayDataType byteArray = new ArrayDataType((DataType)ByteDataType.dataType, info.getSize(), 1);
                        PeUtils.createData(program, addr, (DataType)byteArray, log);
                    }
                } else if (info.getTypeID() == 6) {
                    for (int s = 0; s < 16; ++s) {
                        int id = (info.getID() - 1) * 16 + s;
                        this.setEolComment(program, addr, "Rsrc String ID " + id);
                        PascalUnicodeDataType str = new PascalUnicodeDataType();
                        PeUtils.createData(program, addr, (DataType)str, log);
                        Data data = program.getListing().getDataAt(addr);
                        if (data == null) continue;
                        addr = data.getMaxAddress().add(1L);
                    }
                } else if (info.getTypeID() == 2) {
                    BitmapResourceDataType bitmapDatatype = new BitmapResourceDataType();
                    PeUtils.createData(program, addr, (DataType)bitmapDatatype, log);
                } else if (info.getTypeID() == 3) {
                    IconResourceDataType iconDataType = null;
                    try {
                        if (program.getMemory().getInt(addr) == 1196314761) {
                            iconDataType = new PngDataType();
                        } else if (program.getMemory().getInt(addr) == 1195984440) {
                            iconDataType = new GifDataType();
                        }
                    }
                    catch (MemoryAccessException id) {
                        // empty catch block
                    }
                    if (iconDataType == null) {
                        iconDataType = new IconResourceDataType();
                    }
                    PeUtils.createData(program, addr, (DataType)iconDataType, log);
                } else if (info.getTypeID() == 14) {
                    GroupIconResourceDataType groupIconDataType = new GroupIconResourceDataType();
                    PeUtils.createData(program, addr, (DataType)groupIconDataType, log);
                } else if (info.getTypeID() == 4) {
                    MenuResourceDataType menuResourceDataType = new MenuResourceDataType();
                    createData = PeUtils.createData(program, addr, (DataType)menuResourceDataType, log);
                    if (createData != null) {
                        extraComment.append("\n" + this.setExtraCommentForMenuResource(createData));
                    }
                } else if (info.getTypeID() == 5) {
                    DialogResourceDataType dialogResourceDataType = new DialogResourceDataType();
                    createData = PeUtils.createData(program, addr, (DataType)dialogResourceDataType, log);
                    if (createData != null) {
                        extraComment.append("\n" + this.setExtraCommentForDialogResource(createData));
                    }
                } else if (info.getTypeID() == 16) {
                    this.processVersionInfo(addr, info, program, log, monitor);
                } else if (info.getTypeID() == 24) {
                    PeUtils.createData(program, addr, (DataType)TerminatedStringDataType.dataType, log);
                } else if (info.getTypeID() == 23) {
                    HTMLResourceDataType htmlResourceDataType = new HTMLResourceDataType();
                    PeUtils.createData(program, addr, (DataType)htmlResourceDataType, info.getSize(), log);
                } else {
                    ArrayDataType byteArray = new ArrayDataType((DataType)ByteDataType.dataType, info.getSize(), 1);
                    PeUtils.createData(program, addr, (DataType)byteArray, log);
                }
                this.setPlateComment(program, addr, info.getName() + " " + cmt + extraComment);
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Invalid resource data: " + e.getMessage()), (Throwable)e);
        }
        Address resourceBase = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.virtualAddress);
        this.markupDirectory(this.rootDirectory, resourceBase, resourceBase, program, isBinary, monitor, log);
    }

    private void processVersionInfo(Address addr, ResourceInfo info, Program program, MessageLog log, TaskMonitor monitor) throws IOException {
        String[] keys;
        VS_VERSION_CHILD[] children;
        VS_VERSION_INFO versionInfo = null;
        try {
            int ptr = this.ntHeader.rvaToPointer(info.getAddress());
            if (ptr < 0) {
                Msg.error((Object)this, (Object)("Invalid RVA " + Integer.toHexString(info.getAddress())));
                return;
            }
            versionInfo = new VS_VERSION_INFO(this.reader, ptr);
            PeUtils.createData(program, addr, versionInfo.toDataType(), log);
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)"Unexpected Exception: VS_VERSION_INFO structure previously defined", (Throwable)e);
        }
        for (VS_VERSION_CHILD child : children = versionInfo.getChildren()) {
            if (monitor.isCancelled()) {
                return;
            }
            this.markupChild(child, addr, program, log, monitor);
        }
        Options programInfoOptions = program.getOptions("Program Information");
        for (String key : keys = versionInfo.getKeys()) {
            if (monitor.isCancelled()) {
                return;
            }
            String value = versionInfo.getValue(key);
            String optionKey = PE_PROPERTY_PROGINFO_PREFIX + ResourceDataDirectory.escapeProgInfoKeyValue(key) + PE_PROPERTY_PROGINFO_SUFFIX;
            programInfoOptions.setString(optionKey, value);
        }
    }

    private static String escapeProgInfoKeyValue(String key) {
        return key.replaceAll("\\.", "_dot_");
    }

    private void markupChild(VS_VERSION_CHILD child, Address parentAddr, Program program, MessageLog log, TaskMonitor monitor) {
        Address childAddr = parentAddr.add(child.getRelativeOffset());
        try {
            DataType infoType = child.toDataType();
            if (infoType == null) {
                return;
            }
            PeUtils.createData(program, childAddr, infoType, log);
            PeUtils.createData(program, childAddr.add(child.getNameRelativeOffset()), (DataType)TerminatedUnicodeDataType.dataType, log);
            if (child.valueIsUnicodeString()) {
                PeUtils.createData(program, childAddr.add(child.getValueRelativeOffset()), (DataType)TerminatedUnicodeDataType.dataType, log);
            } else if (child.valueIsDWord()) {
                PeUtils.createData(program, childAddr.add(child.getValueRelativeOffset()), (DataType)DWordDataType.dataType, log);
            } else if (child.hasChildren()) {
                VS_VERSION_CHILD[] children;
                for (VS_VERSION_CHILD element : children = child.getChildren()) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    this.markupChild(element, childAddr, program, log, monitor);
                }
            }
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + child.getChildName() + " structure previously defined"), (Throwable)e);
        }
    }

    private void markupDirectory(ResourceDirectory directory, Address directoryAddr, Address resourceBase, Program program, boolean isBinary, TaskMonitor monitor, MessageLog log) throws IOException, DuplicateNameException, CodeUnitInsertionException {
        PeUtils.createData(program, directoryAddr, directory.toDataType(), log);
        directoryAddr = directoryAddr.add(16L);
        List<ResourceDirectoryEntry> entries = directory.getEntries();
        for (ResourceDirectoryEntry entry : entries) {
            ResourceDirectoryStringU string;
            ResourceDataEntry data;
            if (monitor.isCancelled()) {
                return;
            }
            PeUtils.createData(program, directoryAddr, entry.toDataType(), log);
            directoryAddr = directoryAddr.add(8L);
            ResourceDirectory subDirectory = entry.getSubDirectory();
            if (subDirectory != null) {
                Address subDirectoryAddr = resourceBase.add((long)entry.getOffsetToDirectory());
                this.markupDirectory(subDirectory, subDirectoryAddr, resourceBase, program, isBinary, monitor, log);
            }
            if ((data = entry.getData()) != null) {
                Address dataAddr = resourceBase.add((long)entry.getOffsetToData());
                PeUtils.createData(program, dataAddr, data.toDataType(), log);
            }
            if ((string = entry.getDirectoryString()) == null || string.getLength() <= 0) continue;
            Address strAddr = resourceBase.add((long)(entry.getNameOffset() & Integer.MAX_VALUE));
            PeUtils.createData(program, strAddr, string.toDataType(), log);
        }
    }

    @Override
    public boolean parse() throws IOException {
        int ptr = this.getPointer();
        if (ptr < 0) {
            return false;
        }
        int resourceBase = ptr;
        this.rootDirectory = new ResourceDirectory(this.reader, ptr, resourceBase, true, this.ntHeader);
        return true;
    }

    private String setExtraCommentForDialogResource(Data data) throws MemoryAccessException {
        int offset;
        Data componentAt;
        String[] afterTemplate = new String[]{"Menu", "Class", "Title", "Font Size", "Font Name"};
        String[] templateType0 = new String[]{"None", "Predefined", "None"};
        String[] afterItem = new String[]{"Class", "Title", "Data"};
        DialogResourceDataType temp = new DialogResourceDataType();
        DumbMemBufferImpl buffer = new DumbMemBufferImpl(data.getMemory(), data.getAddress());
        StringBuilder comment = new StringBuilder();
        if (data.getBaseDataType().getName().equals("DialogResource") && (componentAt = data.getComponentAt(offset = 0)).isStructure() && componentAt.getBaseDataType().getName().equals("DLGTEMPLATE")) {
            short ordinal;
            int i;
            int numAfter = 3;
            if ((buffer.getByte(0) & 0x40) > 0) {
                numAfter += 2;
            }
            int numItems = buffer.getShort(offset + 8);
            int currentItem = 0;
            comment.append("\nNumber of Items in Dialog: " + numItems);
            for (i = 0; i < numAfter; ++i) {
                componentAt = data.getComponentAt(offset += componentAt.getLength());
                comment.append("\n" + afterTemplate[i] + ": ");
                if (componentAt.getBaseDataType().getName().equals("short")) {
                    comment.append(componentAt.getDefaultValueRepresentation());
                }
                if (componentAt.getBaseDataType().getName().equals("short[1]") && buffer.getShort(offset) == 0) {
                    comment.append(templateType0[i]);
                }
                if (componentAt.getBaseDataType().getName().equals("short[2]") && (buffer.getShort(offset) & 0xFFFF) == 65535) {
                    ordinal = buffer.getShort(offset + 2);
                    comment.append("External Ordinal Number " + ordinal);
                }
                if (!componentAt.getBaseDataType().getName().equals("unicode")) continue;
                comment.append(this.fixupStringRepForDisplay(componentAt.getDefaultValueRepresentation()));
            }
            comment.append("\n");
            while (currentItem < numItems) {
                if (!(componentAt = data.getComponentAt(offset += componentAt.getLength())).getBaseDataType().getName().equals("DLGITEMTEMPLATE")) continue;
                comment.append("\nItem " + ++currentItem + ": ");
                for (i = 0; i < 3; ++i) {
                    componentAt = data.getComponentAt(offset += componentAt.getLength());
                    comment.append("\n   " + afterItem[i] + ": ");
                    if (componentAt.getBaseDataType().getName().startsWith("short[")) {
                        if (buffer.getShort(offset) == 0) {
                            comment.append("None");
                        } else if ((buffer.getShort(offset) & 0xFFFF) == 65535) {
                            ordinal = buffer.getShort(offset + 2);
                            comment.append(temp.getItemType(Integer.valueOf(ordinal)));
                        } else {
                            short sizeArray = buffer.getShort(offset);
                            comment.append("Size " + sizeArray + " (see internals of structure)");
                        }
                    }
                    if (!componentAt.getBaseDataType().getName().equals("unicode")) continue;
                    comment.append(this.fixupStringRepForDisplay(componentAt.getDefaultValueRepresentation()));
                }
            }
        }
        return comment.toString();
    }

    private String fixupStringRepForDisplay(String s) {
        return s.startsWith("u\"") || s.startsWith("U\"") ? s.substring(1) : s;
    }

    private String setExtraCommentForMenuResource(Data data) throws MemoryAccessException {
        int MF_POPUP = 16;
        int MF_END = 128;
        DumbMemBufferImpl buffer = new DumbMemBufferImpl(data.getMemory(), data.getAddress());
        StringBuilder comment = new StringBuilder();
        if (data.getBaseDataType().getName().equals("MenuResource")) {
            short menuItemOption = 0;
            Stack<Short> parentItemOptions = new Stack<Short>();
            parentItemOptions.push((short)0);
            int numComponents = data.getNumComponents();
            for (int i = 0; i < numComponents; ++i) {
                DataType dt = data.getComponent(i).getBaseDataType();
                int offset = data.getComponent(i).getRootOffset();
                if (dt.getName().equals("MENUITEM_TEMPLATE_HEADER")) {
                    short version = buffer.getShort(offset);
                    if (version != 0) {
                        return null;
                    }
                    short menuItemOffset = buffer.getShort(offset + 2);
                    if (menuItemOffset < 0) {
                        return null;
                    }
                }
                if (dt.getName().equals("word") && ((menuItemOption = buffer.getShort(offset)) & MF_POPUP) == 0) {
                    ++i;
                }
                if (!dt.getName().equals("unicode")) continue;
                int depth = parentItemOptions.size() - 1;
                if (depth == 0) {
                    comment.append("\n");
                } else {
                    comment.append(" ".repeat(2 * depth));
                }
                String menuString = this.fixupStringRepForDisplay(data.getComponentAt(offset).getDefaultValueRepresentation());
                menuString = menuString.replaceAll("\"", "");
                if (menuString.equals("")) {
                    comment.append("-------------------\n");
                } else {
                    comment.append(menuString + "\n");
                }
                if ((menuItemOption & MF_POPUP) == MF_POPUP) {
                    parentItemOptions.push(menuItemOption);
                    continue;
                }
                if ((menuItemOption & MF_END) != MF_END) continue;
                short parentOptions = (Short)parentItemOptions.pop();
                while ((parentOptions & MF_END) == MF_END) {
                    parentOptions = (Short)parentItemOptions.pop();
                }
            }
        }
        return comment.toString();
    }

    public List<ResourceInfo> getResources() {
        ArrayList<ResourceInfo> resources = new ArrayList<ResourceInfo>();
        List<ResourceDirectoryEntry> entries = this.rootDirectory.getEntries();
        for (ResourceDirectoryEntry entry : entries) {
            List<ResourceInfo> entryResources = entry.getResources(0);
            for (ResourceInfo info : entryResources) {
                info.setName("Rsrc_" + info.getName());
                resources.add(info);
            }
        }
        Collections.sort(resources);
        return resources;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.hasParsed) {
            buff.append("\t\tResource Directory: [" + super.toString() + "]\n");
            List<ResourceInfo> resources = this.getResources();
            for (ResourceInfo info : resources) {
                buff.append("\t\t\t0x" + Long.toHexString(info.getAddress()) + "  " + info.getName() + "  Size: 0x" + Integer.toHexString(info.getSize()) + " bytes\n");
            }
        }
        return buff.toString();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return this.rootDirectory.toDataType();
    }
}

