/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class LibObjcOptimization
implements StructConverter {
    public static final String SECTION_NAME = "__objc_opt_ro";
    private int version;
    private int flags;
    private int selopt_offset;
    private int headeropt_ro_offset;
    private int clsopt_offset;
    private int protocolopt1_offset;
    private int headeropt_rw_offset;
    private int protocolopt2_offset;
    private int largeSharedCachesClassOffset;
    private int largeSharedCachesProtocolOffset;
    private long relativeMethodSelectorBaseAddressOffset;
    private long objcOptAddr;

    public LibObjcOptimization(Program program, Address objcOptRoSectionAddr) throws IOException {
        try (MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), objcOptRoSectionAddr);){
            BinaryReader reader = new BinaryReader(provider, !program.getLanguage().isBigEndian());
            this.version = reader.readNextInt();
            if (this.version <= 14) {
                this.selopt_offset = reader.readNextInt();
                this.headeropt_ro_offset = reader.readNextInt();
                this.clsopt_offset = reader.readNextInt();
                if (this.version >= 13) {
                    this.protocolopt1_offset = reader.readNextInt();
                }
            } else {
                this.flags = reader.readNextInt();
                this.selopt_offset = reader.readNextInt();
                this.headeropt_ro_offset = reader.readNextInt();
                this.clsopt_offset = reader.readNextInt();
                this.protocolopt1_offset = reader.readNextInt();
                this.headeropt_rw_offset = reader.readNextInt();
                this.protocolopt2_offset = reader.readNextInt();
                if (this.version >= 16) {
                    this.largeSharedCachesClassOffset = reader.readNextInt();
                    this.largeSharedCachesProtocolOffset = reader.readNextInt();
                    this.relativeMethodSelectorBaseAddressOffset = reader.readNextLong();
                }
            }
        }
        this.objcOptAddr = objcOptRoSectionAddr.getOffset();
    }

    public long getAddr() {
        return this.objcOptAddr;
    }

    public long getRelativeSelectorBaseAddressOffset() {
        return this.relativeMethodSelectorBaseAddressOffset;
    }

    public void markup(Program program, AddressSpace space, MessageLog log, TaskMonitor monitor) {
        Address addr = space.getAddress(this.getAddr());
        try {
            DataUtilities.createData((Program)program, (Address)addr, (DataType)this.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(LibObjcOptimization.class.getSimpleName(), "Failed to markup objc_opt_t.");
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_opt_t", 0);
        if (this.version <= 12) {
            struct.add(DWORD, "version", "");
            struct.add(DWORD, "selopt_offset", "");
            struct.add(DWORD, "headeropt_offset", "");
            struct.add(DWORD, "clsopt_offset", "");
        } else if (this.version >= 13 && this.version <= 14) {
            struct.add(DWORD, "version", "");
            struct.add(DWORD, "selopt_offset", "");
            struct.add(DWORD, "headeropt_offset", "");
            struct.add(DWORD, "clsopt_offset", "");
            struct.add(DWORD, "protocolopt_offset", "");
        } else if (this.version == 15) {
            struct.add(DWORD, "version", "");
            struct.add(DWORD, "flags", "");
            struct.add(DWORD, "selopt_offset", "");
            struct.add(DWORD, "headeropt_ro_offset", "");
            struct.add(DWORD, "clsopt_offset", "");
            struct.add(DWORD, "unused_protocolopt_offset", "");
            struct.add(DWORD, "headeropt_rw_offset", "");
            struct.add(DWORD, "protocolopt_offset", "");
        } else {
            struct.add(DWORD, "version", "");
            struct.add(DWORD, "flags", "");
            struct.add(DWORD, "selopt_offset", "");
            struct.add(DWORD, "headeropt_ro_offset", "");
            struct.add(DWORD, "unused_clsopt_offset", "");
            struct.add(DWORD, "unused_protocolopt_offset", "");
            struct.add(DWORD, "headeropt_rw_offset", "");
            struct.add(DWORD, "unused_protocolopt2_offset", "");
            struct.add(DWORD, "largeSharedCachesClassOffset", "");
            struct.add(DWORD, "largeSharedCachesProtocolOffset", "");
            struct.add(QWORD, "relativeMethodSelectorBaseAddressOffset", "");
        }
        return struct;
    }
}

