/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.dyld;

import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.DynamicLibrary;
import ghidra.app.util.bin.format.macho.commands.DynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.FileSetEntryCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.util.DataConverter;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public abstract class AbstractDyldInfoState {
    protected MachHeader header;
    protected Program program;
    String symbolName;
    int type = 0;
    int libraryOrdinal = 0;
    long segmentOffset = 0L;
    int segmentIndex = 0;
    long addend = 0L;

    protected AbstractDyldInfoState(MachHeader header, Program program) {
        this.header = header;
        this.program = program;
    }

    public abstract String print();

    public final void perform(TaskMonitor monitor) throws Exception {
        monitor.setMessage("Performing bind: " + this.symbolName);
        Symbol symbol = this.getSymbol();
        if (symbol == null) {
            return;
        }
        long offset = symbol.getAddress().getOffset();
        DataConverter converter = DataConverter.getInstance((boolean)this.program.getLanguage().isBigEndian());
        byte[] bytes = this.program.getDefaultPointerSize() == 8 ? converter.getBytes(offset) : converter.getBytes((int)offset);
        Address address = this.getAddress();
        byte[] originalBytes = new byte[bytes.length];
        this.program.getMemory().getBytes(address, originalBytes);
        this.program.getMemory().setBytes(address, bytes);
    }

    private Symbol getSymbol() {
        SymbolIterator symbolIterator = this.program.getSymbolTable().getSymbols(this.symbolName);
        if (symbolIterator.hasNext()) {
            return symbolIterator.next();
        }
        return null;
    }

    protected Address getAddress() {
        long result = this.getSegmentStartAddress() + this.segmentOffset;
        AddressFactory factory = this.program.getAddressFactory();
        AddressSpace space = factory.getDefaultAddressSpace();
        if (this.program.getDefaultPointerSize() == 8) {
            return space.getAddress(result);
        }
        return space.getAddress(result & 0xFFFFFFFFL);
    }

    protected String getTypeName() {
        switch (this.type) {
            case 1: {
                return "pointer";
            }
            case 2: {
                return "text_absolute32";
            }
            case 3: {
                return "text_pcrel32";
            }
        }
        throw new RuntimeException("unknown dyld info type: " + Integer.toHexString(this.type));
    }

    protected String getOrdinalName() {
        switch (this.libraryOrdinal) {
            case 0: {
                return "this-image";
            }
            case -1: {
                return "main-executable";
            }
            case -2: {
                return "flat-namespace";
            }
        }
        if (this.libraryOrdinal < -2) {
            return "unknown dyld info special ordinal" + Integer.toHexString(this.libraryOrdinal);
        }
        List<DynamicLibraryCommand> dylibCommands = this.header.getLoadCommands(DynamicLibraryCommand.class);
        if (this.libraryOrdinal > dylibCommands.size()) {
            return "dyld info library ordinal out of range" + Integer.toHexString(this.libraryOrdinal);
        }
        DynamicLibraryCommand dylibCommand = dylibCommands.get(this.libraryOrdinal - 1);
        DynamicLibrary dynamicLibrary = dylibCommand.getDynamicLibrary();
        LoadCommandString name = dynamicLibrary.getName();
        return name.getString();
    }

    protected long getSegmentStartAddress() {
        List<SegmentCommand> segments = this.header.getLoadCommands(SegmentCommand.class);
        SegmentCommand segment = segments.get(this.segmentIndex);
        return segment.getVMaddress();
    }

    protected String getSegmentName() {
        List<SegmentCommand> segments = this.header.getLoadCommands(SegmentCommand.class);
        SegmentCommand segment = segments.get(this.segmentIndex);
        List<FileSetEntryCommand> fileSetEntries = this.header.getLoadCommands(FileSetEntryCommand.class);
        for (FileSetEntryCommand fileSetEntryCommand : fileSetEntries) {
            if (fileSetEntryCommand.getFileOffset() != segment.getFileOffset()) continue;
            return fileSetEntryCommand.getFileSetEntryId().getString();
        }
        return segment.getSegmentName();
    }
}

