/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FactoryStructureDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class GnuBuildIdSection
extends FactoryStructureDataType {
    public static final String BUILD_ID_SECTION_NAME = ".note.gnu.build-id";
    private static final int MAX_SANE_STR_LENS = 1024;
    private long sectionSize;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GnuBuildIdValues fromProgram(Program program) {
        MemoryBlock buildIdSection = program.getMemory().getBlock(BUILD_ID_SECTION_NAME);
        if (buildIdSection == null) {
            return null;
        }
        try (MemoryByteProvider bp = MemoryByteProvider.createMemoryBlockByteProvider(program.getMemory(), buildIdSection);){
            BinaryReader br = new BinaryReader(bp, !program.getMemory().isBigEndian());
            long nameLen = br.readNextUnsignedInt();
            long descLen = br.readNextUnsignedInt();
            int vendorType = br.readNextInt();
            if (nameLen > 1024L || descLen > 1024L) {
                GnuBuildIdValues gnuBuildIdValues2 = null;
                return gnuBuildIdValues2;
            }
            String name = br.readNextAsciiString((int)nameLen);
            byte[] desc = br.readNextByteArray((int)descLen);
            GnuBuildIdValues gnuBuildIdValues = new GnuBuildIdValues(name, desc, vendorType);
            return gnuBuildIdValues;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public GnuBuildIdSection(DataTypeManager dtm, long sectionSize) {
        super("Gnu_BuildId", dtm);
        this.sectionSize = sectionSize;
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.dataMgr) {
            return this;
        }
        return new GnuBuildIdSection(dtm, this.sectionSize);
    }

    protected void populateDynamicStructure(MemBuffer buf, Structure es) {
        try {
            long nameLen = buf.getUnsignedInt(0);
            long descLen = buf.getUnsignedInt(4);
            if (nameLen > 1024L || descLen > 1024L || nameLen + descLen + 12L > this.sectionSize) {
                return;
            }
            es.add(StructConverter.DWORD, "namesz", "Length of name field");
            es.add(StructConverter.DWORD, "descsz", "Length of description field");
            es.add(StructConverter.DWORD, "type", "Vendor specific type");
            if (nameLen > 0L) {
                es.add((DataType)StringDataType.dataType, (int)nameLen, "name", "Build-id vendor name");
            }
            if (descLen > 0L) {
                es.add((DataType)new ArrayDataType(StructConverter.BYTE, (int)descLen, StructConverter.BYTE.getLength(), this.dataMgr), "description", "Build-id value");
            }
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
    }

    protected Structure setCategoryPath(Structure struct, MemBuffer buf) {
        try {
            struct.setCategoryPath(new CategoryPath("/ELF"));
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        return struct;
    }

    public static class GnuBuildIdValues {
        private static final int SHA1_DESC_LEN = 20;
        private String name;
        private byte[] description;
        private int vendorType;

        private GnuBuildIdValues(String name, byte[] description, int vendorType) {
            this.name = name;
            this.description = description;
            this.vendorType = vendorType;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getDescription() {
            return this.description;
        }

        public int getVendorType() {
            return this.vendorType;
        }

        public boolean isValid() {
            return "GNU".equals(this.name) && this.description.length == 20;
        }
    }
}

