/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.format.elf.ElfFileSection;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfStringTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ElfSymbolTable
implements ElfFileSection,
ByteArrayConverter {
    private ElfStringTable stringTable;
    private ElfSectionHeader symbolTableSection;
    private int[] symbolSectionIndexTable;
    private long fileOffset;
    private long addrOffset;
    private long length;
    private long entrySize;
    private int symbolCount;
    private boolean is32bit;
    private boolean isDynamic;
    private ElfSymbol[] symbols;

    public ElfSymbolTable(BinaryReader reader, ElfHeader header, ElfSectionHeader symbolTableSection, long fileOffset, long addrOffset, long length, long entrySize, ElfStringTable stringTable, int[] symbolSectionIndexTable, boolean isDynamic) throws IOException {
        this.symbolTableSection = symbolTableSection;
        this.fileOffset = fileOffset;
        this.addrOffset = addrOffset;
        this.length = length;
        this.entrySize = entrySize;
        this.stringTable = stringTable;
        this.is32bit = header.is32Bit();
        this.symbolSectionIndexTable = symbolSectionIndexTable;
        this.isDynamic = isDynamic;
        long ptr = reader.getPointerIndex();
        reader.setPointerIndex(fileOffset);
        ArrayList<ElfSymbol> symbolList = new ArrayList<ElfSymbol>();
        this.symbolCount = (int)(length / entrySize);
        long entryPos = reader.getPointerIndex();
        for (int i = 0; i < this.symbolCount; ++i) {
            reader.setPointerIndex(entryPos);
            ElfSymbol sym = new ElfSymbol(reader, i, this, header);
            symbolList.add(sym);
            entryPos += entrySize;
        }
        List sortedList = symbolList.stream().sorted((o1, o2) -> Integer.compare(o1.getName(), o2.getName())).collect(Collectors.toList());
        for (ElfSymbol sym : sortedList) {
            sym.initSymbolName(reader, stringTable);
        }
        reader.setPointerIndex(ptr);
        this.symbols = new ElfSymbol[symbolList.size()];
        symbolList.toArray(this.symbols);
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public ElfStringTable getStringTable() {
        return this.stringTable;
    }

    public int getSymbolCount() {
        return this.symbolCount;
    }

    public ElfSymbol[] getSymbols() {
        return this.symbols;
    }

    public int getExtendedSectionIndex(ElfSymbol sym) {
        int symbolTableIndex;
        if (sym.getSectionHeaderIndex() == -1 && this.symbolSectionIndexTable != null && (symbolTableIndex = sym.getSymbolTableIndex()) < this.symbolSectionIndexTable.length) {
            return this.symbolSectionIndexTable[symbolTableIndex];
        }
        return 0;
    }

    public int getSymbolIndex(ElfSymbol symbol) {
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].equals(symbol)) continue;
            return i;
        }
        return -1;
    }

    public ElfSymbol getSymbolAt(long addr) {
        for (ElfSymbol symbol : this.symbols) {
            if (symbol.getValue() != addr) continue;
            return symbol;
        }
        return null;
    }

    public final ElfSymbol getSymbol(int symbolIndex) {
        if (symbolIndex < 0 || symbolIndex >= this.symbols.length) {
            return null;
        }
        return this.symbols[symbolIndex];
    }

    public final String getSymbolName(int symbolIndex) {
        ElfSymbol sym = this.getSymbol(symbolIndex);
        return sym != null ? sym.getNameAsString() : null;
    }

    public final String getFormattedSymbolName(int symbolIndex) {
        ElfSymbol sym = this.getSymbol(symbolIndex);
        return sym != null ? sym.getFormattedName() : "<no name>";
    }

    public ElfSymbol[] getGlobalSymbols() {
        ArrayList<ElfSymbol> list = new ArrayList<ElfSymbol>();
        for (ElfSymbol symbol : this.symbols) {
            if (symbol.getBind() != 1) continue;
            list.add(symbol);
        }
        ElfSymbol[] array = new ElfSymbol[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getSourceFiles() {
        ArrayList<String> list = new ArrayList<String>();
        for (ElfSymbol symbol : this.symbols) {
            String name;
            if (symbol.getType() != 4 || (name = symbol.getNameAsString()) == null) continue;
            list.add(symbol.getNameAsString());
        }
        String[] files = new String[list.size()];
        list.toArray(files);
        return files;
    }

    public void addSymbol(ElfSymbol symbol) {
        ElfSymbol[] tmp = new ElfSymbol[this.symbols.length + 1];
        System.arraycopy(this.symbols, 0, tmp, 0, this.symbols.length);
        tmp[tmp.length - 1] = symbol;
        this.symbols = tmp;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = null;
        int index = 0;
        for (int i = 0; i < this.symbols.length; ++i) {
            byte[] symbytes = this.symbols[i].toBytes(dc);
            if (i == 0) {
                bytes = new byte[this.symbols.length * symbytes.length];
            }
            System.arraycopy(symbytes, 0, bytes, index, symbytes.length);
            index += symbytes.length;
        }
        return bytes;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getAddressOffset() {
        return this.addrOffset;
    }

    public ElfSectionHeader getTableSectionHeader() {
        return this.symbolTableSection;
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    @Override
    public int getEntrySize() {
        return (int)this.entrySize;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        String dtName = this.is32bit ? "Elf32_Sym" : "Elf64_Sym";
        StructureDataType struct = new StructureDataType(new CategoryPath("/ELF"), dtName, 0);
        struct.add(DWORD, "st_name", null);
        if (this.is32bit) {
            struct.add(DWORD, "st_value", null);
            struct.add(DWORD, "st_size", null);
            struct.add(BYTE, "st_info", null);
            struct.add(BYTE, "st_other", null);
            struct.add(WORD, "st_shndx", null);
        } else {
            struct.add(BYTE, "st_info", null);
            struct.add(BYTE, "st_other", null);
            struct.add(WORD, "st_shndx", null);
            struct.add(QWORD, "st_value", null);
            struct.add(QWORD, "st_size", null);
        }
        int sizeRemaining = this.getEntrySize() - struct.getLength();
        if (sizeRemaining > 0) {
            struct.add((DataType)new ArrayDataType((DataType)ByteDataType.dataType, sizeRemaining, 1), "st_unknown", null);
        }
        return new ArrayDataType((DataType)struct, (int)(this.length / this.entrySize), (int)this.entrySize);
    }
}

