/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.extend.ElfLoadAdapter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class ElfRelocation
implements ByteArrayConverter,
StructConverter {
    protected static final String R_OFFSET_COMMENT = "location to apply the relocation action";
    protected static final String R_INFO_COMMENT = "the symbol table index and the type of relocation";
    protected static final String R_ADDEND_COMMENT = "a constant addend used to compute the relocatable field value";
    private long r_offset;
    private long r_info;
    private long r_addend;
    private boolean hasAddend;
    private boolean is32bit;
    private int relocationIndex;

    static ElfRelocation createElfRelocation(BinaryReader reader, ElfHeader elfHeader, int relocationIndex, boolean withAddend) throws IOException {
        Class<? extends ElfRelocation> elfRelocationClazz = ElfRelocation.getElfRelocationClass(elfHeader);
        ElfRelocation elfRelocation = ElfRelocation.getInstance(elfRelocationClazz);
        elfRelocation.initElfRelocation(reader, elfHeader, relocationIndex, withAddend);
        return elfRelocation;
    }

    static ElfRelocation createElfRelocation(ElfHeader elfHeader, int relocationIndex, boolean withAddend, long r_offset, long r_info, long r_addend) throws IOException {
        Class<? extends ElfRelocation> elfRelocationClazz = ElfRelocation.getElfRelocationClass(elfHeader);
        ElfRelocation elfRelocation = ElfRelocation.getInstance(elfRelocationClazz);
        elfRelocation.initElfRelocation(elfHeader, relocationIndex, withAddend, r_offset, r_info, r_addend);
        return elfRelocation;
    }

    private static ElfRelocation getInstance(Class<? extends ElfRelocation> elfRelocationClazz) throws IOException {
        try {
            Constructor<? extends ElfRelocation> constructor = elfRelocationClazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(elfRelocationClazz.getName() + " does not provide default constructor");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static Class<? extends ElfRelocation> getElfRelocationClass(ElfHeader elfHeader) {
        Class<? extends ElfRelocation> elfRelocationClass = null;
        ElfLoadAdapter loadAdapter = elfHeader.getLoadAdapter();
        if (loadAdapter != null) {
            elfRelocationClass = loadAdapter.getRelocationClass(elfHeader);
        }
        if (elfRelocationClass == null) {
            elfRelocationClass = ElfRelocation.class;
        }
        return elfRelocationClass;
    }

    protected void initElfRelocation(BinaryReader reader, ElfHeader elfHeader, int relocationTableIndex, boolean withAddend) throws IOException {
        this.is32bit = elfHeader.is32Bit();
        this.relocationIndex = relocationTableIndex;
        this.hasAddend = withAddend;
        if (reader != null) {
            this.readEntryData(reader);
        }
    }

    protected void initElfRelocation(ElfHeader elfHeader, int relocationTableIndex, boolean withAddend, long r_offset, long r_info, long r_addend) throws IOException {
        this.is32bit = elfHeader.is32Bit();
        this.relocationIndex = relocationTableIndex;
        this.hasAddend = withAddend;
        if (this.is32bit) {
            this.r_offset = Integer.toUnsignedLong((int)r_offset);
            this.r_info = Integer.toUnsignedLong((int)r_info);
            if (this.hasAddend) {
                this.r_addend = Integer.toUnsignedLong((int)r_addend);
            }
        } else {
            this.r_offset = r_offset;
            this.r_info = r_info;
            if (this.hasAddend) {
                this.r_addend = r_addend;
            }
        }
    }

    private void readEntryData(BinaryReader reader) throws IOException {
        if (this.is32bit) {
            this.r_offset = Integer.toUnsignedLong(reader.readNextInt());
            this.r_info = Integer.toUnsignedLong(reader.readNextInt());
            if (this.hasAddend) {
                this.r_addend = Integer.toUnsignedLong(reader.readNextInt());
            }
        } else {
            this.r_offset = reader.readNextLong();
            this.r_info = reader.readNextLong();
            if (this.hasAddend) {
                this.r_addend = reader.readNextLong();
            }
        }
    }

    public int getRelocationIndex() {
        return this.relocationIndex;
    }

    protected boolean is32Bit() {
        return this.is32bit;
    }

    public long getOffset() {
        return this.r_offset;
    }

    public void setOffset(int offset) {
        this.r_offset = (long)offset & 0xFFFFFFFFL;
    }

    public void setOffset(long offset) {
        this.r_offset = offset;
    }

    public int getSymbolIndex() {
        return (int)(this.is32bit ? this.r_info >> 8 : this.r_info >> 32);
    }

    public int getType() {
        return (int)(this.is32bit ? this.r_info & 0xFFL : this.r_info & 0xFFFFFFFFL);
    }

    public void setType(long type) {
        long mask = this.is32bit ? 255L : 0xFFFFFFFFL;
        this.r_info = (this.r_info & (mask ^ 0xFFFFFFFFFFFFFFFFL)) + (type & mask);
    }

    public long getRelocationInfo() {
        return this.r_info;
    }

    public long getAddend() {
        return this.r_addend;
    }

    public boolean hasAddend() {
        return this.hasAddend;
    }

    @Override
    public DataType toDataType() {
        Object dtName;
        Object object = dtName = this.is32bit ? "Elf32_Rel" : "Elf64_Rel";
        if (this.hasAddend) {
            dtName = (String)dtName + "a";
        }
        StructureDataType struct = new StructureDataType(new CategoryPath("/ELF"), (String)dtName, 0);
        DataType fieldDt = this.is32bit ? DWORD : QWORD;
        struct.add(fieldDt, "r_offset", R_OFFSET_COMMENT);
        struct.add(fieldDt, "r_info", R_INFO_COMMENT);
        if (this.hasAddend) {
            struct.add(fieldDt, "r_addend", R_ADDEND_COMMENT);
        }
        return struct;
    }

    public static int getStandardRelocationEntrySize(boolean is64bit, boolean hasAddend) {
        if (is64bit) {
            return hasAddend ? 24 : 16;
        }
        return hasAddend ? 12 : 8;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = new byte[this.sizeof()];
        if (this.is32bit) {
            dc.putInt(bytes, 0, (int)this.r_offset);
            dc.putInt(bytes, 4, (int)this.r_info);
        } else {
            dc.putLong(bytes, 0, this.r_offset);
            dc.putLong(bytes, 8, this.r_info);
        }
        return bytes;
    }

    public String toString() {
        String str = "Offset: 0x" + Long.toHexString(this.getOffset()) + " - Type: 0x" + Long.toHexString(this.getType()) + " - Symbol: 0x" + Long.toHexString(this.getSymbolIndex());
        if (this.hasAddend) {
            str = str + " - Addend: 0x" + Long.toHexString(this.getAddend());
        }
        return str;
    }

    protected int sizeof() {
        if (this.hasAddend) {
            return this.is32bit ? 12 : 24;
        }
        return this.is32bit ? 8 : 16;
    }
}

