/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.cmd.comments.AppendCommentCmd;
import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFLocation;
import ghidra.app.util.bin.format.dwarf4.DWARFRange;
import ghidra.app.util.bin.format.dwarf4.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpression;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionEvaluator;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf4.next.DIEAMonitoredIterator;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataTypeManager;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportOptions;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf4.next.DWARFNameInfo;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.DWARFSourceInfo;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.LocalVariable;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DWARFFunctionImporter {
    private static final int INLINE_FUNC_SHORT_LEN = 8;
    private final DWARFProgram prog;
    private final Program currentProgram;
    private final DWARFDataTypeManager dwarfDTM;
    private final DWARFImportOptions importOptions;
    private ProgramModule rootModule;
    private Set<Long> processedOffsets = new HashSet<Long>();
    private Map<Address, String> functionsProcessed = new HashMap<Address, String>();
    private Set<Address> variablesProcesesed = new HashSet<Address>();
    private TaskMonitor monitor;
    private DWARFImportSummary importSummary;

    public static boolean hasDWARFProgModule(Program prog, String progModuleName) {
        ProgramModule dwarfModule = prog.getListing().getRootModule(progModuleName);
        return dwarfModule != null;
    }

    public DWARFFunctionImporter(DWARFProgram prog, DWARFDataTypeManager dwarfDTM, DWARFImportOptions importOptions, DWARFImportSummary importSummary, TaskMonitor monitor) {
        this.prog = prog;
        this.monitor = monitor;
        this.currentProgram = prog.getGhidraProgram();
        this.dwarfDTM = dwarfDTM;
        this.importOptions = importOptions;
        this.importSummary = importSummary;
    }

    private boolean shouldProcess(DIEAggregate diea) {
        if (this.processedOffsets.contains(diea.getOffset())) {
            return false;
        }
        this.processedOffsets.add(diea.getOffset());
        return true;
    }

    public void importFunctions() throws CancelledException {
        this.rootModule = this.currentProgram.getListing().getRootModule("DWARF");
        if (this.rootModule == null) {
            try {
                this.rootModule = this.currentProgram.getListing().createRootModule("DWARF");
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
        }
        for (DIEAggregate diea : DIEAMonitoredIterator.iterable(this.prog, "DWARF - Create Funcs & Symbols", this.monitor)) {
            this.monitor.checkCanceled();
            try {
                switch (diea.getTag()) {
                    case 46: {
                        try {
                            this.processSubprogram(diea);
                        }
                        catch (InvalidInputException e) {
                            Msg.error((Object)this, (Object)("Failed to process subprog " + diea.getHexOffset()), (Throwable)e);
                        }
                        break;
                    }
                    case 52: {
                        if (diea.getDepth() != 1) break;
                        try {
                            this.processVariable(diea, null, null, -1L);
                        }
                        catch (InvalidInputException e) {
                            Msg.error((Object)this, (Object)("Failed to process var " + diea.getHexOffset()), (Throwable)e);
                        }
                        break;
                    }
                    case 10: {
                        this.processLabel(diea);
                        break;
                    }
                    case 72: 
                    case 16649: {
                        DIEAggregate partDIEA = DIEAggregate.createSkipHead(diea);
                        if (partDIEA == null || this.isBadSubprogramDef(partDIEA)) break;
                        this.processSubprogram(partDIEA);
                    }
                }
            }
            catch (OutOfMemoryError oom) {
                throw oom;
            }
            catch (Throwable th) {
                Msg.error((Object)this, (Object)("Error when processing DWARF information for DIE " + diea.getHexOffset()), (Throwable)th);
                Msg.info((Object)this, (Object)("DIE info:\n" + diea.toString()));
            }
        }
        this.logImportErrorSummary();
    }

    private void logImportErrorSummary() {
        if (!this.importSummary.unknownRegistersEncountered.isEmpty()) {
            Msg.error((Object)this, (Object)("Found " + this.importSummary.unknownRegistersEncountered.size() + " unknown registers referenced in DWARF expression operands:"));
            ArrayList<Integer> sortedUnknownRegs = new ArrayList<Integer>(this.importSummary.unknownRegistersEncountered);
            Collections.sort(sortedUnknownRegs);
            Msg.error((Object)this, (Object)("  unknown registers: " + sortedUnknownRegs.stream().map(i -> Integer.toString(i)).collect(Collectors.joining(", "))));
        }
    }

    private boolean isBadSubprogramDef(DIEAggregate diea) {
        if (diea.isDanglingDeclaration() || !diea.hasAttribute(17)) {
            return true;
        }
        long lowPC = diea.getLowPC(0L);
        DWARFNumericAttribute attr = diea.getAttribute(17, DWARFNumericAttribute.class);
        return attr != null && attr.getUnsignedValue() == 0L && lowPC != 0L;
    }

    private void markAllChildrenAsProcessed(DebugInfoEntry die) {
        for (DebugInfoEntry child : die.getChildren()) {
            this.processedOffsets.add(child.getOffset());
            this.markAllChildrenAsProcessed(child);
        }
    }

    private void processSubprogram(DIEAggregate diea) throws IOException, InvalidInputException, DWARFExpressionException {
        DIEAggregate typeRef;
        List<DWARFLocation> frameBase;
        if (!this.shouldProcess(diea)) {
            return;
        }
        if (this.isBadSubprogramDef(diea)) {
            this.markAllChildrenAsProcessed(diea.getHeadFragment());
            return;
        }
        DWARFFunction dfunc = new DWARFFunction(this.prog.getName(diea));
        dfunc.namespace = dfunc.dni.getParentNamespace(this.currentProgram);
        Long lowPC = diea.getLowPC(0L);
        dfunc.address = this.toAddr(lowPC);
        dfunc.highAddress = diea.hasAttribute(18) ? this.toAddr(diea.getHighPC()) : null;
        String previousFunctionProcessed = this.functionsProcessed.get(dfunc.address);
        if (previousFunctionProcessed != null) {
            this.markAllChildrenAsProcessed(diea.getHeadFragment());
            return;
        }
        this.functionsProcessed.put(dfunc.address, dfunc.dni.getNamespacePath() + " DIE: " + diea.getHexOffset());
        dfunc.isExternal = diea.getBool(63, false);
        DWARFLocation frameLoc = null;
        if (diea.hasAttribute(64) && (frameLoc = DWARFFunctionImporter.getTopLocation(frameBase = diea.getAsLocation(64), dfunc.address.getOffset())) != null) {
            dfunc.frameBase = (int)diea.evaluateLocation(frameLoc);
        }
        DataType formalReturnType = (typeRef = diea.getTypeRef()) != null ? this.dwarfDTM.getDataType(typeRef, DataType.DEFAULT) : this.dwarfDTM.getVoidType();
        dfunc.retval = new DWARFVariable();
        dfunc.retval.type = formalReturnType;
        boolean formalParamsOnly = false;
        boolean skipFuncSignature = false;
        ArrayList<Parameter> formalParams = new ArrayList<Parameter>();
        for (DIEAggregate paramDIEA : diea.getFunctionParamList()) {
            DataType paramDT = this.dwarfDTM.getDataType(paramDIEA.getTypeRef(), null);
            if (paramDT == null || DataTypeComponent.usesZeroLengthComponent((DataType)paramDT)) {
                String paramName = paramDIEA.getString(3, "param" + formalParams.size());
                Msg.warn((Object)this, (Object)("DWARF: zero-length function parameter " + paramName + ":" + paramDT.getName() + ", omitting from definition of " + dfunc.dni.getName() + "@" + dfunc.address));
                continue;
            }
            Parameter formalParam = this.createFormalParameter(paramDIEA);
            if (formalParam == null) {
                skipFuncSignature = true;
                break;
            }
            formalParams.add(formalParam);
            if (formalParamsOnly) continue;
            DWARFVariable var = this.processVariable(paramDIEA, dfunc, null, -1L);
            if (var == null) {
                formalParamsOnly = true;
                dfunc.params.clear();
                continue;
            }
            dfunc.params.add(var);
        }
        dfunc.varArg = !diea.getChildren(24).isEmpty();
        this.processFuncChildren(diea, dfunc);
        Function gfunc = this.createFunction(dfunc, diea);
        if (gfunc != null) {
            if (diea.getBool(135, false)) {
                gfunc.setNoReturn(true);
            }
            if (formalParams.isEmpty() && dfunc.localVarErrors) {
                skipFuncSignature = true;
            } else if (formalParams.isEmpty() && diea.getCompilationUnit().getCompileUnit().getLanguage() == 28) {
                skipFuncSignature = true;
            }
            if (skipFuncSignature) {
                Msg.error((Object)this, (Object)("Failed to get function signature information, leaving undefined: " + gfunc.getName() + "@" + gfunc.getEntryPoint()));
                Msg.debug((Object)this, (Object)("DIE info: " + diea.toString()));
                return;
            }
            if (formalParamsOnly) {
                this.updateFunctionSignatureWithFormalParams(gfunc, formalParams, formalReturnType, dfunc.varArg, diea);
            } else {
                this.updateFunctionSignatureWithDetailParams(gfunc, dfunc, diea);
            }
        }
    }

    private void updateFunctionSignatureWithFormalParams(Function gfunc, List<Parameter> params, DataType returnType, boolean varArgs, DIEAggregate diea) {
        try {
            ReturnParameterImpl returnVar = new ReturnParameterImpl(returnType, this.currentProgram);
            try {
                gfunc.setVarArgs(varArgs);
                gfunc.updateFunction(null, (Variable)returnVar, params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.IMPORTED);
            }
            catch (DuplicateNameException e) {
                this.setUniqueParameterNames(gfunc, params);
                gfunc.updateFunction(null, (Variable)returnVar, params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.IMPORTED);
            }
        }
        catch (DuplicateNameException | InvalidInputException e) {
            Msg.error((Object)this, (Object)("Error updating function " + gfunc.getName() + " with formal params at " + gfunc.getEntryPoint().toString() + ": " + e.getMessage()));
            Msg.error((Object)this, (Object)("DIE info: " + diea.toString()));
        }
    }

    private void updateFunctionSignatureWithDetailParams(Function gfunc, DWARFFunction dfunc, DIEAggregate diea) {
        try {
            int i;
            CompilerSpec compilerSpec = this.currentProgram.getCompilerSpec();
            PrototypeModel convention = null;
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            Variable returnVariable = this.buildReturnVariable(dfunc.retval);
            for (i = 0; i < dfunc.params.size(); ++i) {
                Parameter curparam = this.buildParameter(gfunc, i, dfunc.params.get(i), diea);
                params.add(curparam);
                if (i != 0 || !this.checkThisParameter(dfunc.params.get(0), diea)) continue;
                convention = compilerSpec.matchConvention(GenericCallingConvention.thiscall);
            }
            for (i = 0; i < dfunc.local.size(); ++i) {
                this.commitLocal(gfunc, dfunc.local.get(i));
            }
            if (dfunc.retval != null || params.size() > 0) {
                this.commitPrototype(gfunc, returnVariable, params, convention);
                gfunc.setVarArgs(dfunc.varArg);
            }
        }
        catch (DuplicateNameException | InvalidInputException iie) {
            Msg.error((Object)this, (Object)("Error updating function " + dfunc.dni.getName() + " at " + dfunc.address.toString() + ": " + iie.getMessage()));
        }
    }

    private void processFuncChildren(DIEAggregate diea, DWARFFunction dfunc) throws InvalidInputException, IOException, DWARFExpressionException {
        for (DebugInfoEntry childEntry : diea.getHeadFragment().getChildren()) {
            DIEAggregate childDIEA = this.prog.getAggregate(childEntry);
            switch (childDIEA.getTag()) {
                case 52: {
                    DWARFVariable var = this.processVariable(childDIEA, dfunc, null, dfunc.address.getOffset());
                    if (var == null || !var.isStackOffset) break;
                    dfunc.local.add(var);
                    break;
                }
                case 11: {
                    this.processLexicalBlock(childDIEA, dfunc);
                    break;
                }
                case 10: {
                    this.processLabel(childDIEA);
                    break;
                }
                case 29: {
                    this.processInlinedSubroutine(childDIEA, dfunc);
                    break;
                }
                case 72: 
                case 16649: {
                    DIEAggregate partDIEA = DIEAggregate.createSkipHead(diea);
                    if (partDIEA == null || this.isBadSubprogramDef(partDIEA)) break;
                    this.processSubprogram(partDIEA);
                }
            }
        }
    }

    private Parameter createFormalParameter(DIEAggregate diea) {
        String name = diea.getString(3, null);
        DataType dt = this.dwarfDTM.getDataType(diea.getTypeRef(), this.dwarfDTM.getVoidType());
        try {
            return new ParameterImpl(name, dt, this.currentProgram);
        }
        catch (InvalidInputException e) {
            Msg.debug((Object)this, (Object)("Failed to create parameter for " + diea.toString()));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DWARFVariable processVariable(DIEAggregate diea, DWARFFunction dfunc, Address lexicalStart, long firstUseAddr) throws IOException, InvalidInputException {
        long res;
        if (!this.shouldProcess(diea)) {
            return null;
        }
        long funcAddr = dfunc != null && dfunc.address != null ? dfunc.address.getOffset() : -1L;
        DWARFVariable dvar = new DWARFVariable();
        dvar.dni = this.prog.getName(diea);
        long l = dvar.lexicalOffset = dfunc != null && dfunc.address != null && lexicalStart != null ? lexicalStart.subtract(dfunc.address) : -1L;
        if (!diea.hasAttribute(2)) {
            return null;
        }
        List<DWARFLocation> locList = diea.getAsLocation(2);
        if (firstUseAddr != -1L && locList.size() > 1) {
            return null;
        }
        DWARFLocation topLocation = DWARFFunctionImporter.getTopLocation(locList, funcAddr);
        if (topLocation == null) {
            if (dfunc == null) return null;
            dfunc.localVarErrors = true;
            return null;
        }
        dvar.type = this.dwarfDTM.getDataType(diea.getTypeRef(), this.dwarfDTM.getVoidType());
        long frameBase = dfunc != null ? dfunc.frameBase : -1L;
        DWARFExpressionEvaluator exprEvaluator = DWARFExpressionEvaluator.create(diea.getHeadFragment());
        exprEvaluator.setFrameBase(frameBase);
        try {
            DWARFExpression expr = exprEvaluator.readExpr(topLocation.getLocation());
            exprEvaluator.evaluate(expr);
            res = exprEvaluator.pop();
        }
        catch (DWARFExpressionException | IndexOutOfBoundsException | UnsupportedOperationException ex) {
            ++this.importSummary.exprReadError;
            if (dfunc == null) return null;
            dfunc.localVarErrors = true;
            return null;
        }
        if (exprEvaluator.isDwarfStackValue()) {
            ++this.importSummary.varDWARFExpressionValue;
            if (dfunc == null) return null;
            dfunc.localVarErrors = true;
            return null;
        }
        if (exprEvaluator.useUnknownRegister() && exprEvaluator.isRegisterLocation()) {
            dvar.reg = exprEvaluator.getLastRegister();
            dvar.type = this.dwarfDTM.getPtrTo(dvar.type);
            dvar.offset = dvar.lexicalOffset != -1L ? dvar.lexicalOffset - 1L : -1L;
            return dvar;
        }
        if (exprEvaluator.useUnknownRegister()) {
            ++this.importSummary.varDynamicRegisterError;
            if (dfunc == null) return null;
            dfunc.localVarErrors = true;
            return null;
        }
        if (exprEvaluator.isStackRelative()) {
            dvar.offset = res;
            dvar.reg = null;
            dvar.isStackOffset = true;
            if (!exprEvaluator.isDeref()) return dvar;
            dvar.type = this.dwarfDTM.getPtrTo(dvar.type);
            return dvar;
        }
        if (exprEvaluator.isRegisterLocation()) {
            String contextStr;
            dvar.reg = exprEvaluator.getLastRegister();
            if (dvar.reg == null) {
                this.importSummary.unknownRegistersEncountered.add(exprEvaluator.getRawLastRegister());
                if (dfunc == null) return null;
                dfunc.localVarErrors = true;
                return null;
            }
            dvar.offset = -1L;
            if (firstUseAddr != -1L) {
                dvar.offset = DWARFFunctionImporter.findFirstUse(this.currentProgram, dvar.reg, funcAddr, firstUseAddr);
            }
            if (dvar.type == null) return dvar;
            if (dvar.type.getLength() <= dvar.reg.getMinimumByteSize()) return dvar;
            ++this.importSummary.varFitError;
            String string = contextStr = dfunc != null ? " for function " + dfunc.dni.getName() + "@" + dfunc.address : "";
            if (diea.getTag() != 5) {
                Msg.warn((Object)this, (Object)("Variable " + dvar.dni.getName() + "[" + dvar.type.getName() + ", size=" + dvar.type.getLength() + "]" + contextStr + " can not fit into specified register " + dvar.reg.getName() + ", size=" + dvar.reg.getMinimumByteSize() + ", skipping.  DWARF DIE: " + diea.getHexOffset()));
                if (dfunc == null) return null;
                dfunc.localVarErrors = true;
                return null;
            }
            dvar.type = this.dwarfDTM.getUndefined1Type();
            return dvar;
        }
        if (exprEvaluator.getLastRegister() == null) {
            this.processStaticVar(res, dvar, diea);
            return null;
        }
        Msg.error((Object)this, (Object)("LOCAL VAR: " + dvar.dni.getName() + " : " + DWARFExpression.exprToString(topLocation.getLocation(), diea) + ", DWARF DIE: " + diea.getHexOffset()));
        return null;
    }

    private void processStaticVar(long address, DWARFVariable dvar, DIEAggregate diea) throws InvalidInputException {
        dvar.dni = dvar.dni.replaceType(null);
        if (address != 0L) {
            Address staticVariableAddress = this.toAddr(address + this.prog.getProgramBaseAddressFixup());
            if (this.isZeroByteDataType(dvar.type)) {
                this.processZeroByteStaticVar(staticVariableAddress, dvar);
                return;
            }
            if (this.variablesProcesesed.contains(staticVariableAddress)) {
                return;
            }
            boolean external = diea.getBool(63, false);
            this.outputGlobal(staticVariableAddress, dvar.type, external, DWARFSourceInfo.create(diea), dvar.dni);
        } else {
            this.importSummary.relocationErrorVarDefs.add(dvar.dni.getNamespacePath().asFormattedString() + " : " + dvar.type.getPathName());
        }
    }

    private void processZeroByteStaticVar(Address staticVariableAddress, DWARFVariable dvar) throws InvalidInputException {
        Listing listing = this.currentProgram.getListing();
        Object comment = listing.getComment(1, staticVariableAddress);
        comment = comment != null ? (String)comment + "\n" : "";
        comment = (String)comment + String.format("Zero length variable: %s: %s", dvar.dni.getOriginalName(), dvar.type.getDisplayName());
        listing.setComment(staticVariableAddress, 1, (String)comment);
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        symbolTable.createLabel(staticVariableAddress, dvar.dni.getName(), dvar.dni.getParentNamespace(this.currentProgram), SourceType.IMPORTED);
    }

    private boolean isZeroByteDataType(DataType dt) {
        if (!dt.isZeroLength() && dt instanceof Array) {
            dt = DataTypeUtilities.getArrayBaseDataType((Array)((Array)dt));
        }
        return dt.isZeroLength();
    }

    private void processLexicalBlock(DIEAggregate diea, DWARFFunction dfunc) throws IOException, InvalidInputException, DWARFExpressionException {
        if (!this.shouldProcess(diea)) {
            return;
        }
        DWARFNameInfo dni = this.prog.getName(diea);
        String name = dni.getName();
        Long lowPC = null;
        boolean disjoint = false;
        if (diea.hasAttribute(17) && diea.hasAttribute(18)) {
            lowPC = diea.getLowPC(0L);
        } else if (diea.hasAttribute(85)) {
            List<DWARFRange> ranges = diea.parseDebugRange(85);
            if (ranges.isEmpty()) {
                return;
            }
            lowPC = ranges.get(0).getFrom();
            disjoint = ranges.size() > 1;
        } else {
            Msg.error((Object)this, (Object)"LEXICAL BLOCK: No start and end ranges were found so the lexical block could not be processed.");
            return;
        }
        Address blockStart = this.toAddr(lowPC);
        if (name != null && this.importOptions.isOutputLexicalBlockComments()) {
            this.appendComment(blockStart, 1, "Begin: " + name + (disjoint ? " - Disjoint" : ""), "\n");
        }
        this.processFuncChildren(diea, dfunc);
    }

    private void processInlinedSubroutine(DIEAggregate diea, DWARFFunction dfunc) throws IOException, InvalidInputException, DWARFExpressionException {
        if (!this.shouldProcess(diea)) {
            return;
        }
        Long lowPC = null;
        Long highPC = null;
        if (diea.hasAttribute(17) && diea.hasAttribute(18)) {
            lowPC = diea.getLowPC(0L);
            highPC = diea.getHighPC();
        } else if (diea.hasAttribute(85)) {
            List<DWARFRange> ranges = diea.parseDebugRange(85);
            if (ranges.isEmpty()) {
                return;
            }
            lowPC = ranges.get(0).getFrom();
            highPC = ranges.get(ranges.size() - 1).getTo();
        } else {
            return;
        }
        if (this.importOptions.isOutputInlineFuncComments()) {
            this.addCommentsForInlineFunc(diea, this.toAddr(lowPC), this.toAddr(highPC));
        }
        this.processFuncChildren(diea, dfunc);
    }

    private void addCommentsForInlineFunc(DIEAggregate diea, Address blockStart, Address blockEnd) {
        FunctionDefinition funcDef = this.dwarfDTM.getFunctionSignature(diea);
        if (funcDef != null) {
            boolean isShort;
            long inlineFuncLen = blockEnd.subtract(blockStart);
            boolean bl = isShort = inlineFuncLen < 8L;
            if (isShort) {
                this.appendComment(blockStart, 0, "inline " + funcDef.getPrototypeString(), "; ");
            } else {
                this.appendComment(blockStart, 1, "Begin: inline " + funcDef.getPrototypeString(), "\n");
            }
        }
    }

    private boolean appendComment(Address address, int commentType, String comment, String sep) {
        AppendCommentCmd cmd = new AppendCommentCmd(address, commentType, comment, sep);
        return cmd.applyTo((DomainObject)this.currentProgram);
    }

    private final Address toAddr(Number offset) {
        return this.currentProgram.getAddressFactory().getDefaultAddressSpace().getAddress(offset.longValue(), true);
    }

    private void setExternalEntryPoint(boolean external, Address address) {
        if (external) {
            this.currentProgram.getSymbolTable().addExternalEntryPoint(address);
        } else {
            this.currentProgram.getSymbolTable().removeExternalEntryPoint(address);
        }
    }

    private boolean isArrayDataTypeCompatibleWithExistingData(Array arrayDT, Address address) {
        Listing listing = this.currentProgram.getListing();
        Data arrayData = listing.getDataAt(address);
        if (arrayData != null && arrayData.getBaseDataType().isEquivalent((DataType)arrayDT)) {
            return true;
        }
        if (arrayData != null && arrayDT.getDataType() instanceof CharDataType && arrayData.getBaseDataType() instanceof StringDataType) {
            if (arrayData.getLength() >= arrayDT.getLength()) {
                return true;
            }
            return DataUtilities.isUndefinedRange((Program)this.currentProgram, (Address)address.add((long)arrayData.getLength()), (Address)address.add((long)(arrayDT.getLength() - 1)));
        }
        for (int i = 0; i < arrayDT.getNumElements(); ++i) {
            Address elementAddress = address.add((long)(arrayDT.getElementLength() * i));
            Data data = listing.getDataAt(elementAddress);
            if (data == null || this.isDataTypeCompatibleWithExistingData(arrayDT.getDataType(), elementAddress)) continue;
            return false;
        }
        return true;
    }

    private boolean isStructDataTypeCompatibleWithExistingData(Structure structDT, Address address) {
        for (DataTypeComponent dtc : structDT.getDefinedComponents()) {
            Address memberAddress = address.add((long)dtc.getOffset());
            if (this.isDataTypeCompatibleWithExistingData(dtc.getDataType(), memberAddress)) continue;
            return false;
        }
        return true;
    }

    private boolean isPointerDataTypeCompatibleWithExistingData(Pointer pdt, Address address) {
        Listing listing = this.currentProgram.getListing();
        Data data = listing.getDataAt(address);
        if (data == null) {
            return true;
        }
        DataType dataDT = data.getBaseDataType();
        return dataDT instanceof Pointer;
    }

    private boolean isSimpleDataTypeCompatibleWithExistingData(DataType dataType, Address address) {
        Listing listing = this.currentProgram.getListing();
        Data data = listing.getDataAt(address);
        if (data == null) {
            return true;
        }
        DataType dataDT = data.getBaseDataType();
        if (dataType instanceof CharDataType && dataDT instanceof StringDataType) {
            return true;
        }
        if (!dataType.getClass().isInstance(dataDT)) {
            return false;
        }
        int dataTypeLen = dataType.getLength();
        return dataTypeLen <= 0 || dataTypeLen == data.getLength();
    }

    private boolean isEnumDataTypeCompatibleWithExistingData(Enum enumDT, Address address) {
        Listing listing = this.currentProgram.getListing();
        Data data = listing.getDataAt(address);
        if (data == null) {
            return true;
        }
        DataType dataDT = data.getBaseDataType();
        if (!(dataDT instanceof Enum) && !(dataDT instanceof AbstractIntegerDataType)) {
            return false;
        }
        if (dataDT instanceof BooleanDataType) {
            return false;
        }
        return dataDT.getLength() == enumDT.getLength();
    }

    private boolean isDataTypeCompatibleWithExistingData(DataType dataType, Address address) {
        if (DataUtilities.isUndefinedRange((Program)this.currentProgram, (Address)address, (Address)address.add((long)(dataType.getLength() - 1)))) {
            return true;
        }
        if (dataType instanceof Array) {
            return this.isArrayDataTypeCompatibleWithExistingData((Array)dataType, address);
        }
        if (dataType instanceof Pointer) {
            return this.isPointerDataTypeCompatibleWithExistingData((Pointer)dataType, address);
        }
        if (dataType instanceof Structure) {
            return this.isStructDataTypeCompatibleWithExistingData((Structure)dataType, address);
        }
        if (dataType instanceof TypeDef) {
            return this.isDataTypeCompatibleWithExistingData(((TypeDef)dataType).getBaseDataType(), address);
        }
        if (dataType instanceof Enum) {
            return this.isEnumDataTypeCompatibleWithExistingData((Enum)dataType, address);
        }
        if (dataType instanceof CharDataType || dataType instanceof StringDataType || dataType instanceof IntegerDataType || dataType instanceof UnsignedIntegerDataType || dataType instanceof BooleanDataType) {
            return this.isSimpleDataTypeCompatibleWithExistingData(dataType, address);
        }
        return false;
    }

    private Data createVariable(Address address, DataType dataType, DWARFNameInfo dni) {
        try {
            String eolComment = null;
            if (dataType instanceof Dynamic || dataType instanceof FactoryDataType) {
                eolComment = "Unsupported dynamic data type: " + dataType;
                dataType = Undefined.getUndefinedDataType((int)1);
            }
            if (!this.isDataTypeCompatibleWithExistingData(dataType, address)) {
                this.appendComment(address, 0, "Could not place DWARF static variable " + dni.getNamespacePath().asFormattedString() + " : " + dataType + " because existing data type conflicts.", "\n");
                return null;
            }
            Data result = DataUtilities.createData((Program)this.currentProgram, (Address)address, (DataType)dataType, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
            this.variablesProcesesed.add(address);
            if (eolComment != null) {
                this.appendComment(address, 0, eolComment, "\n");
            }
            return result;
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)("Error creating data object at " + address), (Throwable)e);
            return null;
        }
    }

    private void outputGlobal(Address address, DataType baseDataType, boolean external, DWARFSourceInfo sourceInfo, DWARFNameInfo dni) {
        Namespace namespace = dni.getParentNamespace(this.currentProgram);
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        try {
            symbolTable.createLabel(address, dni.getName(), namespace, SourceType.IMPORTED);
            SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(address, dni.getName(), namespace);
            cmd.applyTo((DomainObject)this.currentProgram);
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Error creating symbol " + namespace + "/" + dni.getName() + " at " + address));
            return;
        }
        this.setExternalEntryPoint(external, address);
        Data varData = this.createVariable(address, baseDataType, dni);
        ++this.importSummary.globalVarsAdded;
        if (sourceInfo != null) {
            this.appendComment(address, 0, sourceInfo.getDescriptionStr(), "\n");
            if (varData != null) {
                this.moveIntoFragment(dni.getName(), varData.getMinAddress(), varData.getMaxAddress(), sourceInfo.getFilename());
            }
        }
    }

    private static DWARFLocation getTopLocation(List<DWARFLocation> locList, long funcAddr) {
        if (locList.size() == 1) {
            return locList.get(0);
        }
        for (DWARFLocation loc : locList) {
            if (loc.getRange().getFrom() != funcAddr) continue;
            return loc;
        }
        return null;
    }

    private static int findFirstUse(Program currentProgram, Register register, long funcAddr, long firstUseAddr) {
        Address entry = currentProgram.getMinAddress().getNewAddress(firstUseAddr);
        InstructionIterator instructions = currentProgram.getListing().getInstructions(entry, true);
        while (instructions.hasNext()) {
            Instruction instruction = instructions.next();
            FlowType flowType = instruction.getFlowType();
            if (flowType.isTerminal()) {
                return 0;
            }
            Object[] resultObjects = instruction.getResultObjects();
            for (int i = 0; i < resultObjects.length; ++i) {
                Register outReg;
                if (!(resultObjects[i] instanceof Register) || !register.equals((Object)(outReg = (Register)resultObjects[i]))) continue;
                long offset = instruction.getMinAddress().getOffset() - funcAddr;
                return (int)offset;
            }
        }
        return 0;
    }

    private void moveIntoFragment(String name, Address start, Address end, String fileName) {
        if (fileName != null) {
            ProgramModule module = null;
            int index = this.rootModule.getIndex(fileName);
            if (index == -1) {
                try {
                    module = this.rootModule.createModule(fileName);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Error while moving fragment " + name + " from " + start + " to " + end), (Throwable)e);
                    return;
                }
            } else {
                Group[] children = this.rootModule.getChildren();
                module = (ProgramModule)children[index];
            }
            if (module != null) {
                try {
                    ProgramFragment frag = null;
                    index = module.getIndex(name);
                    if (index == -1) {
                        frag = module.createFragment(name);
                    } else {
                        Group[] children = module.getChildren();
                        frag = (ProgramFragment)children[index];
                    }
                    frag.move(start, end);
                }
                catch (NotFoundException e) {
                    Msg.error((Object)this, (Object)("Error moving fragment from " + start + " to " + end), (Throwable)e);
                    return;
                }
                catch (DuplicateNameException duplicateNameException) {
                    // empty catch block
                }
            }
        }
    }

    private Variable buildVariable(DWARFVariable dvar) throws InvalidInputException {
        Varnode[] vnarray = this.buildVarnodes(dvar);
        VariableStorage storage = new VariableStorage(this.currentProgram, vnarray);
        int firstUseOffset = 0;
        if (dvar.reg != null && dvar.offset != -1L) {
            firstUseOffset = (int)dvar.offset;
        }
        return new LocalVariableImpl(dvar.dni.getName(), firstUseOffset, dvar.type, storage, this.currentProgram);
    }

    private Variable buildReturnVariable(DWARFVariable dvar) throws InvalidInputException {
        if (dvar == null) {
            return new ReturnParameterImpl(DataType.VOID, this.currentProgram);
        }
        Varnode[] vnarray = this.buildVarnodes(dvar);
        VariableStorage storage = vnarray == null ? VariableStorage.UNASSIGNED_STORAGE : new VariableStorage(this.currentProgram, vnarray);
        return new ReturnParameterImpl(dvar.type, storage, this.currentProgram);
    }

    private Parameter buildParameter(Function function, int i, DWARFVariable dvar, DIEAggregate funcDIEA) throws InvalidInputException {
        Varnode[] vnarray = this.buildVarnodes(dvar);
        VariableStorage storage = vnarray == null ? VariableStorage.UNASSIGNED_STORAGE : new VariableStorage(this.currentProgram, vnarray);
        return new ParameterImpl(dvar.dni.getName(), dvar.type, storage, this.currentProgram);
    }

    private Varnode[] buildVarnodes(DWARFVariable dvar) {
        if (dvar.type == null) {
            return null;
        }
        Varnode[] retarray = null;
        int typesize = dvar.type.getLength();
        if (dvar.reg != null) {
            retarray = new Varnode[1];
            retarray[0] = this.prog.isBigEndian() && dvar.reg.getMinimumByteSize() > typesize ? new Varnode(dvar.reg.getAddress().add((long)(dvar.reg.getMinimumByteSize() - typesize)), typesize) : new Varnode(dvar.reg.getAddress(), typesize);
        } else if (dvar.isStackOffset) {
            retarray = new Varnode[]{new Varnode(this.currentProgram.getAddressFactory().getStackSpace().getAddress(dvar.offset), typesize)};
        }
        return retarray;
    }

    private boolean checkThisParameter(DWARFVariable var, DIEAggregate diea) {
        DataType parentDT;
        if (Function.THIS_PARAM_NAME.equals(var.dni.getName())) {
            return true;
        }
        DIEAggregate parentDIEA = diea.getParent();
        if (parentDIEA != null && parentDIEA.isStructureType() && (parentDT = this.dwarfDTM.getDataType(parentDIEA, null)) != null && parentDT == var.type) {
            if (!var.dni.isAnon()) {
                Msg.error((Object)this, (Object)("WARNING: Renaming " + var.dni.getName() + " to " + Function.THIS_PARAM_NAME));
            }
            var.dni = var.dni.replaceName(Function.THIS_PARAM_NAME, Function.THIS_PARAM_NAME);
            return true;
        }
        return false;
    }

    private Function createFunction(DWARFFunction dfunc, DIEAggregate diea) {
        try {
            DWARFNameInfo dni;
            DWARFSourceInfo sourceInfo;
            SymbolTable symbolTable = this.currentProgram.getSymbolTable();
            symbolTable.createLabel(dfunc.address, dfunc.dni.getName(), dfunc.namespace, SourceType.IMPORTED);
            SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(dfunc.address, dfunc.dni.getName(), dfunc.namespace);
            cmd.applyTo((DomainObject)this.currentProgram);
            this.setExternalEntryPoint(dfunc.isExternal, dfunc.address);
            Function function = this.currentProgram.getListing().getFunctionAt(dfunc.address);
            if (function == null) {
                if (!this.currentProgram.getMemory().getLoadedAndInitializedAddressSet().contains(dfunc.address)) {
                    Msg.warn((Object)this, (Object)("Unable to create function not contained within loaded memory (" + dfunc.address + ") " + dfunc.namespace + "/" + dfunc.dni.getName()));
                    return null;
                }
                function = this.currentProgram.getFunctionManager().createFunction(null, dfunc.address, (AddressSetView)new AddressSet(dfunc.address), SourceType.IMPORTED);
            }
            if ((sourceInfo = DWARFSourceInfo.create(diea)) != null) {
                this.moveIntoFragment(function.getName(), dfunc.address, dfunc.highAddress != null ? dfunc.highAddress : dfunc.address.add(1L), sourceInfo.getFilename());
                if (this.importOptions.isOutputSourceLocationInfo()) {
                    this.appendComment(dfunc.address, 3, sourceInfo.getDescriptionStr(), "\n");
                }
            }
            if (this.importOptions.isOutputDIEInfo()) {
                this.appendComment(dfunc.address, 3, "DWARF DIE: " + diea.getHexOffset(), "\n");
            }
            if ((dni = this.prog.getName(diea)).isNameModified()) {
                this.appendComment(dfunc.address, 3, "Original name: " + dni.getOriginalName(), "\n");
            }
            return function;
        }
        catch (OverlappingFunctionException e) {
            throw new AssertException((Throwable)e);
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Failed to create function " + dfunc.namespace + "/" + dfunc.dni.getName() + ": " + e.getMessage()));
            return null;
        }
    }

    private void setUniqueParameterNames(Function function, List<Parameter> parameters) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        HashSet<String> namesSoFar = new HashSet<String>();
        for (int ordinal = 0; ordinal < parameters.size(); ++ordinal) {
            Parameter parameter = parameters.get(ordinal);
            String baseName = parameter.getName();
            if (ordinal == 0 && Function.THIS_PARAM_NAME.equals(baseName)) continue;
            String uniqueName = DWARFFunctionImporter.getUniqueReplacementParameterName(symbolTable, function, baseName, namesSoFar);
            namesSoFar.add(uniqueName);
            parameter.setName(uniqueName, SourceType.IMPORTED);
        }
    }

    private static String getUniqueReplacementParameterName(SymbolTable symbolTable, Function function, String name, Set<String> namesNotToBeUsed) {
        if (name == null || SymbolUtilities.isDefaultParameterName((String)name)) {
            return name;
        }
        return DWARFFunctionImporter.getUniqueNameIgnoringCurrentParameters(symbolTable, (Namespace)function, name, namesNotToBeUsed);
    }

    private static String getUniqueNameIgnoringCurrentParameters(SymbolTable symbolTable, Namespace namespace, String baseName, Set<String> namesNotToBeUsed) {
        Object name = baseName;
        if (name != null) {
            int cnt = 0;
            List symbols = symbolTable.getSymbols((String)name, namespace);
            while (!symbols.isEmpty()) {
                if (namesNotToBeUsed.contains(name)) continue;
                if (DWARFFunctionImporter.areAllParamaters(symbols)) {
                    return name;
                }
                name = baseName + "_" + ++cnt;
                symbols = symbolTable.getSymbols((String)name, namespace);
            }
        }
        return name;
    }

    private static boolean areAllParamaters(List<Symbol> symbols) {
        for (Symbol symbol : symbols) {
            if (symbol.getSymbolType() == SymbolType.PARAMETER) continue;
            return false;
        }
        return true;
    }

    private void commitPrototype(Function function, Variable returnVariable, List<Parameter> params, PrototypeModel protoModel) throws InvalidInputException, DuplicateNameException {
        CompilerSpec compilerSpec = this.currentProgram.getCompilerSpec();
        if (protoModel == null) {
            Parameter[] paramarray = (Parameter[])params.toArray(Parameter[]::new);
            protoModel = compilerSpec.findBestCallingConvention(paramarray);
        }
        try {
            function.updateFunction(protoModel.getName(), returnVariable, params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.IMPORTED);
        }
        catch (DuplicateNameException e) {
            this.setUniqueParameterNames(function, params);
            function.updateFunction(protoModel.getName(), returnVariable, params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.IMPORTED);
        }
    }

    private void commitLocal(Function func, DWARFVariable dvar) throws InvalidInputException {
        Variable var = this.buildVariable(dvar);
        boolean hasConflict = false;
        for (Variable existingVar : func.getAllVariables()) {
            if (existingVar.getFirstUseOffset() != var.getFirstUseOffset() || !existingVar.getVariableStorage().intersects(var.getVariableStorage()) || existingVar instanceof LocalVariable && Undefined.isUndefined((DataType)existingVar.getDataType())) continue;
            hasConflict = true;
            break;
        }
        if (hasConflict) {
            this.appendComment(func.getEntryPoint().add(dvar.lexicalOffset), 0, "Scope for omitted local variable " + var.toString() + " starts here", "; ");
            return;
        }
        try {
            VariableUtilities.checkVariableConflict((Function)func, null, (VariableStorage)var.getVariableStorage(), (boolean)true);
            func.addLocalVariable(var, SourceType.IMPORTED);
        }
        catch (DuplicateNameException e) {
            int count = 1;
            String baseName = var.getName();
            while (!this.monitor.isCancelled()) {
                try {
                    var.setName(baseName + "_" + Integer.toString(count), SourceType.IMPORTED);
                    func.addLocalVariable(var, SourceType.IMPORTED);
                    break;
                }
                catch (DuplicateNameException e1) {
                    ++count;
                }
            }
        }
    }

    private void processLabel(DIEAggregate diea) {
        Address address;
        if (!this.shouldProcess(diea)) {
            return;
        }
        String name = this.prog.getEntryName(diea);
        if (name != null && diea.hasAttribute(17) && (address = this.toAddr(diea.getLowPC(0L))).getOffset() != 0L) {
            try {
                SymbolTable symbolTable = this.currentProgram.getSymbolTable();
                symbolTable.createLabel(address, name, this.currentProgram.getGlobalNamespace(), SourceType.IMPORTED);
                String locationInfo = DWARFSourceInfo.getDescriptionStr(diea);
                if (locationInfo != null) {
                    this.appendComment(address, 0, locationInfo, "; ");
                }
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Problem creating label at " + address + " with name " + name), (Throwable)e);
            }
        }
    }

    static class DWARFFunction {
        public Address address;
        public Address highAddress;
        public DWARFNameInfo dni;
        public Namespace namespace;
        public DWARFVariable retval;
        public boolean isExternal;
        public long frameBase;
        public List<DWARFVariable> params = new ArrayList<DWARFVariable>();
        public List<DWARFVariable> local = new ArrayList<DWARFVariable>();
        public boolean varArg;
        public boolean localVarErrors;

        public DWARFFunction(DWARFNameInfo dni) {
            this.dni = dni;
        }
    }

    static class DWARFVariable {
        public DWARFNameInfo dni;
        public DataType type;
        public long offset;
        public boolean isStackOffset;
        public long lexicalOffset;
        public Register reg;

        DWARFVariable() {
        }
    }
}

