/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import java.io.IOException;

public class LEB128 {
    private final long offset;
    private final long value;
    private final int byteLength;

    private LEB128(long offset, long value, int byteLength) {
        this.offset = offset;
        this.value = value;
        this.byteLength = byteLength;
    }

    public int asUInt32() throws IOException {
        LEB128.ensureInt32u(this.value);
        return (int)this.value;
    }

    public int asInt32() throws IOException {
        LEB128.ensureInt32s(this.value);
        return (int)this.value;
    }

    public long asLong() {
        return this.value;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.byteLength;
    }

    public String toString() {
        return String.format("LEB128: value: %d, offset: %d, byteLength: %d", this.value, this.offset, this.byteLength);
    }

    public static LEB128 readValue(BinaryReader reader, boolean isSigned) throws IOException {
        long offset = reader.getPointerIndex();
        long value = LEB128.readAsLong(reader, isSigned);
        int size = (int)(reader.getPointerIndex() - offset);
        return new LEB128(offset, value, size);
    }

    public static LEB128 readUnsignedValue(BinaryReader reader) throws IOException {
        return LEB128.readValue(reader, false);
    }

    public static LEB128 readSignedValue(BinaryReader reader) throws IOException {
        return LEB128.readValue(reader, true);
    }

    public static int readAsInt32(BinaryReader reader) throws IOException {
        long tmp = LEB128.readAsLong(reader, true);
        LEB128.ensureInt32s(tmp);
        return (int)tmp;
    }

    public static int readAsUInt32(BinaryReader reader) throws IOException {
        long tmp = LEB128.readAsLong(reader, false);
        LEB128.ensureInt32u(tmp);
        return (int)tmp;
    }

    public static long readAsLong(BinaryReader reader, boolean isSigned) throws IOException {
        int nextByte = 0;
        int shift = 0;
        long value = 0L;
        do {
            nextByte = reader.readNextUnsignedByte();
            if (shift == 70 || !isSigned && shift == 63 && nextByte > 1) {
                throw new IOException("Unsupported LEB128 value, too large to fit in 64bit java long variable");
            }
            value |= (long)(nextByte & 0x7F) << shift;
            shift += 7;
        } while ((nextByte & 0x80) != 0);
        if (isSigned && shift < 64 && (nextByte & 0x40) != 0) {
            value |= -1L << shift;
        }
        return value;
    }

    public static long decode(byte[] bytes, boolean isSigned) throws IOException {
        return LEB128.decode(bytes, 0, isSigned);
    }

    public static long decode(byte[] bytes, int offset, boolean isSigned) throws IOException {
        ByteArrayProvider bap = new ByteArrayProvider(bytes);
        BinaryReader br = new BinaryReader(bap, true);
        br.setPointerIndex(offset);
        return LEB128.readAsLong(br, isSigned);
    }

    private static void ensureInt32u(long value) throws IOException {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new IOException("LEB128 value out of range for java 32 bit unsigned int: " + Long.toUnsignedString(value));
        }
    }

    private static void ensureInt32s(long value) throws IOException {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new IOException("LEB128 value out of range for java 32 bit signed int: " + Long.toString(value));
        }
    }
}

