/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.widgets.table.GTableTextCellEditor;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import ghidra.app.plugin.core.strings.ViewStringsContext;
import ghidra.app.plugin.core.strings.ViewStringsPlugin;
import ghidra.app.plugin.core.strings.ViewStringsTableModel;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import resources.ResourceManager;

public class ViewStringsProvider
extends ComponentProviderAdapter {
    public static final ImageIcon ICON = ResourceManager.loadImage((String)"images/dataW.gif");
    private GhidraThreadedTablePanel<ProgramLocation> threadedTablePanel;
    private GhidraTableFilterPanel<ProgramLocation> filterPanel;
    private GhidraTable table;
    private ViewStringsTableModel stringModel;
    private JComponent mainPanel;
    private Program currentProgram;
    private HelpLocation helpLocation;
    private AtomicReference<ProgramLocation> delayedShowProgramLocation = new AtomicReference();

    ViewStringsProvider(ViewStringsPlugin plugin) {
        super(plugin.getTool(), "Defined Strings", plugin.getName());
        this.mainPanel = this.createWorkPanel();
        this.setIcon(ICON);
        this.helpLocation = new HelpLocation(plugin.getName(), plugin.getName());
        this.addToTool();
    }

    public void componentHidden() {
        this.stringModel.reload(null);
    }

    public void componentShown() {
        this.stringModel.reload(this.currentProgram);
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new ViewStringsContext(this, this.table);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public HelpLocation getHelpLocation() {
        return this.helpLocation;
    }

    void setProgram(Program program) {
        if (program == this.currentProgram) {
            return;
        }
        this.currentProgram = program;
        this.delayedShowProgramLocation.set(null);
        if (this.isVisible()) {
            this.stringModel.reload(program);
        }
    }

    void dispose() {
        this.currentProgram = null;
        this.removeFromTool();
        this.threadedTablePanel.dispose();
        this.filterPanel.dispose();
    }

    private JComponent createWorkPanel() {
        this.stringModel = new ViewStringsTableModel(this.tool);
        this.threadedTablePanel = new GhidraThreadedTablePanel<ProgramLocation>(this.stringModel, 1000);
        this.table = this.threadedTablePanel.getTable();
        this.table.setName("DataTable");
        this.table.setPreferredScrollableViewportSize(new Dimension(350, 150));
        this.table.getSelectionModel().addListSelectionListener(e -> this.notifyContextChanged());
        this.stringModel.addTableModelListener(e -> {
            int unfilteredCount;
            int rowCount;
            this.setSubTitle(rowCount + " items" + (String)((rowCount = this.stringModel.getRowCount()) != (unfilteredCount = this.stringModel.getUnfilteredRowCount()) ? " (of " + unfilteredCount + ")" : ""));
        });
        this.stringModel.addThreadedTableModelListener(new ThreadedTableModelListener(){

            public void loadingStarted() {
            }

            public void loadingFinished(boolean wasCancelled) {
                ProgramLocation delayedProgLoc;
                if (ViewStringsProvider.this.stringModel.getRowCount() != 0 && (delayedProgLoc = (ProgramLocation)ViewStringsProvider.this.delayedShowProgramLocation.getAndSet(null)) != null) {
                    ViewStringsProvider.this.doShowProgramLocation(delayedProgLoc);
                }
            }

            public void loadPending() {
            }
        });
        TableColumn stringRepCol = this.table.getColumnModel().getColumn(ViewStringsTableModel.COLUMNS.STRING_REP_COL.ordinal());
        stringRepCol.setCellEditor((TableCellEditor)((Object)new StringRepCellEditor()));
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        this.table.installNavigation(goToService, goToService.getDefaultNavigatable());
        this.filterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.stringModel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)this.threadedTablePanel), "Center");
        panel.add((Component)((Object)this.filterPanel), "South");
        return panel;
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    ProgramSelection getProgramSelection() {
        return this.table.getProgramSelection();
    }

    void add(Data data) {
        if (this.isVisible()) {
            this.stringModel.addDataInstance(this.currentProgram, data, TaskMonitor.DUMMY);
        }
    }

    void remove(Address addr) {
        if (this.isVisible()) {
            this.stringModel.removeDataInstanceAt(addr);
        }
    }

    void remove(Address start, Address end) {
        if (this.isVisible()) {
            long count = end.subtract(start);
            for (long offset = 0L; offset < count; ++offset) {
                this.stringModel.removeDataInstanceAt(start.add(offset));
            }
        }
    }

    void reload() {
        if (this.isVisible()) {
            this.stringModel.reload();
        }
    }

    public GhidraTable getTable() {
        return this.table;
    }

    public ViewStringsTableModel getModel() {
        return this.stringModel;
    }

    private void doShowProgramLocation(ProgramLocation loc) {
        ProgramLocation realLoc = this.stringModel.findEquivProgramLocation(loc);
        if (realLoc != null) {
            int rowIndex = this.stringModel.getViewIndex(realLoc);
            if (rowIndex >= 0) {
                this.table.selectRow(rowIndex);
                this.table.scrollToSelectedRow();
            } else {
                this.getTool().setStatusInfo("String at " + realLoc.getAddress() + " is filtered out of table view", false);
            }
        }
    }

    public void showProgramLocation(ProgramLocation loc) {
        if (loc == null) {
            return;
        }
        if (!this.stringModel.isBusy()) {
            this.doShowProgramLocation(loc);
        } else {
            this.delayedShowProgramLocation.set(loc);
        }
    }

    public int getSelectedRowCount() {
        return this.table.getSelectedRowCount();
    }

    public Data getSelectedData() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            return null;
        }
        ProgramLocation location = (ProgramLocation)this.stringModel.getRowObject(selectedRow);
        return DataUtilities.getDataAtLocation((ProgramLocation)location);
    }

    public List<Data> getSelectedDataList(Predicate<Data> filter) {
        int[] selectedRows;
        ArrayList<Data> list = new ArrayList<Data>();
        for (int row : selectedRows = this.table.getSelectedRows()) {
            ProgramLocation location = (ProgramLocation)this.stringModel.getRowObject(row);
            Data data = DataUtilities.getDataAtLocation((ProgramLocation)location);
            if (!this.passesFilter(data, filter)) continue;
            list.add(data);
        }
        return list;
    }

    public List<ProgramLocation> getSelectedDataLocationList(Predicate<Data> filter) {
        int[] selectedRows;
        ArrayList<ProgramLocation> result = new ArrayList<ProgramLocation>();
        for (int row : selectedRows = this.table.getSelectedRows()) {
            ProgramLocation location = (ProgramLocation)this.stringModel.getRowObject(row);
            Data data = DataUtilities.getDataAtLocation((ProgramLocation)location);
            if (!this.passesFilter(data, filter)) continue;
            result.add(location);
        }
        return result;
    }

    private boolean passesFilter(Data data, Predicate<Data> filter) {
        if (data == null) {
            return false;
        }
        if (filter == null) {
            return true;
        }
        return filter.test(data);
    }

    public Program getProgram() {
        return this.currentProgram;
    }

    private class StringRepCellEditor
    extends GTableTextCellEditor {
        private JTextField textField;

        StringRepCellEditor() {
            super(new JTextField());
            this.textField = (JTextField)super.getComponent();
        }

        public Object getCellEditorValue() {
            return this.textField.getText();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object value, boolean isSelected, int row, int column) {
            if (value instanceof StringDataInstance) {
                this.textField.setEditable(true);
                StringDataInstance sdi = (StringDataInstance)value;
                if (sdi.isShowTranslation() && sdi.getTranslatedValue() != null) {
                    this.textField.setText(sdi.getTranslatedValue());
                } else {
                    this.textField.setText(sdi.getStringValue());
                }
            } else {
                this.textField.setText("");
                this.textField.setEditable(false);
            }
            return this.textField;
        }
    }
}

