/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.references.EditReferencePanel;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.app.util.AddressInput;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.OffsetReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.jdom.Content;
import org.jdom.Element;
import resources.ResourceManager;

class EditMemoryReferencePanel
extends EditReferencePanel {
    private static ImageIcon PULLDOWN_ICON = ResourceManager.loadImage((String)"images/menu16.gif");
    private static final RefType[] MEM_REF_TYPES = RefTypeFactory.getMemoryRefTypes();
    private static final int MAX_HISTORY_LENGTH = 10;
    private WeakHashMap<Program, List<Address>> addrHistoryMap = new WeakHashMap();
    private ReferencesPlugin plugin;
    private CodeUnit fromCodeUnit;
    private int opIndex;
    private Reference editRef;
    private JLabel addrLabel;
    private AddressInput toAddressField;
    private JButton addrHistoryButton;
    private JCheckBox offsetCheckbox;
    private JTextField offsetField;
    private GhidraComboBox<RefType> refTypes;
    private long defaultOffset;
    private JWindow historyWin;
    private HistoryTableModel model;
    private JTable displayTable;
    private boolean isValidState;

    EditMemoryReferencePanel(ReferencesPlugin plugin) {
        super("MEM");
        this.plugin = plugin;
        this.buildPanel();
    }

    @Override
    public void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditMemoryReferencePanel.this.toAddressField.requestFocus();
            }
        });
    }

    private void buildPanel() {
        this.setLayout((LayoutManager)new PairLayout(10, 10, 160));
        this.offsetCheckbox = new GCheckBox("Offset:");
        this.offsetCheckbox.setHorizontalAlignment(4);
        this.offsetCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EditMemoryReferencePanel.this.enableOffsetField(EditMemoryReferencePanel.this.offsetCheckbox.isSelected());
            }
        });
        this.offsetField = new JTextField();
        this.addrLabel = new GDLabel("Base Address:");
        this.addrLabel.setHorizontalAlignment(4);
        Dimension d = this.addrLabel.getPreferredSize();
        this.addrLabel.setPreferredSize(d);
        this.toAddressField = new AddressInput();
        this.addrHistoryButton = new JButton(PULLDOWN_ICON);
        this.addrHistoryButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (EditMemoryReferencePanel.this.addrHistoryButton.isEnabled()) {
                    EditMemoryReferencePanel.this.toggleAddressHistoryPopup();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
            }
        });
        this.addrHistoryButton.setText(null);
        this.addrHistoryButton.setMargin(new Insets(0, 0, 0, 0));
        this.addrHistoryButton.setFocusable(false);
        this.addrHistoryButton.setToolTipText("Address History");
        this.refTypes = new GhidraComboBox((Object[])MEM_REF_TYPES);
        JPanel addrPanel = new JPanel(new BorderLayout());
        addrPanel.add((Component)this.toAddressField, "Center");
        addrPanel.add((Component)this.addrHistoryButton, "East");
        this.add(this.offsetCheckbox);
        this.add(this.offsetField);
        this.add(this.addrLabel);
        this.add(addrPanel);
        this.add((Component)new GLabel("Ref-Type:", 4));
        this.add((Component)this.refTypes);
        this.enableOffsetField(false);
    }

    private void enableOffsetField(boolean state) {
        this.offsetCheckbox.setSelected(state);
        this.offsetField.setEnabled(state);
        this.offsetField.setBackground(state ? Color.WHITE : this.getBackground());
        if (!state) {
            this.offsetField.setText("0x0");
        } else {
            boolean neg = this.defaultOffset < 0L;
            String offStr = (neg ? "-" : "+") + "0x" + Long.toHexString(neg ? -this.defaultOffset : this.defaultOffset);
            this.offsetField.setText(offStr);
            Address addr = this.toAddressField.getAddress();
            if (addr == null || addr.getOffset() == this.defaultOffset) {
                addr = this.getLastHistoryAddress(this.fromCodeUnit.getProgram());
                if (addr != null) {
                    this.toAddressField.setAddress(addr);
                } else {
                    this.toAddressField.clear();
                }
            }
        }
        this.addrLabel.setText(state ? "Base Address:" : "To Address:");
    }

    private void populateRefTypes(RefType adhocType) {
        this.refTypes.clearModel();
        for (RefType rt : MEM_REF_TYPES) {
            if (adhocType == rt) {
                adhocType = null;
            }
            this.refTypes.addItem((Object)rt);
        }
        if (adhocType != null) {
            this.refTypes.addItem((Object)adhocType);
        }
    }

    @Override
    void initialize(CodeUnit fromCu, Reference editReference) {
        this.isValidState = false;
        this.fromCodeUnit = fromCu;
        this.editRef = editReference;
        this.defaultOffset = 0L;
        Address toAddr = editReference.getToAddress();
        if (!toAddr.isMemoryAddress()) {
            throw new IllegalArgumentException("Expected memory reference");
        }
        if (editReference.isOffsetReference()) {
            this.defaultOffset = ((OffsetReference)editReference).getOffset();
            toAddr = toAddr.subtractWrap(this.defaultOffset);
        }
        this.toAddressField.setAddressFactory(fromCu.getProgram().getAddressFactory(), false, false);
        this.toAddressField.setAddress(toAddr);
        this.enableOffsetField(editReference.isOffsetReference());
        RefType rt = editReference.getReferenceType();
        this.populateRefTypes(rt);
        this.refTypes.setSelectedItem((Object)rt);
        this.addrHistoryButton.setEnabled(this.getAddressHistorySize(fromCu.getProgram()) != 0);
        this.validate();
        this.isValidState = true;
    }

    @Override
    boolean initialize(CodeUnit fromCu, int fromOpIndex, int fromSubIndex) {
        this.isValidState = false;
        this.editRef = null;
        this.fromCodeUnit = fromCu;
        this.defaultOffset = 0L;
        Program p = fromCu.getProgram();
        this.addrHistoryButton.setEnabled(this.getAddressHistorySize(p) != 0);
        this.toAddressField.setAddressFactory(p.getAddressFactory(), false, false);
        Address cuAddr = fromCu.getMinAddress();
        RefType rt = RefTypeFactory.getDefaultMemoryRefType((CodeUnit)fromCu, (int)fromOpIndex, null, (boolean)false);
        this.populateRefTypes(rt);
        this.refTypes.setSelectedItem((Object)rt);
        if (fromOpIndex < 0) {
            Program program = this.plugin.getCurrentProgram();
            ProgramLocation location = this.plugin.getCurrentLocation();
            Address toAddr = null;
            if (p == program && location != null) {
                toAddr = this.getSuggestedLocationAddress(program, location);
            }
            if (toAddr == null || toAddr.equals((Object)cuAddr)) {
                this.toAddressField.clear();
            } else {
                this.toAddressField.setAddress(toAddr);
            }
            this.enableOffsetField(false);
            this.toAddressField.select();
            return this.setOpIndex(fromOpIndex);
        }
        Address toAddr = null;
        boolean enableOffset = false;
        if (fromCu instanceof Data) {
            Object val = ((Data)fromCu).getValue();
            if (val instanceof Address) {
                toAddr = (Address)val;
            } else if (val instanceof Scalar) {
                Scalar s = (Scalar)val;
                this.defaultOffset = s.getSignedValue();
                toAddr = this.getDefaultAddress(p.getAddressFactory(), cuAddr, s.getUnsignedValue());
            }
        } else if (fromOpIndex >= 0) {
            Reference r;
            List objs;
            Scalar s = fromCu.getScalar(fromOpIndex);
            if (s == null && fromSubIndex >= 0 && (objs = ((Instruction)fromCu).getDefaultOperandRepresentationList(fromOpIndex)) != null) {
                if (objs.size() > fromSubIndex) {
                    Object obj = objs.get(fromSubIndex);
                    if (obj instanceof Scalar) {
                        s = (Scalar)objs.get(fromSubIndex);
                    } else if (obj instanceof Address) {
                        toAddr = (Address)obj;
                    }
                }
                if (s == null && toAddr == null) {
                    for (Object obj : objs) {
                        if (!(obj instanceof Scalar)) continue;
                        s = (Scalar)obj;
                        break;
                    }
                }
            }
            if (s != null) {
                this.defaultOffset = s.getSignedValue();
                toAddr = this.getDefaultAddress(p.getAddressFactory(), cuAddr, s.getUnsignedValue());
            } else if (toAddr == null) {
                toAddr = fromCu.getAddress(fromOpIndex);
            }
            if (toAddr != null && (r = p.getReferenceManager().getReference(fromCu.getMinAddress(), toAddr, fromOpIndex)) != null) {
                toAddr = null;
                if (r.isOffsetReference()) {
                    OffsetReference offRef = (OffsetReference)r;
                    enableOffset = true;
                    toAddr = offRef.getBaseAddress();
                }
            }
        }
        if (toAddr != null && !toAddr.equals((Object)cuAddr)) {
            this.toAddressField.setAddress(toAddr);
            this.toAddressField.select();
        } else {
            this.toAddressField.clear();
        }
        if (toAddr != null) {
            rt = RefTypeFactory.getDefaultMemoryRefType((CodeUnit)fromCu, (int)fromOpIndex, (Address)toAddr, (boolean)false);
            this.populateRefTypes(rt);
            this.refTypes.setSelectedItem((Object)rt);
        }
        this.enableOffsetField(enableOffset);
        return this.setOpIndex(fromOpIndex);
    }

    private Address getSuggestedLocationAddress(Program program, ProgramLocation loc) {
        Data d;
        CodeUnit cu;
        Address cuAddr = loc.getAddress();
        if (loc instanceof OperandFieldLocation && (cu = program.getListing().getCodeUnitAt(cuAddr)) instanceof Data && (d = (Data)cu).isDefined()) {
            Object obj = d.getValue();
            if (obj instanceof Address) {
                return (Address)obj;
            }
            if (obj instanceof Scalar) {
                Scalar s = (Scalar)obj;
                return this.getDefaultAddress(program.getAddressFactory(), cuAddr, s.getUnsignedValue());
            }
        }
        return cuAddr;
    }

    private Address getDefaultAddress(AddressFactory addrFactory, Address fromAddr, long offset) {
        AddressSpace contextAddrSpace = fromAddr.getAddressSpace();
        long addrOffset = offset * (long)contextAddrSpace.getAddressableUnitSize();
        try {
            return fromAddr.getNewAddress(addrOffset);
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            AddressSpace defaultSpace = addrFactory.getDefaultAddressSpace();
            addrOffset = offset * (long)defaultSpace.getAddressableUnitSize();
            try {
                return fromAddr.getNewAddress(addrOffset);
            }
            catch (AddressOutOfBoundsException addressOutOfBoundsException2) {
                return null;
            }
        }
    }

    @Override
    boolean setOpIndex(int opIndex) {
        if (this.editRef != null) {
            throw new IllegalStateException("setOpIndex only permitted for ADD case");
        }
        this.opIndex = opIndex;
        this.isValidState = true;
        return true;
    }

    @Override
    boolean applyReference() {
        Address toAddr;
        if (!this.isValidState) {
            throw new IllegalStateException();
        }
        boolean isOffsetRef = this.offsetCheckbox.isSelected();
        long offset = 0L;
        if (isOffsetRef) {
            String str = this.offsetField.getText();
            try {
                offset = this.parseLongInput(str);
            }
            catch (NumberFormatException e) {
                this.showInputErr("Valid 'Offset' is required!\nBe sure to prefix hex data with '0x'.");
                return false;
            }
        }
        if ((toAddr = this.toAddressField.getAddress()) == null) {
            AddressSpace space = this.toAddressField.getAddressSpace();
            this.showInputErr("Invalid memory address offset specified; " + space.getName() + " offset must be in range: " + space.getMinAddress().toString(false) + " to " + space.getMaxAddress().toString(false));
            return false;
        }
        if (!toAddr.isMemoryAddress()) {
            this.showInputErr("Invalid memory address specified");
            return false;
        }
        this.addHistoryAddress(this.fromCodeUnit.getProgram(), toAddr);
        toAddr = this.plugin.checkMemoryAddress(this, this.fromCodeUnit.getProgram(), toAddr, offset);
        if (toAddr == null) {
            return false;
        }
        toAddr = toAddr.addWrap(offset);
        RefType refType = (RefType)this.refTypes.getSelectedItem();
        if (refType == null) {
            this.showInputErr("A 'Ref-Type' must be selected.");
            return false;
        }
        if (this.editRef != null) {
            return this.plugin.updateReference(this.editRef, this.fromCodeUnit, toAddr, isOffsetRef, offset, refType);
        }
        return this.plugin.addReference(this.fromCodeUnit, this.opIndex, toAddr, isOffsetRef, offset, refType);
    }

    private int getAddressHistorySize(Program program) {
        List<Address> list = this.addrHistoryMap.get(program);
        return list != null ? list.size() : 0;
    }

    private Address getLastHistoryAddress(Program program) {
        List<Address> list = this.addrHistoryMap.get(program);
        return list != null ? list.get(0) : null;
    }

    private void addHistoryAddress(Program program, Address addr) {
        List<Address> list = this.addrHistoryMap.get(program);
        if (list == null) {
            list = new ArrayList<Address>();
            this.addrHistoryMap.put(program, list);
        }
        list.remove(addr);
        list.add(0, addr);
        if (list.size() > 10) {
            list.remove(10);
        }
    }

    private void hideAddressHistoryPopup() {
        if (this.historyWin != null) {
            this.historyWin.setVisible(false);
            this.historyWin.dispose();
            this.historyWin = null;
            this.model = null;
            this.displayTable = null;
        }
    }

    private void toggleAddressHistoryPopup() {
        if (this.historyWin != null) {
            this.hideAddressHistoryPopup();
            return;
        }
        List<Address> list = this.addrHistoryMap.get(this.fromCodeUnit.getProgram());
        Address[] addrs = new Address[list.size()];
        list.toArray(addrs);
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        this.model = new HistoryTableModel(this.fromCodeUnit.getProgram());
        this.displayTable = new JTable(this.model);
        this.displayTable.setTableHeader(null);
        this.displayTable.setBorder(new LineBorder(Color.BLACK));
        this.displayTable.setSelectionMode(0);
        this.displayTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = EditMemoryReferencePanel.this.displayTable.getSelectedRow();
                Address addr = EditMemoryReferencePanel.this.model.getAddress(row);
                EditMemoryReferencePanel.this.toAddressField.setAddress(addr);
                EditMemoryReferencePanel.this.toggleAddressHistoryPopup();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.displayTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.getSource() == EditMemoryReferencePanel.this.displayTable) {
                    Point location = e.getPoint();
                    Rectangle r = new Rectangle();
                    EditMemoryReferencePanel.this.displayTable.computeVisibleRect(r);
                    if (r.contains(location)) {
                        EditMemoryReferencePanel.this.updateTableSelectionForEvent(e);
                    }
                }
            }
        });
        panel.add((Component)this.displayTable, "Center");
        int w = this.toAddressField.getWidth() + this.addrHistoryButton.getWidth();
        Dimension d = this.displayTable.getPreferredSize();
        this.displayTable.setPreferredSize(new Dimension(w, d.height));
        Window dlgWin = this.findMyWindow();
        this.historyWin = new JWindow(dlgWin);
        this.historyWin.getContentPane().setLayout(new BorderLayout(0, 0));
        this.historyWin.getContentPane().add((Component)panel, "Center");
        this.historyWin.pack();
        Point p = new Point();
        SwingUtilities.convertPointToScreen(p, this.toAddressField);
        p.y += this.toAddressField.getHeight();
        this.historyWin.setLocation(p);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new PropertyChangeListener(){
            boolean hasFocus = false;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object focusOwner = evt.getNewValue();
                if (focusOwner == EditMemoryReferencePanel.this.displayTable || focusOwner == EditMemoryReferencePanel.this.historyWin) {
                    this.hasFocus = true;
                } else if (this.hasFocus) {
                    this.hasFocus = false;
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this);
                    EditMemoryReferencePanel.this.hideAddressHistoryPopup();
                }
            }
        });
        this.historyWin.setVisible(true);
        dlgWin.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                EditMemoryReferencePanel.this.hideAddressHistoryPopup();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                EditMemoryReferencePanel.this.hideAddressHistoryPopup();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                EditMemoryReferencePanel.this.hideAddressHistoryPopup();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
    }

    private void updateTableSelectionForEvent(MouseEvent anEvent) {
        Point location = anEvent.getPoint();
        if (this.displayTable == null) {
            return;
        }
        int index = this.displayTable.rowAtPoint(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.model.getRowCount() - 1;
        }
        if (this.displayTable.getSelectedRow() != index) {
            this.displayTable.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    private Window findMyWindow() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof Window); c = c.getParent()) {
        }
        return (Window)c;
    }

    @Override
    void cleanup() {
        this.isValidState = false;
        this.fromCodeUnit = null;
        this.editRef = null;
    }

    @Override
    boolean isValidContext() {
        return this.isValidState;
    }

    void readXmlDataState(Element element) {
        List programElements = element.getChildren("ADDR_HISTORY");
        for (Element programElement : programElements) {
            String programName = programElement.getAttributeValue("PROGRAM");
            Program program = this.getOpenProgram(programName);
            if (program == null) continue;
            AddressFactory addrFactory = program.getAddressFactory();
            List addrElements = programElement.getChildren("ADDRESS");
            for (Element addrElement : addrElements) {
                Address addr;
                String addrStr = addrElement.getAttributeValue("VALUE");
                if (addrStr == null || (addr = addrFactory.getAddress(addrStr)) == null) continue;
                this.addHistoryAddress(program, addr);
            }
        }
    }

    void writeXmlDataState(Element element) {
        for (Program program : this.addrHistoryMap.keySet()) {
            Element programElement = new Element("ADDR_HISTORY");
            programElement.setAttribute("PROGRAM", program.getDomainFile().toString());
            List<Address> addressList = this.addrHistoryMap.get(program);
            for (Address address : addressList) {
                Element addrElement = new Element("ADDRESS");
                addrElement.setAttribute("VALUE", address.toString());
                programElement.addContent((Content)addrElement);
            }
            element.addContent((Content)programElement);
        }
    }

    private Program getOpenProgram(String name) {
        Program[] openPrograms;
        for (Program program : openPrograms = this.plugin.getProgramManager().getAllOpenPrograms()) {
            if (!name.equals(program.getDomainFile().toString())) continue;
            return program;
        }
        return null;
    }

    private class HistoryTableModel
    extends AbstractTableModel {
        private SymbolTable symTable;
        private List<Address> addrList;

        HistoryTableModel(Program program) {
            this.symTable = program.getSymbolTable();
            this.addrList = EditMemoryReferencePanel.this.addrHistoryMap.get(EditMemoryReferencePanel.this.fromCodeUnit.getProgram());
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.addrList != null ? this.addrList.size() : 0;
        }

        public Address getAddress(int rowIndex) {
            return this.addrList != null ? this.addrList.get(rowIndex) : null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.addrList == null) {
                return null;
            }
            Address addr = this.addrList.get(rowIndex);
            if (columnIndex == 0) {
                return addr.toString();
            }
            Symbol s = this.symTable.getPrimarySymbol(addr);
            if (s != null) {
                return s.getName();
            }
            return null;
        }
    }
}

