/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import docking.widgets.PopupWindow;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.marker.AreaMarkerSet;
import ghidra.app.plugin.core.marker.MarkerMarginProvider;
import ghidra.app.plugin.core.marker.MarkerOverviewProvider;
import ghidra.app.plugin.core.marker.MarkerSetImpl;
import ghidra.app.plugin.core.marker.NavigationPanel;
import ghidra.app.plugin.core.marker.PointMarkerSet;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.viewer.listingpanel.MarkerClickedListener;
import ghidra.app.util.viewer.listingpanel.OverviewProvider;
import ghidra.app.util.viewer.listingpanel.VerticalPixelAddressMap;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.FixedSizeHashMap;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.map.LazyMap;

public class MarkerManager
implements MarkerService {
    static final String POPUP_WINDOW_NAME = "Marker ToolTip Window";
    static final int MAX_TOOLTIP_LINES = 10;
    private Map<String, Map<Program, MarkerSetImpl>> programMarkersByGroup = LazyMap.lazyMap(new HashMap(), () -> new HashMap());
    private MarkerSetCache markerSetCache = new MarkerSetCache();
    private SwingUpdateManager updater;
    private GoToService goToService;
    private MarkerMarginProvider primaryMarginProvider;
    private WeakSet<MarkerMarginProvider> marginProviders = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private MarkerOverviewProvider primaryOverviewProvider;
    private WeakSet<MarkerOverviewProvider> overviewProviders = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private final PluginTool tool;
    private final String owner;
    private PopupWindow popupWindow;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private MarkerClickedListener markerClickedListener = null;

    public MarkerManager(Plugin plugin) {
        this(plugin.getName(), plugin.getTool());
    }

    public MarkerManager(String owner, PluginTool tool) {
        this.tool = tool;
        this.owner = owner;
        this.updater = new SwingUpdateManager(100, 60000, () -> {
            this.marginProviders.forEach(provider -> provider.repaintPanel());
            this.overviewProviders.forEach(provider -> provider.repaintPanel());
            this.notifyListeners();
        });
        this.primaryMarginProvider = this.createMarginProvider();
        this.primaryOverviewProvider = this.createOverviewProvider();
    }

    private void programClosed(Program program) {
        Map<String, Map<Program, MarkerSetImpl>> values = this.programMarkersByGroup;
        Collection<Map<Program, MarkerSetImpl>> valueValues = values.values();
        for (Map<Program, MarkerSetImpl> map : valueValues) {
            map.remove(program);
        }
    }

    @Override
    public MarkerSet createAreaMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color) {
        AreaMarkerSet mgr = new AreaMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, program);
        this.insertMarkers(mgr, program);
        return mgr;
    }

    @Override
    public MarkerSet createAreaMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color, boolean isPreferred) {
        AreaMarkerSet mgr = new AreaMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, isPreferred, program);
        this.insertMarkers(mgr, program);
        return mgr;
    }

    @Override
    public MarkerSet createPointMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color, Icon icon) {
        PointMarkerSet markers = new PointMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, icon, program);
        this.insertMarkers(markers, program);
        return markers;
    }

    @Override
    public MarkerSet createPointMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color, Icon icon, boolean isPreferred) {
        PointMarkerSet markers = new PointMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, icon, isPreferred, program);
        this.insertMarkers(markers, program);
        return markers;
    }

    @Override
    public MarkerSet getMarkerSet(String name, Program program) {
        if (name == null) {
            throw new NullPointerException("Marker set name cannot be null.");
        }
        if (program == null) {
            throw new NullPointerException("Program cannot be null.");
        }
        return this.markerSetCache.get(program).getByName(name);
    }

    @Override
    public void removeMarker(MarkerSet markers, Program program) {
        if (program == null) {
            throw new NullPointerException("Cannot remove marker set for a null program.");
        }
        this.doRemoveMarker(markers, program);
        this.refreshActionList(program);
        this.markersChanged(program);
    }

    private void refreshActionList(Program program) {
        this.overviewProviders.forEach(provider -> provider.refreshActionList(program));
    }

    private void doRemoveMarker(MarkerSet markers, Program program) {
        if (markers == null || program == null) {
            return;
        }
        MarkerSetCacheEntry entry = this.markerSetCache.get(program);
        if (entry == null) {
            return;
        }
        entry.removeSet(markers);
        Collection<Map<Program, MarkerSetImpl>> values = this.programMarkersByGroup.values();
        for (Map<Program, MarkerSetImpl> map : values) {
            MarkerSetImpl markerSetImpl = map.get(program);
            if (markerSetImpl != markers) continue;
            map.clear();
            break;
        }
    }

    public MarkerMarginProvider getMarginProvider() {
        return this.primaryMarginProvider;
    }

    @Override
    public MarkerMarginProvider createMarginProvider() {
        MarkerMarginProvider provider = new MarkerMarginProvider(this);
        this.marginProviders.add((Object)provider);
        return provider;
    }

    public OverviewProvider getOverviewProvider() {
        return this.primaryOverviewProvider;
    }

    @Override
    public MarkerOverviewProvider createOverviewProvider() {
        MarkerOverviewProvider provider = new MarkerOverviewProvider(this.owner, this.tool, this);
        this.overviewProviders.add((Object)provider);
        return provider;
    }

    public void dispose() {
        this.updater.dispose();
        this.markerSetCache.clear();
        this.overviewProviders.forEach(provider -> provider.dispose());
    }

    void navigateTo(Navigatable navigatable, Program program, int x, int y, int viewHeight, AddressIndexMap addrMap) {
        MarkerSetCacheEntry entry = this.markerSetCache.get(program);
        ProgramLocation loc = entry.getProgramLocation(y, viewHeight, addrMap, x);
        this.getGoToService();
        if (loc != null && this.goToService != null) {
            this.goToService.goTo(navigatable, loc, loc.getProgram());
        }
    }

    void paintNavigation(Program program, Graphics g, NavigationPanel panel, AddressIndexMap addrMap) {
        if (addrMap == null) {
            return;
        }
        MarkerSetCacheEntry entry = this.markerSetCache.get(program);
        if (entry == null) {
            return;
        }
        entry.paintNavigation(g, panel.getViewHeight(), panel.getWidth(), addrMap);
    }

    void paintMarkers(Program program, Graphics g, VerticalPixelAddressMap pixmap, AddressIndexMap addrMap) {
        MarkerSetCacheEntry entry = this.markerSetCache.get(program);
        if (entry == null) {
            return;
        }
        entry.paintMarkers(g, pixmap, addrMap);
    }

    void showToolTipPopup(MouseEvent event, String tip) {
        if (tip == null) {
            return;
        }
        JToolTip toolTip = new JToolTip();
        toolTip.setTipText("<html><font size=\"4\">" + tip);
        if (this.popupWindow != null) {
            this.popupWindow.dispose();
        }
        this.popupWindow = new PopupWindow(event.getComponent(), (JComponent)toolTip);
        this.popupWindow.setWindowName(POPUP_WINDOW_NAME);
        this.popupWindow.showPopup(event);
    }

    String generateToolTip(MouseEvent event) {
        return this.primaryMarginProvider.generateToolTip(event);
    }

    List<String> getMarkerTooltipLines(Program program, int y, int x, Address minAddr, Address maxAddr) {
        MarkerSetCacheEntry entry = this.markerSetCache.get(program);
        return entry.getTooltipLines(y, x, minAddr, maxAddr);
    }

    static String getMarkerToolTip(MarkerSetImpl marker, Address a, int x, int y) {
        String tip = marker.getTooltip(a, x, y);
        if (tip == null) {
            tip = marker.getName();
        }
        return tip;
    }

    List<MarkerSetImpl> copyMarkerSets(Program program) {
        MarkerSetCacheEntry entry = this.markerSetCache.get(program);
        return entry == null ? Collections.emptyList() : entry.copyList();
    }

    void markersChanged(Program p) {
        MarkerSetCacheEntry entry = this.markerSetCache.get(p);
        if (entry != null) {
            entry.colorCache.clear();
        }
        this.updater.update();
    }

    private void insertMarkers(MarkerSetImpl markers, Program program) {
        if (program == null) {
            throw new AssertException("Program cannot be null");
        }
        MarkerSetCacheEntry entry = this.markerSetCache.get(program);
        if (entry == null) {
            return;
        }
        entry.insertSet(markers);
        this.refreshActionList(program);
    }

    void updateMarkerSets(Program program, boolean updateMarkers, boolean updateNavigation, boolean updateNow) {
        MarkerSetCacheEntry entry = this.markerSetCache.get(program);
        if (entry == null) {
            return;
        }
        entry.updateView(updateMarkers, updateNavigation);
        if (updateNow) {
            this.updater.updateNow();
        } else {
            this.updater.update();
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(null);
        }
    }

    MarkerSetImpl getMarkerSet(Program program, Address addr) {
        MarkerSetCacheEntry entry = this.markerSetCache.get(program);
        return entry.getMarkerSetAt(addr);
    }

    @Override
    public void setMarkerForGroup(String groupName, MarkerSet ms, Program program) {
        if (!(ms instanceof MarkerSetImpl)) {
            throw new IllegalArgumentException("Invalid marker set provided");
        }
        MarkerSetImpl markers = (MarkerSetImpl)ms;
        Map<Program, MarkerSetImpl> markersByProgram = this.programMarkersByGroup.get(groupName);
        MarkerSetImpl previousMarkers = markersByProgram.get(program);
        if (markers == previousMarkers) {
            return;
        }
        this.removeMarker(previousMarkers, program);
        markersByProgram.put(program, markers);
        this.insertMarkers(markers, program);
    }

    @Override
    public void removeMarkerForGroup(String groupName, MarkerSet markers, Program program) {
        Map<Program, MarkerSetImpl> markersByProgram = this.programMarkersByGroup.get(groupName);
        MarkerSet previousMarkers = markersByProgram.get(program);
        if (markers == previousMarkers) {
            markersByProgram.remove(program);
            this.removeMarker(previousMarkers, program);
        }
    }

    @Override
    public Color getBackgroundColor(Program program, Address address) {
        return this.getBackgroundColor(program, this.markerSetCache.get(program), address);
    }

    private Color getBackgroundColor(Program program, MarkerSetCacheEntry entry, Address address) {
        return entry.getBackgroundColor(address);
    }

    public GoToService getGoToService() {
        if (this.goToService == null) {
            this.goToService = (GoToService)this.tool.getService(GoToService.class);
        }
        return this.goToService;
    }

    public void setGoToService(GoToService goToService) {
        this.goToService = goToService;
    }

    @Override
    public void setMarkerClickedListener(MarkerClickedListener listener) {
        if (listener != null && this.markerClickedListener != null) {
            throw new IllegalStateException("Attempted to assign more than one MarkerClickedListener!");
        }
        this.markerClickedListener = listener;
    }

    public MarkerClickedListener getMarkerClickedListener() {
        return this.markerClickedListener;
    }

    private class MarkerSetCache {
        Map<Program, MarkerSetCacheEntry> map = new HashMap<Program, MarkerSetCacheEntry>();

        private MarkerSetCache() {
        }

        MarkerSetCacheEntry get(Program program) {
            if (program == null || program.isClosed()) {
                return null;
            }
            MarkerSetCacheEntry entry = this.map.computeIfAbsent(program, this::newEntry);
            if (program.isClosed()) {
                this.map.remove(program);
                return null;
            }
            return entry;
        }

        public void clear() {
            this.map.clear();
        }

        private MarkerSetCacheEntry newEntry(Program program) {
            return new MarkerSetCacheEntry(this, program);
        }

        private void programClosed(Program program) {
            this.map.remove(program);
            MarkerManager.this.programClosed(program);
        }
    }

    private static class MarkerSetCacheEntry {
        private final List<MarkerSetImpl> markerSets = new ArrayList<MarkerSetImpl>();
        private final AddressColorCache colorCache = new AddressColorCache();
        private final MarkerSetCache cache;
        private final Program program;
        private final DomainObjectClosedListener closeListener = this::programClosed;

        public MarkerSetCacheEntry(MarkerSetCache cache, Program program) {
            this.cache = cache;
            this.program = program;
            program.addCloseListener(this.closeListener);
        }

        private void programClosed() {
            this.program.removeCloseListener(this.closeListener);
            this.cache.programClosed(this.program);
        }

        MarkerSetImpl getByName(String name) {
            for (MarkerSetImpl set : this.markerSets) {
                if (!name.equals(set.getName())) continue;
                return set;
            }
            return null;
        }

        void removeSet(MarkerSet set) {
            this.markerSets.remove(set);
        }

        void insertSet(MarkerSetImpl set) {
            int index = Collections.binarySearch(this.markerSets, set);
            if (index < 0) {
                index = -(index + 1);
            }
            this.markerSets.add(index, set);
        }

        ProgramLocation getProgramLocation(int y, int viewHeight, AddressIndexMap addrMap, int x) {
            for (MarkerSetImpl markers : IterableUtils.reversedIterable(this.markerSets)) {
                ProgramLocation loc;
                if (!markers.isActive() || (loc = markers.getProgramLocation(y, viewHeight, addrMap, x)) == null) continue;
                return loc;
            }
            return null;
        }

        void paintNavigation(Graphics g, int viewHeight, int width, AddressIndexMap addrMap) {
            for (MarkerSetImpl markers : this.markerSets) {
                if (!markers.active) continue;
                markers.paintNavigation(g, viewHeight, width, addrMap);
            }
        }

        void paintMarkers(Graphics g, VerticalPixelAddressMap pixmap, AddressIndexMap addrMap) {
            int count = 0;
            for (MarkerSetImpl markers : this.markerSets) {
                ++count;
                if (!markers.active) continue;
                markers.paintMarkers(g, count++, pixmap, addrMap);
            }
        }

        void updateView(boolean updateMakers, boolean updateNavigation) {
            for (MarkerSetImpl markers : this.markerSets) {
                markers.updateView(updateMakers, updateNavigation);
            }
        }

        MarkerSetImpl getMarkerSetAt(Address address) {
            for (MarkerSetImpl markers : IterableUtils.reversedIterable(this.markerSets)) {
                if (!markers.displayInMarkerBar() || !markers.contains(address)) continue;
                return markers;
            }
            return null;
        }

        Color getBackgroundColor(Address address) {
            if (this.colorCache.containsKey(address)) {
                return (Color)this.colorCache.get(address);
            }
            for (MarkerSetImpl markers : IterableUtils.reversedIterable(this.markerSets)) {
                if (!markers.isActive() || !markers.isColoringBackground() || !markers.contains(address)) continue;
                Color color = markers.getMarkerColor();
                this.colorCache.put(address, color);
                return color;
            }
            return null;
        }

        List<String> getTooltipLines(int y, int x, Address minAddr, Address maxAddr) {
            ArrayList<String> lines = new ArrayList<String>();
            block0: for (MarkerSetImpl markers : IterableUtils.reversedIterable(this.markerSets)) {
                if (!markers.displayInMarkerBar()) continue;
                AddressSet set = markers.getAddressSet();
                AddressSet intersection = set.intersectRange(minAddr, maxAddr);
                for (Address a : intersection.getAddresses(true)) {
                    lines.add(MarkerManager.getMarkerToolTip(markers, a, x, y));
                    if (markers instanceof AreaMarkerSet) continue block0;
                    if (lines.size() < 10) continue;
                    lines.add("...");
                    return lines;
                }
            }
            return lines;
        }

        List<MarkerSetImpl> copyList() {
            return new ArrayList<MarkerSetImpl>(this.markerSets);
        }
    }

    private static class AddressColorCache
    extends FixedSizeHashMap<Address, Color> {
        private static final int MAX_SIZE = 50;

        AddressColorCache() {
            super(50, 50);
        }
    }
}

