/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.gotoquery;

import ghidra.app.services.QueryData;
import ghidra.app.util.query.ProgramLocationPreviewTableModel;
import ghidra.framework.model.DomainObjectException;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ProgramLocation;
import ghidra.util.UserSearchUtils;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoToQueryResultsTableModel
extends ProgramLocationPreviewTableModel {
    private QueryData queryData;
    private int maxSearchHits;
    private List<ProgramLocation> locations;
    private SymbolTable symbolTable;

    public GoToQueryResultsTableModel(Program prog, QueryData queryData, ServiceProvider serviceProvider, int maxSearchHits, TaskMonitor monitor) {
        super("Goto", serviceProvider, prog, monitor);
        this.symbolTable = prog.getSymbolTable();
        this.queryData = queryData;
        this.maxSearchHits = maxSearchHits;
    }

    public GoToQueryResultsTableModel(Program prog, ServiceProvider serviceProvider, List<ProgramLocation> locations, TaskMonitor monitor) {
        super("Goto", serviceProvider, prog, monitor);
        this.locations = locations;
    }

    @Override
    public Address getAddress(int row) {
        return ((ProgramLocation)this.filteredData.get(row)).getAddress();
    }

    protected void doLoad(Accumulator<ProgramLocation> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.locations != null) {
            accumulator.addAll(this.locations);
            return;
        }
        try {
            this.doLoadMaybeWithExceptions(accumulator, monitor);
        }
        catch (DomainObjectException doe) {
            Throwable cause = doe.getCause();
            if (!(cause instanceof ClosedException)) {
                throw doe;
            }
            this.cancelAllUpdates();
        }
    }

    private void doLoadMaybeWithExceptions(Accumulator<ProgramLocation> accumulator, TaskMonitor monitor) throws CancelledException {
        this.searchDefinedSymbols(accumulator, monitor);
        this.searchDynamicSymbols(accumulator, monitor);
    }

    private void searchDynamicSymbols(Accumulator<ProgramLocation> accumulator, TaskMonitor monitor) throws CancelledException {
        if (!this.queryData.isIncludeDynamicLables()) {
            return;
        }
        String queryString = this.queryData.getQueryString();
        if (!this.isWildQuery(queryString)) {
            this.parseDynamic(accumulator, queryString);
            return;
        }
        boolean caseSensitive = this.queryData.isCaseSensitive();
        Pattern pattern = UserSearchUtils.createSearchPattern((String)queryString, (boolean)caseSensitive);
        ReferenceManager refMgr = this.getProgram().getReferenceManager();
        AddressSet addressSet = this.getProgram().getAddressFactory().getAddressSet();
        AddressIterator addrIt = refMgr.getReferenceDestinationIterator((AddressSetView)addressSet, true);
        while (addrIt.hasNext() && accumulator.size() < this.maxSearchHits) {
            ProgramLocation programLocation;
            Matcher matcher;
            monitor.checkCanceled();
            Address addr = addrIt.next();
            Symbol s = this.symbolTable.getPrimarySymbol(addr);
            if (!s.isDynamic() || !(matcher = pattern.matcher(s.getName())).matches() || (programLocation = s.getProgramLocation()) == null) continue;
            accumulator.add((Object)programLocation);
        }
    }

    private boolean isWildQuery(String queryString) {
        return queryString.indexOf(42) > -1 || queryString.indexOf(63) > -1;
    }

    private void parseDynamic(Accumulator<ProgramLocation> accumulator, String queryString) {
        Address address = SymbolUtilities.parseDynamicName((AddressFactory)this.getProgram().getAddressFactory(), (String)queryString);
        if (address == null) {
            return;
        }
        Symbol s = this.symbolTable.getPrimarySymbol(address);
        if (s == null) {
            return;
        }
        if (s.getName().equalsIgnoreCase(queryString)) {
            accumulator.add((Object)s.getProgramLocation());
        }
    }

    private boolean searchDefinedSymbols(Accumulator<ProgramLocation> accumulator, TaskMonitor monitor) throws CancelledException {
        SymbolIterator it = this.symbolTable.getSymbolIterator(this.queryData.getQueryString(), this.queryData.isCaseSensitive());
        while (it.hasNext() && accumulator.size() < this.maxSearchHits) {
            monitor.checkCanceled();
            Symbol s = it.next();
            ProgramLocation programLocation = s.getProgramLocation();
            if (programLocation == null) continue;
            accumulator.add((Object)programLocation);
        }
        return false;
    }
}

