/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datapreview;

import ghidra.app.plugin.core.datapreview.Preview;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;

class DataTypePreview
implements Preview {
    private static final int MAX_PREVIEW_LENGTH = 150;
    protected DataType dt;

    DataTypePreview(DataType dt) {
        this.dt = dt;
    }

    @Override
    public String getName() {
        return this.dt.getName();
    }

    @Override
    public String getPreview(Memory memory, Address addr) {
        try {
            DumbMemBufferImpl mb = new DumbMemBufferImpl(memory, addr);
            DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)this.dt, (MemBuffer)mb, (int)150);
            if (dti == null) {
                return "";
            }
            int length = Math.min(dti.getLength(), 150);
            return this.dt.getRepresentation((MemBuffer)mb, this.dt.getDefaultSettings(), length);
        }
        catch (Exception e) {
            return "ERROR: unable to create preview";
        }
    }

    @Override
    public DataType getDataType() {
        return this.dt;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Preview p) {
        if (p instanceof DataTypePreview) {
            DataTypePreview dtp = (DataTypePreview)p;
            return this.getName().compareToIgnoreCase(dtp.getName());
        }
        return this.toString().compareToIgnoreCase(p.toString());
    }
}

