/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.IOException;
import javax.swing.tree.TreePath;

public class SaveArchiveAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public SaveArchiveAction(DataTypeManagerPlugin plugin) {
        super("Save", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Save Archive"}, null, "File"));
        this.setEnabled(true);
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths(context);
        if (selectionPaths.length == 0) {
            return false;
        }
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (node instanceof FileArchiveNode || node instanceof ProjectArchiveNode) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths(context);
        return this.shouldBeEnabled(selectionPaths);
    }

    private TreePath[] getSelectionPaths(ActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        return selectionPaths;
    }

    private boolean shouldBeEnabled(TreePath[] selectionPaths) {
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (!this.canSave(node)) continue;
            return true;
        }
        return false;
    }

    private boolean canSave(GTreeNode node) {
        if (node instanceof FileArchiveNode || node instanceof ProjectArchiveNode) {
            ArchiveNode archiveNode = (ArchiveNode)node;
            Archive archive = archiveNode.getArchive();
            return archive.isChanged() && archive.isSavable();
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        TreePath[] selectionPaths;
        GTree gTree = (GTree)context.getContextObject();
        for (TreePath path : selectionPaths = gTree.getSelectionPaths()) {
            ArchiveNode archiveNode;
            Archive archive;
            Object node = path.getLastPathComponent();
            if (!(node instanceof ArchiveNode) || !(archive = (archiveNode = (ArchiveNode)((Object)node)).getArchive()).isChanged()) continue;
            this.saveArchive(archive);
        }
    }

    private void saveFileArchive(FileArchive archive) {
        try {
            archive.save();
        }
        catch (IOException ioe) {
            Msg.showError((Object)((Object)this), (Component)this.plugin.getProvider().getComponent(), (String)"Unable to Save File", (Object)("Unexpected exception attempting to save archive: " + archive), (Throwable)ioe);
        }
    }

    private void saveProjectArchive(ProjectArchive archive) {
        DataTypeManagerHandler dtmHandler = this.plugin.getDataTypeManagerHandler();
        dtmHandler.save((UndoableDomainObject)archive.getDomainObject());
    }

    private void saveArchive(Archive archive) {
        if (archive instanceof ProjectArchive) {
            this.saveProjectArchive((ProjectArchive)archive);
        } else if (archive instanceof FileArchive) {
            this.saveFileArchive((FileArchive)archive);
        } else {
            throw new IllegalArgumentException(archive.getName() + " must be Project or File archive.");
        }
    }
}

