/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class CreateEnumFromSelectionAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public CreateEnumFromSelectionAction(DataTypeManagerPlugin plugin) {
        super("Enum from Selection", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Create Enum From Selection"}, null, "Edit"));
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "CreateEnumFromSelection"));
        this.setEnabled(true);
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        GTree gtree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length <= 1) {
            return false;
        }
        return !this.containsInvalidNodes(selectionPaths);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(ActionContext context) {
        void var9_16;
        void var9_14;
        final GTree gTree = (GTree)context.getContextObject();
        TreePath[] paths = gTree.getSelectionPaths();
        Enum[] enumArray = new Enum[paths.length];
        int i = 0;
        for (TreePath treePath : paths) {
            GTreeNode node = (GTreeNode)treePath.getLastPathComponent();
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            enumArray[i++] = (Enum)dataTypeNode.getDataType();
        }
        Category category = null;
        DataTypeManager[] dataTypeManagers = this.plugin.getDataTypeManagers();
        DataTypeManager myDataTypeManager = null;
        for (DataTypeManager dataTypeManager : dataTypeManagers) {
            if (!(dataTypeManager instanceof ProgramDataTypeManager) || (category = (myDataTypeManager = dataTypeManager).getCategory(CategoryPath.ROOT)) != null) continue;
            Msg.error((Object)((Object)this), (Object)"Could not find program data type manager");
            return;
        }
        String string = "";
        PluginTool tool = this.plugin.getTool();
        while (var9_14.equals("")) {
            InputDialog inputDialog = new InputDialog("Name new ENUM", "Please enter a name for the new ENUM: ");
            tool = this.plugin.getTool();
            tool.showDialog((DialogComponentProvider)inputDialog);
            if (inputDialog.isCanceled()) {
                return;
            }
            String string2 = inputDialog.getValue();
        }
        DataType dt = myDataTypeManager.getDataType(category.getCategoryPath(), (String)var9_14);
        while (dt != null) {
            InputDialog dupInputDialog = new InputDialog("Duplicate ENUM Name", "Please enter a unique name for the new ENUM: ");
            tool = this.plugin.getTool();
            tool.showDialog((DialogComponentProvider)dupInputDialog);
            if (dupInputDialog.isCanceled()) {
                return;
            }
            String string3 = dupInputDialog.getValue();
            dt = myDataTypeManager.getDataType(category.getCategoryPath(), string3);
        }
        this.createNewEnum(category, enumArray, (String)var9_16);
        myDataTypeManager.flushEvents();
        final String parentNodeName = myDataTypeManager.getName();
        void newNodeName = var9_16;
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ String val$newNodeName;
            {
                this.val$newNodeName = string2;
            }

            @Override
            public void run() {
                GTreeNode rootNode = gTree.getViewRoot();
                gTree.setSelectedNodeByNamePath(new String[]{rootNode.getName(), parentNodeName, this.val$newNodeName});
            }
        });
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        GTree gtree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length <= 1) {
            return false;
        }
        return !this.containsInvalidNodes(selectionPaths);
    }

    private boolean containsInvalidNodes(TreePath[] selectionPaths) {
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (!(node instanceof DataTypeNode)) {
                return true;
            }
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            DataType dataType = dataTypeNode.getDataType();
            if (dataType instanceof Enum) continue;
            return true;
        }
        return false;
    }

    public void createNewEnum(Category category, Enum[] enumArray, String newName) {
        int maxEnumSize = 1;
        for (Enum element : enumArray) {
            if (maxEnumSize >= element.getLength()) continue;
            maxEnumSize = element.getLength();
        }
        SourceArchive sourceArchive = category.getDataTypeManager().getLocalSourceArchive();
        EnumDataType dataType = new EnumDataType(category.getCategoryPath(), newName, maxEnumSize, category.getDataTypeManager());
        for (Enum element : enumArray) {
            String[] names;
            for (String name : names = element.getNames()) {
                dataType.add(name, element.getValue(name));
            }
        }
        dataType.setSourceArchive(sourceArchive);
        int id = category.getDataTypeManager().startTransaction("Create New Enum Data Type");
        category.getDataTypeManager().addDataType((DataType)dataType, DataTypeConflictHandler.REPLACE_HANDLER);
        category.getDataTypeManager().endTransaction(id, true);
    }
}

