/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ConflictHandlerModesAction
extends MultiStateDockingAction<DataTypeConflictHandler.ConflictResolutionPolicy> {
    public ConflictHandlerModesAction(DataTypeManagerPlugin plugin) {
        super("Data Type Conflict Resolution Mode", plugin.getName());
        this.setGroup("conflicts");
        HelpLocation conflictModesHelpLocation = new HelpLocation(plugin.getName(), "conflict_mode");
        this.setHelpLocation(conflictModesHelpLocation);
        ImageIcon renameAndAddIcon = ResourceManager.loadImage((String)"images/conflictRename.png");
        ImageIcon useExistingIcon = ResourceManager.loadImage((String)"images/conflictKeep.png");
        ImageIcon replaceExistingIcon = ResourceManager.loadImage((String)"images/conflictReplace.png");
        ImageIcon replaceDefaultIcon = ResourceManager.loadImage((String)"images/conflictReplaceOrRename.png");
        ActionState renameAndAddState = new ActionState("Rename New or Moved Data Type", (Icon)renameAndAddIcon, (Object)DataTypeConflictHandler.ConflictResolutionPolicy.RENAME_AND_ADD);
        renameAndAddState.setHelpLocation(conflictModesHelpLocation);
        ActionState useExistingState = new ActionState("Use Existing Data Type", (Icon)useExistingIcon, (Object)DataTypeConflictHandler.ConflictResolutionPolicy.USE_EXISTING);
        useExistingState.setHelpLocation(conflictModesHelpLocation);
        ActionState replaceExistingState = new ActionState("Replace Existing Data Type", (Icon)replaceExistingIcon, (Object)DataTypeConflictHandler.ConflictResolutionPolicy.REPLACE_EXISTING);
        replaceExistingState.setHelpLocation(conflictModesHelpLocation);
        ActionState replaceDefaultState = new ActionState("Replace Empty Structures else Rename", (Icon)replaceDefaultIcon, (Object)DataTypeConflictHandler.ConflictResolutionPolicy.REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD);
        replaceDefaultState.setHelpLocation(conflictModesHelpLocation);
        this.addActionState(renameAndAddState);
        this.addActionState(useExistingState);
        this.addActionState(replaceExistingState);
        this.addActionState(replaceDefaultState);
        this.setCurrentActionState(renameAndAddState);
        this.setEnabled(true);
    }

    public void actionStateChanged(ActionState<DataTypeConflictHandler.ConflictResolutionPolicy> newActionState, EventTrigger trigger) {
    }
}

