/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.KeyBindingPrecedence;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.util.exception.UsrException;
import javax.swing.KeyStroke;

public class PointerAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Create Pointer";
    private static final String GROUP_NAME = "3_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Create a pointer(s) on the selection";
    private static final DataType POINTER_DT = new PointerDataType();
    private static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(80, 0);

    public PointerAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Create Pointer", GROUP_NAME, null, null, null);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(KEY_STROKE, KeyBindingPrecedence.DefaultLevel));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        try {
            this.model.add(POINTER_DT);
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage());
        }
        this.requestTableFocus();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return this.model.getRowCount() > 0 && this.model.hasSelection() && this.model.isContiguousSelection();
    }

    @Override
    public void adjustEnablement() {
        boolean hasSelection = this.model.hasSelection();
        boolean enable = this.model.getRowCount() > 0 && (!hasSelection || hasSelection && this.model.isContiguousSelection());
        this.setEnabled(enable);
    }
}

