/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.archive;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.core.archive.ArchiveDialog;
import ghidra.app.plugin.core.archive.ArchiveTask;
import ghidra.app.plugin.core.archive.RestoreDialog;
import ghidra.app.plugin.core.archive.RestoreTask;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskListener;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Archiving", shortDescription="Archives/restores projects", description="The archive plugin provides a menu action from the project window allowing the user to archive a project or restore an archived project. ")
public class ArchivePlugin
extends Plugin
implements ApplicationLevelOnlyPlugin,
ProjectListener {
    private static final String PROJECT_GROUP_C_2 = "CProject2";
    static final String LAST_ARCHIVE_DIR = "last.project.archive.dir";
    static final String TOOL_RUNNING_TITLE = "Cannot Archive while Tools are Running";
    static final String GROUP_NAME = "Archiving";
    static final String ARCHIVE_EXTENSION = ".gar";
    static final String DOT_DOT_DOT = ". . .";
    static final String TOOLS_FOLDER_NAME = "tools";
    static final String GROUPS_FOLDER_NAME = "groups";
    static final String SAVE_FOLDER_NAME = "save";
    static final String ARCHIVE_ERROR_TITLE = "Error Archiving Project";
    static final String RESTORE_ERROR_TITLE = "Error Restoring Project";
    static final String DB_LOCK_EXT = ".ulock";
    static final String JAR_VERSION_TAG = "JAR_FORMAT";
    static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy_MM_dd");
    static final String PROJECT_PROPERTY_FILE = "project.prp";
    static final String PROJECT_STATE_FILE = "projectState";
    static final String OLD_PROJECT_SAVE_DIR = "save";
    static final String OLD_PROJECT_GROUPS_DIR = "groups";
    static final String OLD_FOLDER_PROPERTIES_FILE = ".properties";
    private ArchiveDialog archiveDialog;
    private RestoreDialog restoreDialog;
    private String lastRestoreArchivePathName;
    private ProjectLocator lastRestoreLocator;
    private DockingAction archiveAction;
    private DockingAction restoreAction;
    private volatile boolean isArchiving;
    private volatile boolean isRestoring;
    private TaskListener archivingListener;
    private TaskListener restoringListener;

    public ArchivePlugin(PluginTool tool) {
        super(tool);
        this.setupActions();
    }

    public void dispose() {
        super.dispose();
    }

    public void projectClosed(Project project) {
        this.archiveAction.setEnabled(false);
        this.restoreAction.setEnabled(true);
    }

    public void projectOpened(Project project) {
        this.archiveAction.setEnabled(true);
        this.restoreAction.setEnabled(false);
    }

    boolean isArchiving() {
        return this.isArchiving;
    }

    boolean isRestoring() {
        return this.isRestoring;
    }

    private void setupActions() {
        this.archiveAction = new DockingAction("Archive Project", this.getName()){

            public void actionPerformed(ActionContext context) {
                ArchivePlugin.this.archiveProject();
            }
        };
        ProjectManager projectManager = this.tool.getProjectManager();
        String[] archiveMenuPath = new String[]{"&File", "Archive Current Project..."};
        this.archiveAction.setMenuBarData(new MenuData(archiveMenuPath, PROJECT_GROUP_C_2));
        this.archiveAction.setEnabled(projectManager.getActiveProject() != null);
        this.archiveAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "Archive_Project"));
        this.restoreAction = new DockingAction("Restore Archived Project", this.getName()){

            public void actionPerformed(ActionContext context) {
                ArchivePlugin.this.restoreProject();
            }
        };
        String[] restoreMenuPath = new String[]{"&File", "Restore Project..."};
        this.restoreAction.setMenuBarData(new MenuData(restoreMenuPath, PROJECT_GROUP_C_2));
        this.restoreAction.setEnabled(projectManager.getActiveProject() == null);
        this.restoreAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "Restore_Project"));
        if (this.tool instanceof FrontEndTool) {
            this.tool.addAction((DockingActionIf)this.archiveAction);
            this.tool.addAction((DockingActionIf)this.restoreAction);
            ((FrontEndTool)this.tool).addProjectListener((ProjectListener)this);
        }
        if (this.tool.getProject() == null) {
            this.archiveAction.setEnabled(false);
        } else {
            this.restoreAction.setEnabled(false);
        }
    }

    private void archiveProject() {
        String archivePathName;
        ProjectLocator projectLocator;
        FrontEndTool feTool = (FrontEndTool)this.tool;
        Project activeProject = AppInfo.getActiveProject();
        if (activeProject.getToolManager().getRunningTools().length > 0) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.tool.getToolFrame(), (String)TOOL_RUNNING_TITLE, (Object)"You must close running tools before starting the archive process.");
            return;
        }
        activeProject.saveToolTemplate("FRONTEND", feTool.saveToolToToolTemplate());
        activeProject.save();
        if (this.archiveDialog == null) {
            this.archiveDialog = new ArchiveDialog(this);
        }
        if (!this.archiveDialog.showDialog(projectLocator = activeProject.getProjectLocator(), archivePathName = this.getArchivePathName(projectLocator), this.tool)) {
            return;
        }
        archivePathName = this.archiveDialog.getArchivePathName();
        File archiveJar = new File(archivePathName);
        File parentFile = archiveJar.getParentFile();
        Preferences.setProperty((String)LAST_ARCHIVE_DIR, (String)parentFile.getAbsolutePath());
        this.isArchiving = true;
        this.archivingListener = new TaskListener(){

            public void taskCompleted(Task task) {
                ArchivePlugin.this.isArchiving = false;
            }

            public void taskCancelled(Task task) {
                ArchivePlugin.this.isArchiving = false;
            }
        };
        ArchiveTask task = new ArchiveTask(activeProject, archiveJar);
        task.addTaskListener(this.archivingListener);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
    }

    private String getArchivePathName(ProjectLocator projectLocator) {
        String defaultDirString = projectLocator.getLocation();
        Object dirString = Preferences.getProperty((String)LAST_ARCHIVE_DIR, (String)defaultDirString);
        String dateString = formatter.format(new Date());
        String projectName = projectLocator.getName();
        if (!((String)dirString).endsWith(File.separator)) {
            dirString = (String)dirString + File.separator;
        }
        return (String)dirString + projectName + "_" + dateString + ARCHIVE_EXTENSION;
    }

    private void restoreProject() {
        ProjectLocator locator;
        String archiveName;
        if (this.restoreDialog == null) {
            this.restoreDialog = new RestoreDialog(this);
        }
        if (!this.restoreDialog.showDialog(archiveName = this.lastRestoreArchivePathName, locator = this.lastRestoreLocator)) {
            return;
        }
        this.lastRestoreArchivePathName = this.restoreDialog.getArchivePathName();
        this.lastRestoreLocator = this.restoreDialog.getRestoreURL();
        File archiveJar = new File(this.lastRestoreArchivePathName);
        try {
            if (!this.isJarFormat(archiveJar)) {
                Msg.showError((Object)((Object)this), null, (String)"File Format Error", (Object)("Can't read the file: " + this.lastRestoreArchivePathName));
                return;
            }
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"File Format Error", (Object)("Can't read the file: " + this.lastRestoreArchivePathName), (Throwable)e);
            return;
        }
        this.isRestoring = true;
        this.restoringListener = new TaskListener(){

            public void taskCompleted(Task task) {
                ArchivePlugin.this.isRestoring = false;
            }

            public void taskCancelled(Task task) {
                ArchivePlugin.this.isRestoring = false;
            }
        };
        RestoreTask task = new RestoreTask(this.lastRestoreLocator, archiveJar, this);
        task.addTaskListener(this.restoringListener);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
    }

    private boolean isJarFormat(File jarFile) throws IOException {
        JarInputStream jarIn = new JarInputStream(new FileInputStream(jarFile));
        JarEntry entry = jarIn.getNextJarEntry();
        entry = jarIn.getNextJarEntry();
        String format = entry.getName();
        jarIn.close();
        return format.equalsIgnoreCase(JAR_VERSION_TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getProjectName(String archivePathName) {
        if (archivePathName == null) {
            return null;
        }
        File archiveFile = new File(archivePathName);
        FileInputStream fileIn = null;
        ZipInputStream jarIn = null;
        try {
            ZipEntry zipEntry;
            fileIn = new FileInputStream(archiveFile);
            jarIn = new JarInputStream(fileIn);
            while ((zipEntry = ((JarInputStream)jarIn).getNextEntry()) != null) {
                String projectName;
                String name = zipEntry.getName();
                jarIn.closeEntry();
                if (!name.endsWith(ProjectLocator.getProjectExtension())) continue;
                int endIndex = name.length() - ProjectLocator.getProjectExtension().length();
                String string = projectName = name.substring(0, endIndex);
                return string;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (jarIn != null) {
                try {
                    jarIn.close();
                }
                catch (IOException iOException) {}
            }
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    void cleanupRestoredProject(ProjectLocator projectLocator) {
        ProjectManager projectManager = this.tool.getProjectManager();
        if (!projectManager.deleteProject(projectLocator)) {
            Msg.showError((Object)((Object)this), null, (String)"All Files in Project not Removed", (Object)("Not all files have been deleted from project " + projectLocator.getName()));
        }
    }
}

