/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ContextEvaluatorAdapter;
import ghidra.program.util.VarnodeContext;

public class ConstantPropagationContextEvaluator
extends ContextEvaluatorAdapter {
    protected AddressSet destSet = new AddressSet();
    private boolean trustMemoryWrite = false;
    private long minStoreLoadOffset = 4L;
    private long minSpeculativeOffset = 1024L;
    private long maxSpeculativeOffset = 256L;

    public ConstantPropagationContextEvaluator() {
    }

    public ConstantPropagationContextEvaluator(boolean trustMemoryWrite) {
        this.trustMemoryWrite = trustMemoryWrite;
    }

    public ConstantPropagationContextEvaluator(boolean trustWriteMemOption, long minStoreLoadRefAddress, long minSpeculativeRefAddress, long maxSpeculativeRefAddress) {
        this(trustWriteMemOption);
        this.minStoreLoadOffset = minStoreLoadRefAddress;
        this.minSpeculativeOffset = minSpeculativeRefAddress;
        this.maxSpeculativeOffset = maxSpeculativeRefAddress;
    }

    public AddressSet getDestinationSet() {
        return this.destSet;
    }

    @Override
    public Address evaluateConstant(VarnodeContext context, Instruction instr, int pcodeop, Address constant, int size, RefType refType) {
        AddressSpace space = constant.getAddressSpace();
        long maxAddrOffset = space.getMaxAddress().getOffset();
        long wordOffset = constant.getOffset();
        if ((wordOffset >= 0L && wordOffset < this.minSpeculativeOffset || Math.abs(maxAddrOffset - wordOffset) < this.maxSpeculativeOffset) && !space.isExternalSpace()) {
            return null;
        }
        if (wordOffset == 0xFFFFFFFFL || wordOffset == 65535L || wordOffset == -1L) {
            return null;
        }
        return constant;
    }

    @Override
    public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, RefType refType) {
        boolean isKnownReference;
        if (refType.isCall() && !refType.isComputed() && pcodeop == 0) {
            return true;
        }
        AddressSpace space = address.getAddressSpace();
        if (space.isExternalSpace()) {
            return true;
        }
        long maxAddrOffset = space.getMaxAddress().getAddressableWordOffset();
        long wordOffset = address.getAddressableWordOffset();
        boolean bl = isKnownReference = !address.isConstantAddress();
        if (pcodeop != 1 && (wordOffset >= 0L && wordOffset < this.minStoreLoadOffset || Math.abs(maxAddrOffset - wordOffset) < this.minStoreLoadOffset)) {
            if (!isKnownReference) {
                return false;
            }
            PcodeOp[] pcode = instr.getPcode();
            if (pcode.length > 1) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
        FlowType flowType = instruction.getFlowType();
        if (!flowType.isJump()) {
            return false;
        }
        Reference[] refs = instruction.getReferencesFrom();
        if (refs.length <= 0 || refs.length == 1 && refs[0].getReferenceType().isData()) {
            this.destSet.addRange(instruction.getMinAddress(), instruction.getMinAddress());
        }
        return false;
    }

    @Override
    public boolean allowAccess(VarnodeContext context, Address addr) {
        return this.trustMemoryWrite;
    }
}

