/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractDemanglerAnalyzer
extends AbstractAnalyzer {
    private static final AddressSetView EXTERNAL_SET = new AddressSet(AddressSpace.EXTERNAL_SPACE.getMinAddress(), AddressSpace.EXTERNAL_SPACE.getMaxAddress());

    public AbstractDemanglerAnalyzer(String name, String description) {
        super(name, description, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.before().before().before());
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean canAnalyze(Program program) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            monitor.setIndeterminate(true);
            boolean bl = this.doAdded(program, set, monitor, log);
            return bl;
        }
        finally {
            monitor.setIndeterminate(false);
        }
    }

    private boolean doAdded(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        DemanglerOptions options = this.getOptions();
        if (!this.validateOptions(options, log)) {
            log.appendMsg(this.getName(), "Invalid demangler options--cannot demangle");
            return false;
        }
        boolean demangleExternals = set.contains(EXTERNAL_SET.getMinAddress());
        if (demangleExternals) {
            set = set.subtract(EXTERNAL_SET);
        }
        String baseMonitorMessage = monitor.getMessage();
        int memorySymbolCount = this.demangleSymbols(program, set, 0, baseMonitorMessage, options, log, monitor);
        if (demangleExternals) {
            this.demangleSymbols(program, EXTERNAL_SET, memorySymbolCount, baseMonitorMessage, options, log, monitor);
        }
        return true;
    }

    private int demangleSymbols(Program program, AddressSetView set, int initialCount, String baseMonitorMessage, DemanglerOptions options, MessageLog log, TaskMonitor monitor) throws CancelledException {
        int count = initialCount;
        SymbolTable symbolTable = program.getSymbolTable();
        SymbolIterator it = symbolTable.getPrimarySymbolIterator(set, true);
        while (it.hasNext()) {
            Address address;
            String mangled;
            DemangledObject demangled;
            Symbol symbol;
            monitor.checkCanceled();
            if (++count % 100 == 0) {
                monitor.setMessage(baseMonitorMessage + " - " + count + " symbols");
            }
            if (this.skipSymbol(symbol = it.next()) || (demangled = this.demangle(mangled = this.cleanSymbol(address = symbol.getAddress(), symbol.getName()), address, options, log)) == null) continue;
            this.apply(program, address, demangled, options, log, monitor);
        }
        return count;
    }

    protected abstract DemangledObject doDemangle(String var1, DemanglerOptions var2, MessageLog var3) throws DemangledException;

    protected boolean validateOptions(DemanglerOptions options, MessageLog log) {
        return true;
    }

    protected boolean skipSymbol(Symbol symbol) {
        Function function;
        if (symbol.getSource() == SourceType.DEFAULT) {
            return true;
        }
        Namespace parentNamespace = symbol.getParentNamespace();
        if (symbol.isExternal() ? !(parentNamespace instanceof Library) : !parentNamespace.isGlobal()) {
            return true;
        }
        return symbol.getSymbolType() == SymbolType.FUNCTION && !(function = (Function)symbol.getObject()).isThunk() && function.getSignatureSource().isHigherPriorityThan(SourceType.ANALYSIS);
    }

    protected DemanglerOptions getOptions() {
        DemanglerOptions options = new DemanglerOptions();
        options.setApplySignature(true);
        options.setApplyCallingConvention(true);
        options.setDoDisassembly(true);
        options.setDemangleOnlyKnownPatterns(false);
        return options;
    }

    protected DemangledObject demangle(String mangled, Address address, DemanglerOptions options, MessageLog log) {
        DemangledObject demangled = null;
        try {
            demangled = this.doDemangle(mangled, options, log);
        }
        catch (Throwable e) {
            if (e instanceof DemangledException && ((DemangledException)e).isInvalidMangledName()) {
                return null;
            }
            log.appendMsg(this.getName(), "Unable to demangle symbol: " + mangled + " at " + address + ".  Message: " + e.getMessage());
            return null;
        }
        return demangled;
    }

    protected void apply(Program program, Address address, DemangledObject demangled, DemanglerOptions options, MessageLog log, TaskMonitor monitor) {
        try {
            if (demangled.applyTo(program, address, options, monitor)) {
                return;
            }
            String errorString = demangled.getErrorMessage();
            this.logApplyErrorMessage(log, demangled, address, null, errorString);
        }
        catch (Exception e) {
            this.logApplyErrorMessage(log, demangled, address, e, null);
        }
    }

    private void logApplyErrorMessage(MessageLog log, DemangledObject demangled, Address address, Exception exception, String errorString) {
        Object name;
        Object message;
        if (exception != null) {
            message = ExceptionUtils.getMessage((Throwable)exception);
            name = "";
        } else if (errorString != null) {
            message = errorString;
            name = "";
        } else {
            message = "Unknown error at address " + address;
            name = "\n\t" + demangled.getName();
        }
        String className = demangled.getClass().getSimpleName();
        log.appendMsg(this.getName(), "Apply failure (" + className + ": " + (String)message + ")\n\t" + demangled.getMangledString() + (String)name);
    }

    protected String cleanSymbol(Address address, String name) {
        return SymbolUtilities.getCleanSymbolName((String)name, (Address)address);
    }
}

