/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin;

import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;

public abstract class ProgramPlugin
extends Plugin {
    protected Program currentProgram;
    protected ProgramLocation currentLocation;
    protected ProgramSelection currentSelection;
    protected ProgramSelection currentHighlight;

    public ProgramPlugin(PluginTool plugintool) {
        super(plugintool);
        this.internalRegisterEventConsumed(ProgramActivatedPluginEvent.class);
        this.internalRegisterEventConsumed(ProgramLocationPluginEvent.class);
        this.internalRegisterEventConsumed(ProgramSelectionPluginEvent.class);
        this.internalRegisterEventConsumed(ProgramHighlightPluginEvent.class);
        this.internalRegisterEventConsumed(ProgramOpenedPluginEvent.class);
        this.internalRegisterEventConsumed(ProgramClosedPluginEvent.class);
    }

    @Deprecated(forRemoval=true, since="10.2")
    public ProgramPlugin(PluginTool plugintool, boolean consumeLocationChange, boolean consumeSelectionChange) {
        this(plugintool);
    }

    @Deprecated(forRemoval=true, since="10.2")
    public ProgramPlugin(PluginTool plugintool, boolean consumeLocationChange, boolean consumeSelectionChange, boolean consumeHighlightChange) {
        this(plugintool);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent ev = (ProgramClosedPluginEvent)event;
            this.programClosed(ev.getProgram());
        } else if (event instanceof ProgramOpenedPluginEvent) {
            ProgramOpenedPluginEvent ev = (ProgramOpenedPluginEvent)event;
            this.programOpened(ev.getProgram());
        } else if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program oldProgram = this.currentProgram;
            this.currentProgram = ev.getActiveProgram();
            if (oldProgram != null) {
                this.programDeactivated(oldProgram);
                this.currentLocation = null;
                this.currentSelection = null;
                this.currentHighlight = null;
                this.locationChanged(null);
                this.selectionChanged(null);
                this.highlightChanged(null);
            }
            if (this.currentProgram != null) {
                this.programActivated(this.currentProgram);
            }
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent ev = (ProgramLocationPluginEvent)event;
            this.currentLocation = ev.getLocation();
            if (this.currentLocation != null && this.currentLocation.getAddress() == null || this.currentProgram == null && ev.getProgram() == null) {
                this.currentLocation = null;
            }
            if (this.currentProgram == null) {
                return;
            }
            this.locationChanged(this.currentLocation);
        } else if (event instanceof ProgramSelectionPluginEvent) {
            ProgramSelectionPluginEvent ev = (ProgramSelectionPluginEvent)event;
            this.currentSelection = ev.getSelection();
            if (this.currentSelection != null && this.currentSelection.isEmpty()) {
                this.currentSelection = null;
            }
            this.selectionChanged(this.currentSelection);
        } else if (event instanceof ProgramHighlightPluginEvent) {
            ProgramHighlightPluginEvent ev = (ProgramHighlightPluginEvent)event;
            this.currentHighlight = ev.getHighlight();
            if (this.currentHighlight != null && this.currentHighlight.isEmpty()) {
                this.currentHighlight = null;
            }
            this.highlightChanged(this.currentHighlight);
        }
    }

    protected void programActivated(Program program) {
    }

    protected void programClosed(Program program) {
    }

    protected void programOpened(Program program) {
    }

    protected void programDeactivated(Program program) {
    }

    protected void locationChanged(ProgramLocation loc) {
    }

    protected void selectionChanged(ProgramSelection sel) {
    }

    protected void highlightChanged(ProgramSelection hl) {
    }

    protected boolean goTo(Address addr) {
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            return service.goTo(addr);
        }
        return false;
    }

    protected boolean goTo(CodeUnit cu) {
        if (cu != null) {
            this.goTo(cu.getMinAddress());
        }
        return false;
    }

    protected void setSelection(AddressSetView set) {
        if (this.currentProgram == null) {
            return;
        }
        this.firePluginEvent(new ProgramSelectionPluginEvent(this.getName(), new ProgramSelection(set), this.currentProgram));
    }

    public ProgramLocation getProgramLocation() {
        return this.currentLocation;
    }

    public Program getCurrentProgram() {
        return this.currentProgram;
    }

    public ProgramSelection getProgramSelection() {
        return this.currentSelection;
    }

    public ProgramSelection getProgramHighlight() {
        return this.currentHighlight;
    }
}

