/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public class FunctionPurgeAnalysisCmd
extends BackgroundCommand {
    private AddressSetView entryPoints;
    private Program program;
    private PrototypeModel[] nearFarModels = null;
    private static final int STDCALL_FAR = 0;
    private static final int CDECL_FAR = 1;
    private static final int STDCALL_NEAR = 2;
    private static final int CDECL_NEAR = 3;

    public FunctionPurgeAnalysisCmd(AddressSetView entries) {
        super("Compute Function Purge", true, true, false);
        this.entryPoints = entries;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        this.program = (Program)obj;
        Processor processor = this.program.getLanguage().getProcessor();
        AddressSpace defaultSpace = this.program.getLanguage().getDefaultSpace();
        if (defaultSpace.getSize() > 32 || !processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"x86"))) {
            Msg.error((Object)((Object)this), (Object)("Unsupported operation for language " + this.program.getLanguage().getLanguageID()));
            return false;
        }
        if (defaultSpace instanceof SegmentedAddressSpace) {
            this.setupNearFarModels();
        }
        AddressSetView set = this.entryPoints;
        long maxCount = set.getNumAddresses();
        monitor.setMaximum(maxCount);
        monitor.setProgress(0L);
        for (Function function : this.program.getFunctionManager().getFunctions(this.entryPoints, true)) {
            if (monitor.isCancelled()) break;
            set = set.subtract((AddressSetView)new AddressSet(this.program, this.entryPoints.getMinAddress(), function.getEntryPoint()));
            monitor.setProgress(maxCount - set.getNumAddresses());
            monitor.setMessage("Purge " + function.getName());
            try {
                this.analyzeFunction(function, monitor);
            }
            catch (CancelledException cancelledException) {}
        }
        if (monitor.isCancelled()) {
            this.setStatusMsg("Function Purge analysis cancelled");
            return false;
        }
        return true;
    }

    private void setupNearFarModels() {
        PrototypeModel[] models;
        int countModels = 0;
        this.nearFarModels = new PrototypeModel[4];
        this.nearFarModels[0] = null;
        this.nearFarModels[1] = null;
        this.nearFarModels[2] = null;
        this.nearFarModels[3] = null;
        for (PrototypeModel model : models = this.program.getCompilerSpec().getCallingConventions()) {
            if (model.isMerged()) continue;
            int pos = -1;
            if (model.getStackshift() == 4) {
                if (model.getExtrapop() == 32768) {
                    pos = 0;
                } else if (model.getExtrapop() == 4) {
                    pos = 1;
                }
            } else if (model.getStackshift() == 2) {
                if (model.getExtrapop() == 32768) {
                    pos = 2;
                } else if (model.getExtrapop() == 2) {
                    pos = 3;
                }
            }
            if (pos < 0 || this.nearFarModels[pos] != null) continue;
            this.nearFarModels[pos] = model;
            ++countModels;
        }
        if (countModels < 4) {
            Msg.warn((Object)((Object)this), (Object)"FunctionPurgeAnalysis is missing full range of near/far prototype models");
        }
    }

    private void analyzeFunction(Function function, TaskMonitor monitor) throws CancelledException {
        Instruction purgeInstruction;
        if (function == null) {
            return;
        }
        int purge = function.getStackPurgeSize();
        if ((purge == -1 || purge > 128 || purge < -128) && (purgeInstruction = this.locatePurgeInstruction(function, monitor)) != null) {
            purge = this.getPurgeValue(purgeInstruction);
            if (purge != -1) {
                function.setStackPurgeSize(purge);
            }
            this.setPrototypeModel(function, purgeInstruction);
        }
    }

    private void setPrototypeModel(Function function, Instruction purgeInstruction) {
        if (this.nearFarModels == null) {
            return;
        }
        if (purgeInstruction.getFlowType().isCall()) {
            return;
        }
        if (function.getSignatureSource() != SourceType.DEFAULT) {
            return;
        }
        PrototypeModel model = null;
        try {
            byte val = purgeInstruction.getBytes()[0];
            if (val == -61) {
                model = this.nearFarModels[3];
            } else if (val == -53) {
                model = this.nearFarModels[1];
            } else if (val == -62) {
                model = this.nearFarModels[2];
            } else if (val == -54) {
                model = this.nearFarModels[0];
            }
        }
        catch (MemoryAccessException e) {
            return;
        }
        if (model == null) {
            return;
        }
        try {
            function.setCallingConvention(model.getName());
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private Instruction locatePurgeInstruction(Function func, TaskMonitor monitor) {
        AddressSetView body = func.getBody();
        Instruction purgeInstruction = this.findPurgeInstruction(body);
        if (purgeInstruction != null) {
            return purgeInstruction;
        }
        body = CreateFunctionCmd.getFunctionBody(this.program, func.getEntryPoint(), monitor);
        return this.findPurgeInstruction(body);
    }

    private int getPurgeValue(Instruction instr) {
        if (instr.getFlowType().isCall()) {
            Reference[] referencesFrom;
            for (Reference reference : referencesFrom = instr.getReferencesFrom()) {
                Function functionAt;
                if (!reference.getReferenceType().isFlow() || (functionAt = this.program.getFunctionManager().getFunctionAt(reference.getToAddress())) == null || functionAt.hasNoReturn()) continue;
                return functionAt.getStackPurgeSize();
            }
        } else {
            int tempPurge = 0;
            Scalar scalar = instr.getScalar(0);
            if (scalar != null) {
                tempPurge = (int)scalar.getSignedValue();
            }
            return tempPurge;
        }
        return -1;
    }

    private Instruction findPurgeInstruction(AddressSetView body) {
        InstructionIterator iter = this.program.getListing().getInstructions(body, true);
        Instruction backupPurge = null;
        for (int count = 2048; iter.hasNext() && count > 0; --count) {
            Instruction instr = iter.next();
            FlowType ftype = instr.getFlowType();
            if (!ftype.isTerminal()) continue;
            String mnemonicStr = instr.getMnemonicString().toLowerCase();
            if (!"ret".equals(mnemonicStr) && !"retf".equals(mnemonicStr)) continue;
            return instr;
        }
        return backupPurge;
    }
}

