/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.formats;

import ghidra.app.cmd.data.CreateStringCmd;
import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ExportedSymbol;
import ghidra.app.util.bin.format.pef.ExportedSymbolHashSlot;
import ghidra.app.util.bin.format.pef.ExportedSymbolKey;
import ghidra.app.util.bin.format.pef.ImportedLibrary;
import ghidra.app.util.bin.format.pef.ImportedSymbol;
import ghidra.app.util.bin.format.pef.LoaderInfoHeader;
import ghidra.app.util.bin.format.pef.LoaderRelocationHeader;
import ghidra.app.util.bin.format.pef.PefException;
import ghidra.app.util.bin.format.pef.Relocation;
import ghidra.app.util.bin.format.pef.SectionHeader;
import ghidra.app.util.bin.format.pef.SectionKind;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BinaryAnalysisCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class PefBinaryAnalysisCommand
extends FlatProgramAPI
implements BinaryAnalysisCommand,
AnalysisWorker {
    private MessageLog messages = new MessageLog();

    @Override
    public boolean canApply(Program program) {
        try {
            MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider(program, false);
            new ContainerHeader(provider);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider(program, false);
        try {
            ContainerHeader header = new ContainerHeader(provider);
            header.parse();
            Address address = this.addr(0L);
            DataType headerDT = header.toDataType();
            this.createData(address, headerDT);
            this.createFragment(headerDT.getName(), address, headerDT.getLength());
            Address sectionStartAddress = address.add((long)headerDT.getLength());
            this.processSections(header, sectionStartAddress);
            this.processLoaders(header);
            return true;
        }
        catch (PefException e) {
            this.messages.appendMsg("Not a binary PEF program: ContainerHeader not found.");
            return false;
        }
    }

    @Override
    public String getWorkerName() {
        return this.getName();
    }

    @Override
    public boolean applyTo(Program program, TaskMonitor monitor) throws Exception {
        this.set(program, monitor);
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager(this.currentProgram);
        return manager.scheduleWorker(this, null, false, monitor);
    }

    @Override
    public String getName() {
        return "PEF Header Annotation";
    }

    @Override
    public MessageLog getMessages() {
        return this.messages;
    }

    private Address processSections(ContainerHeader header, Address address) throws Exception {
        this.monitor.setMessage("Sections...");
        List<SectionHeader> sections = header.getSections();
        for (SectionHeader section : sections) {
            if (this.monitor.isCancelled()) break;
            this.setPlateComment(address, section.toString());
            DataType dt = section.toDataType();
            this.createData(address, dt);
            this.createFragment(dt.getName(), address, dt.getLength());
            address = address.add((long)dt.getLength());
            this.processSectionData(section);
        }
        return address;
    }

    private void processSectionData(SectionHeader section) throws Exception {
        if (section.getSectionKind() == SectionKind.Loader) {
            return;
        }
        int size = section.getContainerLength();
        if (size == 0) {
            return;
        }
        int alignment = section.getContainerOffset() % 4;
        if (alignment != 0) {
            Msg.info((Object)this, (Object)"section alignment");
        }
        Address sectionAddr = this.toAddr(section.getContainerOffset() + alignment);
        this.createFragment("SectionData-" + section.getName(), sectionAddr, size);
    }

    private void processLoaders(ContainerHeader header) throws Exception {
        LoaderInfoHeader loader = header.getLoader();
        SectionHeader section = loader.getSection();
        Address address = this.toAddr(section.getContainerOffset());
        DataType loaderDT = loader.toDataType();
        this.createData(address, loaderDT);
        this.createFragment(loaderDT.getName(), address, loaderDT.getLength());
        this.processImportLibraries(loader);
        this.processImportedSymbols(loader);
        this.processLoaderRelocations(loader);
        this.processLoaderStringTable(loader);
        this.processLoaderExports(loader);
    }

    private void processLoaderExports(LoaderInfoHeader loader) throws Exception {
        this.monitor.setMessage("Processing loader exports...");
        Address address = this.toAddr(loader.getExportHashOffset() + loader.getSection().getContainerOffset());
        List<ExportedSymbolHashSlot> exportedHashSlots = loader.getExportedHashSlots();
        for (ExportedSymbolHashSlot exportedSymbolHashSlot : exportedHashSlots) {
            if (this.monitor.isCancelled()) break;
            DataType dt = exportedSymbolHashSlot.toDataType();
            this.createData(address, dt);
            this.createFragment(dt.getName(), address, dt.getLength());
            address = address.add((long)dt.getLength());
        }
        List<ExportedSymbolKey> exportedSymbolKeys = loader.getExportedSymbolKeys();
        for (ExportedSymbolKey key : exportedSymbolKeys) {
            if (this.monitor.isCancelled()) break;
            DataType dt = key.toDataType();
            this.createData(address, dt);
            this.createFragment(dt.getName(), address, dt.getLength());
            address = address.add((long)dt.getLength());
        }
        if (address.getOffset() % 4L != 0L) {
            Msg.info((Object)this, (Object)"here");
        }
        address = address.add(address.getOffset() % 4L);
        List<ExportedSymbol> list = loader.getExportedSymbols();
        for (ExportedSymbol symbol : list) {
            if (this.monitor.isCancelled()) break;
            this.setPlateComment(address, symbol.toString());
            DataType dt = symbol.toDataType();
            this.createData(address, dt);
            this.createFragment(dt.getName(), address, dt.getLength());
            address = address.add((long)dt.getLength());
        }
    }

    private void processLoaderStringTable(LoaderInfoHeader loader) throws Exception {
        this.monitor.setMessage("Processing loader string table...");
        Address start = this.toAddr(loader.getLoaderStringsOffset() + loader.getSection().getContainerOffset());
        Address end = this.toAddr(loader.getExportHashOffset() + loader.getSection().getContainerOffset());
        this.createFragment("LoaderStringTable", start, end.subtract(start) + 1L);
        List<ImportedLibrary> importedLibraries = loader.getImportedLibraries();
        for (ImportedLibrary importedLibrary : importedLibraries) {
            Address current = start.add((long)importedLibrary.getNameOffset());
            CreateStringCmd cmd = new CreateStringCmd(current, -1, false);
            cmd.applyTo((DomainObject)this.currentProgram);
        }
        List<ImportedSymbol> symbols = loader.getImportedSymbols();
        for (ImportedSymbol symbol : symbols) {
            Address current = start.add((long)symbol.getSymbolNameOffset());
            CreateStringCmd cmd = new CreateStringCmd(current, -1, false);
            cmd.applyTo((DomainObject)this.currentProgram);
        }
        List<ExportedSymbolKey> list = loader.getExportedSymbolKeys();
        List<ExportedSymbol> exportedSymbols = loader.getExportedSymbols();
        for (int i = 0; i < exportedSymbols.size(); ++i) {
            Address current = start.add((long)exportedSymbols.get(i).getNameOffset());
            CreateStringCmd cmd = new CreateStringCmd(current, list.get(i).getNameLength(), false);
            cmd.applyTo((DomainObject)this.currentProgram);
        }
    }

    private Address processLoaderRelocations(LoaderInfoHeader loader) throws Exception {
        long offset = loader.getSection().getContainerOffset() + 56 + loader.getImportedLibraryCount() * 24 + loader.getTotalImportedSymbolCount() * 4;
        Address address = this.toAddr(offset);
        this.monitor.setMessage("Processing loader relocation...");
        for (LoaderRelocationHeader loaderRelocation : loader.getRelocations()) {
            if (this.monitor.isCancelled()) break;
            DataType dt = loaderRelocation.toDataType();
            this.createData(address, dt);
            this.createFragment(dt.getName(), address, dt.getLength());
            address = address.add((long)dt.getLength());
            address = this.processRelocation(address, loaderRelocation);
        }
        return address;
    }

    private Address processRelocation(Address address, LoaderRelocationHeader loaderRelocation) throws Exception {
        this.monitor.setMessage("Processing relocations...");
        List<Relocation> relocations = loaderRelocation.getRelocations();
        for (Relocation relocation : relocations) {
            if (this.monitor.isCancelled()) break;
            DataType dt = relocation.toDataType();
            this.createData(address, dt);
            this.createFragment("Relocation", address, dt.getLength());
            address = address.add((long)dt.getLength());
        }
        return address;
    }

    private Address processImportedSymbols(LoaderInfoHeader loader) throws DuplicateNameException, IOException, Exception {
        long offset = loader.getSection().getContainerOffset() + 56 + loader.getImportedLibraryCount() * 24;
        Address address = this.toAddr(offset);
        this.monitor.setMessage("Processing symbol table entries...");
        List<ImportedSymbol> importedSymbols = loader.getImportedSymbols();
        for (int i = 0; i < importedSymbols.size(); ++i) {
            ImportedSymbol symbol = importedSymbols.get(i);
            if (this.monitor.isCancelled()) break;
            this.setPlateComment(address, "0x" + Integer.toHexString(i) + " " + symbol.toString());
            DataType dt = symbol.toDataType();
            this.createData(address, dt);
            this.createFragment(dt.getName(), address, dt.getLength());
            address = address.add((long)dt.getLength());
        }
        return address;
    }

    private Address processImportLibraries(LoaderInfoHeader loader) throws DuplicateNameException, IOException, Exception {
        long offset = loader.getSection().getContainerOffset() + 56;
        Address address = this.toAddr(offset);
        this.monitor.setMessage("Processing imported libraries...");
        for (ImportedLibrary library : loader.getImportedLibraries()) {
            if (this.monitor.isCancelled()) break;
            this.setPlateComment(address, library.toString());
            DataType dt = library.toDataType();
            this.createData(address, dt);
            this.createFragment(dt.getName(), address, dt.getLength());
            address = address.add((long)dt.getLength());
        }
        return address;
    }

    private Address addr(long offset) {
        return this.currentProgram.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
    }
}

