/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.NotFoundException;
import org.apache.commons.lang3.StringUtils;

public class AARCH64_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 183;
    }

    public int getRelrRelocationType() {
        return 1027;
    }

    public void relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 183) {
            return;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int type = relocation.getType();
        if (type == 0) {
            return;
        }
        int symbolIndex = relocation.getSymbolIndex();
        long addend = relocation.getAddend();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        String symbolName = sym.getNameAsString();
        long offset = (int)relocationAddress.getOffset();
        boolean isBigEndianInstructions = program.getLanguage().getLanguageDescription().getInstructionEndian().isBigEndian();
        boolean is64bit = true;
        Address symbolAddr = elfRelocationContext.getSymbolAddress(sym);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        long newValue = 0L;
        switch (type) {
            case 257: {
                newValue = symbolValue + addend;
                memory.setLong(relocationAddress, newValue);
                if (addend == 0L) break;
                AARCH64_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                AARCH64_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 1: 
            case 258: {
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, (int)(newValue & 0xFFFFFFFFFFFFFFFFL));
                break;
            }
            case 2: 
            case 259: {
                newValue = symbolValue + addend;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFFL));
                break;
            }
            case 260: {
                newValue = symbolValue + addend;
                memory.setLong(relocationAddress, newValue -= offset);
                break;
            }
            case 3: 
            case 261: {
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, (int)((newValue -= offset) & 0xFFFFFFFFFFFFFFFFL));
                break;
            }
            case 4: 
            case 262: {
                newValue = symbolValue + addend;
                memory.setShort(relocationAddress, (short)((newValue -= offset) & 0xFFFFL));
                break;
            }
            case 11: 
            case 275: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = this.PG(symbolValue + addend) - this.PG(offset) >> 12 & 0x1FFFFFL;
                newValue = (long)(oldValue & 0x9F00001F) | newValue << 3 & 0xFFFFE0L | (newValue & 3L) << 29;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case 12: 
            case 277: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend) & 0xFFF;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case 13: 
            case 278: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend) & 0xFFF;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case 20: 
            case 21: 
            case 282: 
            case 283: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = symbolValue + addend;
                newValue -= offset;
                newValue = (long)oldValue | newValue >> 2 & 0x3FFFFFFL;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case 14: 
            case 284: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend & 0xFFEL) >> 1;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case 15: 
            case 285: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend & 0xFFCL) >> 2;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case 16: 
            case 286: 
            case 312: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend & 0xFF8L) >> 3;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case 299: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend & 0xFF0L) >> 4;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case 181: {
                is64bit = false;
            }
            case 1025: {
                if (elfRelocationContext.extractAddend()) {
                    addend = this.getValue(memory, relocationAddress, is64bit);
                }
                newValue = symbolValue + addend;
                this.setValue(memory, relocationAddress, newValue, is64bit);
                break;
            }
            case 182: {
                is64bit = false;
            }
            case 1026: {
                Function extFunction;
                boolean isExternalSym;
                Address symAddress = elfRelocationContext.getSymbolAddress(sym);
                MemoryBlock block = memory.getBlock(symAddress);
                boolean isPltSym = block != null && block.getName().startsWith(".plt");
                boolean bl = isExternalSym = block != null && "EXTERNAL".equals(block.getName());
                if (!isPltSym) {
                    this.setValue(memory, relocationAddress, symAddress.getOffset(), is64bit);
                }
                if (!isPltSym && !isExternalSym || StringUtils.isBlank((CharSequence)symbolName) || (extFunction = elfRelocationContext.getLoadHelper().createExternalFunctionLinkage(symbolName, symAddress, null)) != null) break;
                AARCH64_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)"R_AARCH64_JUMP_SLOT", (String)symbolName, (String)"Failed to create R_AARCH64_JUMP_SLOT external function", (MessageLog)elfRelocationContext.getLog());
                return;
            }
            case 183: {
                is64bit = false;
            }
            case 1027: {
                if (elfRelocationContext.extractAddend()) {
                    addend = this.getValue(memory, relocationAddress, is64bit);
                }
                newValue = elfRelocationContext.getImageBaseWordAdjustmentOffset() + addend;
                this.setValue(memory, relocationAddress, newValue, is64bit);
                break;
            }
            case 180: 
            case 1024: {
                AARCH64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_AARCH64_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)elfRelocationContext.getLog());
            }
            default: {
                AARCH64_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
            }
        }
    }

    private void setValue(Memory memory, Address addr, long value, boolean is64bit) throws MemoryAccessException {
        if (is64bit) {
            memory.setLong(addr, value);
        } else {
            memory.setInt(addr, (int)value);
        }
    }

    private long getValue(Memory memory, Address addr, boolean is64bit) throws MemoryAccessException {
        if (is64bit) {
            return memory.getLong(addr);
        }
        return memory.getInt(addr);
    }

    long PG(long addr) {
        return addr & 0xFFFFFFFFFFFFF000L;
    }
}

